/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.gateways.gate;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.shadowsoffire.gateways.GatewayObjects;
import dev.shadowsoffire.gateways.entity.GatewayEntity;
import dev.shadowsoffire.gateways.event.GateEvent;
import dev.shadowsoffire.gateways.gate.GateRules;
import dev.shadowsoffire.gateways.gate.Reward;
import dev.shadowsoffire.gateways.gate.WaveEntity;
import dev.shadowsoffire.gateways.gate.WaveModifier;
import dev.shadowsoffire.gateways.net.ParticleMessage;
import dev.shadowsoffire.placebo.codec.PlaceboCodecs;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.eventbus.api.Event;

public record Wave(List<WaveEntity> entities, List<WaveModifier> modifiers, List<Reward> rewards, int maxWaveTime, int setupTime) {
    public static Codec<Wave> CODEC = RecordCodecBuilder.create(inst -> inst.group((App)WaveEntity.CODEC.listOf().fieldOf("entities").forGetter(Wave::entities), (App)PlaceboCodecs.nullableField((Codec)WaveModifier.CODEC.listOf(), (String)"modifiers", Collections.emptyList()).forGetter(Wave::modifiers), (App)PlaceboCodecs.nullableField((Codec)Reward.CODEC.listOf(), (String)"rewards", Collections.emptyList()).forGetter(Wave::rewards), (App)Codec.INT.fieldOf("max_wave_time").forGetter(Wave::maxWaveTime), (App)Codec.INT.fieldOf("setup_time").forGetter(Wave::setupTime)).apply((Applicative)inst, Wave::new));

    public List<LivingEntity> spawnWave(ServerLevel level, Vec3 pos, GatewayEntity gate) {
        ArrayList<LivingEntity> spawned = new ArrayList<LivingEntity>();
        block0: for (WaveEntity toSpawn : this.entities) {
            for (int i = 0; i < toSpawn.getCount(); ++i) {
                LivingEntity entity = Wave.spawnWaveEntity(level, pos, gate, this, toSpawn);
                if (entity == null) {
                    gate.onFailure(spawned, GatewayEntity.FailureReason.SPAWN_FAILED);
                    continue block0;
                }
                spawned.add(entity);
            }
        }
        return spawned;
    }

    public List<ItemStack> spawnRewards(ServerLevel level, GatewayEntity gate, Player summoner) {
        ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
        this.rewards.forEach(r -> r.generateLoot(level, gate, summoner, s -> {
            if (!s.m_41619_()) {
                while (s.m_41613_() > 4) {
                    ItemStack copy = s.m_41777_();
                    copy.m_41764_(4);
                    stacks.add(copy);
                    s.m_41774_(4);
                }
                if (!s.m_41619_()) {
                    stacks.add((ItemStack)s);
                }
            }
        }));
        return stacks;
    }

    public static LivingEntity spawnWaveEntity(ServerLevel level, Vec3 pos, GatewayEntity gate, Wave wave, WaveEntity waveEntity) {
        AttributeInstance attr;
        LivingEntity entity = waveEntity.createEntity((Level)level);
        if (entity == null) {
            return null;
        }
        Vec3 spawnPos = gate.getGateway().spawnAlgo().spawn(level, pos, gate, (Entity)entity);
        if (spawnPos == null) {
            return null;
        }
        entity.getPersistentData().m_128362_("gateways.owner", gate.m_20148_());
        entity.m_7678_(spawnPos.m_7096_(), spawnPos.m_7098_(), spawnPos.m_7094_(), level.f_46441_.m_188501_() * 360.0f, level.f_46441_.m_188501_() * 360.0f);
        entity.m_142429_().filter(e -> e instanceof LivingEntity).map(LivingEntity.class::cast).forEach(e -> {
            wave.modifiers.forEach(m -> m.apply((LivingEntity)e));
            e.m_21153_(entity.m_21233_());
            e.m_7292_(new MobEffectInstance(MobEffects.f_19606_, 5, 100, true, false));
        });
        GateRules rules = gate.getGateway().rules();
        if (entity instanceof Mob) {
            Player summoner;
            Mob mob = (Mob)entity;
            if (waveEntity.shouldFinalizeSpawn()) {
                ForgeEventFactory.onFinalizeSpawn((Mob)mob, (ServerLevelAccessor)level, (DifficultyInstance)level.m_6436_(entity.m_20183_()), (MobSpawnType)MobSpawnType.SPAWNER, null, null);
            }
            if (!((summoner = gate.summonerOrClosest()) instanceof FakePlayer)) {
                mob.m_6710_((LivingEntity)summoner);
            }
            mob.m_21530_();
            if (rules.defaultDropChance() >= 0.0f) {
                int i;
                for (i = 0; i < 2; ++i) {
                    if (mob.f_21347_[i] != 0.085f) continue;
                    mob.f_21347_[i] = rules.defaultDropChance();
                }
                for (i = 0; i < 4; ++i) {
                    if (mob.f_21348_[i] != 0.085f) continue;
                    mob.f_21348_[i] = rules.defaultDropChance();
                }
            }
        }
        if (rules.followRangeBoost() > 0.0 && (attr = entity.m_21051_(Attributes.f_22277_)) != null) {
            attr.m_22125_(new AttributeModifier("Gateway Follow Range Boost", rules.followRangeBoost(), AttributeModifier.Operation.ADDITION));
        }
        MinecraftForge.EVENT_BUS.post((Event)new GateEvent.WaveEntitySpawned(gate, entity));
        level.m_47205_((Entity)entity);
        level.m_6263_(null, gate.m_20185_(), gate.m_20186_(), gate.m_20189_(), (SoundEvent)GatewayObjects.GATE_WARP.get(), SoundSource.HOSTILE, 0.5f, 1.0f);
        gate.spawnParticle(entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), ParticleMessage.Type.SPAWNED);
        return entity;
    }
}

