/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.gateways.entity;

import com.google.common.base.Preconditions;
import dev.shadowsoffire.gateways.GatewayObjects;
import dev.shadowsoffire.gateways.entity.GatewayEntity;
import dev.shadowsoffire.gateways.gate.Wave;
import dev.shadowsoffire.gateways.gate.normal.NormalGateway;
import dev.shadowsoffire.placebo.reload.DynamicHolder;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;

public class NormalGatewayEntity
extends GatewayEntity {
    public NormalGatewayEntity(Level level, Player placer, DynamicHolder<NormalGateway> gate) {
        super((EntityType<? extends GatewayEntity>)((EntityType)GatewayObjects.NORMAL_GATEWAY.get()), level, placer, gate);
        this.summonerId = placer.m_20148_();
        this.gate = gate;
        Preconditions.checkArgument((boolean)gate.isBound(), (Object)"A gateway may not be constructed for an unbound holder.");
        this.m_6593_((Component)Component.m_237115_((String)gate.getId().toString().replace(':', '.')).m_130948_(Style.f_131099_.m_131148_(((NormalGateway)gate.get()).color())));
        this.bossEvent = this.createBossEvent();
        this.m_6210_();
    }

    public NormalGatewayEntity(EntityType<?> type, Level level) {
        super(type, level);
    }

    public boolean isLastWave() {
        return this.getWave() >= this.getGateway().getNumWaves();
    }

    @Override
    public Wave getCurrentWave() {
        return this.getGateway().getWave(Math.min(this.getGateway().getNumWaves() - 1, this.getWave()));
    }

    @Override
    protected boolean canStartNextWave() {
        return super.canStartNextWave() && !this.isLastWave();
    }

    @Override
    public boolean isCompleted() {
        return this.undroppedItems.isEmpty() && this.isLastWave();
    }

    @Override
    protected void completeWave() {
        Player player = this.summonerOrClosest();
        this.undroppedItems.addAll(this.getCurrentWave().spawnRewards((ServerLevel)this.m_9236_(), this, player));
    }

    @Override
    protected void completeGateway() {
        super.completeGateway();
        Player player = this.summonerOrClosest();
        this.getGateway().rewards().forEach(r -> r.generateLoot((ServerLevel)this.m_9236_(), this, player, this::spawnCompletionItem));
    }

    @Override
    public NormalGateway getGateway() {
        return (NormalGateway)super.getGateway();
    }
}

