/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.gateways.entity;

import dev.shadowsoffire.gateways.GatewayObjects;
import dev.shadowsoffire.gateways.entity.GatewayEntity;
import dev.shadowsoffire.gateways.gate.Wave;
import dev.shadowsoffire.gateways.gate.WaveEntity;
import dev.shadowsoffire.gateways.gate.WaveModifier;
import dev.shadowsoffire.gateways.gate.endless.EndlessGateway;
import dev.shadowsoffire.gateways.gate.endless.EndlessModifier;
import dev.shadowsoffire.placebo.reload.DynamicHolder;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;

public class EndlessGatewayEntity
extends GatewayEntity {
    public static final EntityDataAccessor<Integer> MAX_ENEMIES = SynchedEntityData.m_135353_(EndlessGatewayEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final EntityDataAccessor<Integer> MODIFIERS = SynchedEntityData.m_135353_(EndlessGatewayEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final EntityDataAccessor<Integer> MAX_WAVE_TIME = SynchedEntityData.m_135353_(EndlessGatewayEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final EntityDataAccessor<Integer> SETUP_TIME = SynchedEntityData.m_135353_(EndlessGatewayEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);

    public EndlessGatewayEntity(Level level, Player placer, DynamicHolder<EndlessGateway> gate) {
        super((EntityType<? extends GatewayEntity>)((EntityType)GatewayObjects.ENDLESS_GATEWAY.get()), level, placer, gate);
    }

    public EndlessGatewayEntity(EntityType<?> type, Level level) {
        super(type, level);
    }

    @Override
    public Wave getCurrentWave() {
        return this.getGateway().baseWave();
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        if (this.m_213877_()) {
            return;
        }
        if (this.getMaxEnemies() == -1) {
            this.computeMaxEnemies(this.getWave());
        }
    }

    @Override
    protected void startNextWave() {
        super.startNextWave();
        this.f_19804_.m_135381_(MAX_WAVE_TIME, (Object)this.getCurrentWave().maxWaveTime());
        this.f_19804_.m_135381_(SETUP_TIME, (Object)this.getCurrentWave().setupTime());
        this.executeModifiers(m -> m.entities().forEach(waveEntity -> {
            for (int i = 0; i < waveEntity.getCount(); ++i) {
                LivingEntity entity = Wave.spawnWaveEntity((ServerLevel)this.m_9236_(), this.m_20182_(), this, this.getCurrentWave(), waveEntity);
                if (entity == null) {
                    this.onFailure(this.currentWaveEntities, GatewayEntity.FailureReason.SPAWN_FAILED);
                    break;
                }
                this.currentWaveEntities.add(entity);
            }
        }));
        int applied = this.executeModifiers(m -> {
            for (LivingEntity entity : this.currentWaveEntities) {
                for (WaveModifier waveModif : m.modifiers()) {
                    waveModif.apply(entity);
                }
                entity.m_21153_(entity.m_21233_());
            }
            if (m.waveTime() != 0) {
                this.f_19804_.m_135381_(MAX_WAVE_TIME, (Object)(this.getMaxWaveTime() + m.waveTime()));
            }
            if (m.setupTime() != 0) {
                this.f_19804_.m_135381_(SETUP_TIME, (Object)(this.getSetupTime() + m.setupTime()));
            }
        });
        this.f_19804_.m_135381_(MODIFIERS, (Object)applied);
        this.f_19804_.m_135381_(MAX_ENEMIES, (Object)this.currentWaveEntities.size());
    }

    @Override
    public int getMaxWaveTime() {
        return (Integer)this.f_19804_.m_135370_(MAX_WAVE_TIME);
    }

    @Override
    public int getSetupTime() {
        int time = (Integer)this.f_19804_.m_135370_(SETUP_TIME);
        return time == -1 ? super.getSetupTime() : time;
    }

    @Override
    public boolean isCompleted() {
        return false;
    }

    @Override
    protected void completeWave() {
        Player player = this.summonerOrClosest();
        this.undroppedItems.addAll(this.getCurrentWave().spawnRewards((ServerLevel)this.m_9236_(), this, player));
        this.executeModifiers(m -> m.rewards().forEach(r -> r.generateLoot((ServerLevel)this.m_9236_(), this, player, this.undroppedItems::add)));
        this.computeMaxEnemies(this.getWave() + 1);
    }

    @Override
    public EndlessGateway getGateway() {
        return (EndlessGateway)super.getGateway();
    }

    public int getMaxEnemies() {
        return (Integer)this.f_19804_.m_135370_(MAX_ENEMIES);
    }

    public int getModifiersApplied() {
        return (Integer)this.f_19804_.m_135370_(MODIFIERS);
    }

    public int executeModifiers(int wave, Consumer<EndlessModifier> func) {
        int totalApplications = 0;
        for (EndlessModifier m : this.getGateway().modifiers()) {
            int count = m.appMode().getApplicationCount(wave + 1);
            for (int i = 0; i < count; ++i) {
                func.accept(m);
            }
            totalApplications += count;
        }
        return totalApplications;
    }

    public int executeModifiers(Consumer<EndlessModifier> func) {
        return this.executeModifiers(this.getWave(), func);
    }

    protected void computeMaxEnemies(int wave) {
        AtomicInteger count = new AtomicInteger(this.getGateway().baseWave().entities().stream().mapToInt(WaveEntity::getCount).sum());
        this.executeModifiers(wave, modif -> count.set(count.get() + modif.entities().stream().mapToInt(WaveEntity::getCount).sum()));
        this.f_19804_.m_135381_(MAX_ENEMIES, (Object)count.get());
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(MAX_ENEMIES, (Object)-1);
        this.f_19804_.m_135372_(MODIFIERS, (Object)-1);
        this.f_19804_.m_135372_(MAX_WAVE_TIME, (Object)-1);
        this.f_19804_.m_135372_(SETUP_TIME, (Object)-1);
    }

    @Override
    protected void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        tag.m_128405_("max_enemies", this.getMaxEnemies());
        tag.m_128405_("modifiers_applied", this.getModifiersApplied());
    }

    @Override
    protected void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        if (tag.m_128441_("max_enemies")) {
            this.f_19804_.m_135381_(MAX_ENEMIES, (Object)tag.m_128451_("max_enemies"));
        }
        if (tag.m_128441_("modifiers_applied")) {
            this.f_19804_.m_135381_(MODIFIERS, (Object)tag.m_128451_("modifiers_applied"));
        }
    }
}

