/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.gateways;

import com.mojang.serialization.Codec;
import dev.shadowsoffire.gateways.Gateways;
import dev.shadowsoffire.gateways.client.GatewayParticleData;
import dev.shadowsoffire.gateways.client.GatewayTickableSound;
import dev.shadowsoffire.gateways.entity.EndlessGatewayEntity;
import dev.shadowsoffire.gateways.entity.NormalGatewayEntity;
import dev.shadowsoffire.gateways.item.GatePearlItem;
import dev.shadowsoffire.gateways.recipe.GatewayRecipeSerializer;
import dev.shadowsoffire.placebo.registry.DeferredHelper;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Rarity;
import net.minecraftforge.registries.RegistryObject;

public class GatewayObjects {
    private static final DeferredHelper R = DeferredHelper.create((String)"gateways");
    public static final RegistryObject<EntityType<NormalGatewayEntity>> NORMAL_GATEWAY = R.entity("normal_gateway", () -> EntityType.Builder.m_20704_(NormalGatewayEntity::new, (MobCategory)MobCategory.MISC).setTrackingRange(5).setUpdateInterval(20).m_20699_(2.0f, 3.0f).setCustomClientFactory((packet, level) -> {
        NormalGatewayEntity ent = (NormalGatewayEntity)((EntityType)NORMAL_GATEWAY.get()).m_20615_(level);
        GatewayTickableSound.startGatewaySound(ent);
        return ent;
    }).m_20712_("gateway"));
    public static final RegistryObject<EntityType<EndlessGatewayEntity>> ENDLESS_GATEWAY = R.entity("endless_gateway", () -> EntityType.Builder.m_20704_(EndlessGatewayEntity::new, (MobCategory)MobCategory.MISC).setTrackingRange(5).setUpdateInterval(20).m_20699_(2.0f, 3.0f).setCustomClientFactory((packet, level) -> {
        EndlessGatewayEntity ent = (EndlessGatewayEntity)((EntityType)ENDLESS_GATEWAY.get()).m_20615_(level);
        GatewayTickableSound.startGatewaySound(ent);
        return ent;
    }).m_20712_("gateway"));
    public static final RegistryObject<GatePearlItem> GATE_PEARL = R.item("gate_pearl", () -> new GatePearlItem(new Item.Properties().m_41497_(Rarity.UNCOMMON)));
    public static final RegistryObject<SoundEvent> GATE_AMBIENT = GatewayObjects.sound("gate_ambient");
    public static final RegistryObject<SoundEvent> GATE_WARP = GatewayObjects.sound("gate_warp");
    public static final RegistryObject<SoundEvent> GATE_START = GatewayObjects.sound("gate_start");
    public static final RegistryObject<SoundEvent> GATE_END = GatewayObjects.sound("gate_end");
    public static final RegistryObject<ParticleType<GatewayParticleData>> GLOW = R.particle("glow", () -> new ParticleType<GatewayParticleData>(false, GatewayParticleData.DESERIALIZER){

        public Codec<GatewayParticleData> m_7652_() {
            return GatewayParticleData.CODEC;
        }
    });
    public static final RegistryObject<GatewayRecipeSerializer> GATE_RECIPE = R.recipeSerializer("gate_recipe", GatewayRecipeSerializer::new);
    public static final ResourceKey<CreativeModeTab> TAB_KEY = ResourceKey.m_135785_((ResourceKey)Registries.f_279569_, (ResourceLocation)Gateways.loc("tab"));
    public static final RegistryObject<CreativeModeTab> TAB = R.tab("tab", () -> CreativeModeTab.builder().m_257941_((Component)Component.m_237115_((String)"itemGroup.gateways")).m_257737_(() -> ((GatePearlItem)((Object)((Object)((Object)GATE_PEARL.get())))).m_7968_()).m_257652_());
    public static final RegistryObject<ResourceLocation> GATES_DEFEATED = R.custom("gates_defeated", Registries.f_256887_, () -> Gateways.loc("gates_defeated"));

    private static RegistryObject<SoundEvent> sound(String name) {
        return R.sound(name, () -> SoundEvent.m_262824_((ResourceLocation)Gateways.loc(name)));
    }

    static void bootstrap() {
    }
}

