/*
 * Decompiled with CFR 0.152.
 */
package sonar.fluxnetworks.data.loot;

import it.unimi.dsi.fastutil.objects.ObjectArraySet;
import java.util.Collections;
import java.util.Set;
import javax.annotation.Nonnull;
import net.minecraft.data.loot.BlockLootSubProvider;
import net.minecraft.world.flag.FeatureFlags;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.functions.CopyNbtFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.predicates.ConditionUserBuilder;
import net.minecraft.world.level.storage.loot.providers.nbt.ContextNbtProvider;
import net.minecraft.world.level.storage.loot.providers.nbt.NbtProvider;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import sonar.fluxnetworks.common.block.FluxDeviceBlock;
import sonar.fluxnetworks.common.block.FluxStorageBlock;
import sonar.fluxnetworks.register.RegistryBlocks;

public class FluxBlockLoot
extends BlockLootSubProvider {
    private final Set<Block> knownBlocks = new ObjectArraySet();

    public FluxBlockLoot() {
        super(Collections.emptySet(), FeatureFlags.f_244280_.m_247355_());
    }

    @Nonnull
    public final Iterable<Block> getKnownBlocks() {
        return this.knownBlocks;
    }

    protected final void m_247577_(@Nonnull Block blockIn, @Nonnull LootTable.Builder table) {
        super.m_247577_(blockIn, table);
        this.knownBlocks.add(blockIn);
    }

    protected void m_245660_() {
        this.m_245724_((Block)RegistryBlocks.FLUX_BLOCK.get());
        this.m_246481_((Block)RegistryBlocks.FLUX_PLUG.get(), this::createDevice);
        this.m_246481_((Block)RegistryBlocks.FLUX_POINT.get(), this::createDevice);
        this.m_246481_((Block)RegistryBlocks.FLUX_CONTROLLER.get(), this::createDevice);
        this.m_246481_((Block)RegistryBlocks.BASIC_FLUX_STORAGE.get(), this::createDevice);
        this.m_246481_((Block)RegistryBlocks.HERCULEAN_FLUX_STORAGE.get(), this::createDevice);
        this.m_246481_((Block)RegistryBlocks.GARGANTUAN_FLUX_STORAGE.get(), this::createDevice);
    }

    @Nonnull
    protected LootTable.Builder createDevice(Block block) {
        if (!(block instanceof FluxDeviceBlock)) {
            throw new IllegalArgumentException();
        }
        CopyNbtFunction.Builder copyNbt = CopyNbtFunction.m_165180_((NbtProvider)ContextNbtProvider.f_165562_);
        copyNbt.m_80279_("networkID", "FluxData.networkID");
        copyNbt.m_80279_("customName", "FluxData.customName");
        copyNbt.m_80279_("priority", "FluxData.priority");
        copyNbt.m_80279_("limit", "FluxData.limit");
        if (block instanceof FluxStorageBlock) {
            copyNbt.m_80279_("energy", "FluxData.energy");
        } else {
            copyNbt.m_80279_("buffer", "FluxData.buffer");
        }
        LootPool.Builder pool = LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)block).m_79078_((LootItemFunction.Builder)copyNbt));
        return LootTable.m_79147_().m_79161_((LootPool.Builder)this.m_247733_((ItemLike)block, (ConditionUserBuilder)pool));
    }
}

