/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.flowerpatch.datagen;

import com.mrbysco.flowerpatch.Constants;
import com.mrbysco.flowerpatch.block.FlowerPatchBlock;
import com.mrbysco.flowerpatch.block.PatchBlock;
import com.mrbysco.flowerpatch.registration.PatchRegistry;
import com.mrbysco.flowerpatch.registration.RegistryObject;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nullable;
import net.minecraft.advancements.critereon.StatePropertiesPredicate;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.data.loot.BlockLootSubProvider;
import net.minecraft.data.loot.LootTableProvider;
import net.minecraft.data.tags.ItemTagsProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.flag.FeatureFlags;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.ValidationContext;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.functions.SetItemCountFunction;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.predicates.LootItemBlockStatePropertyCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraftforge.client.model.generators.BlockModelBuilder;
import net.minecraftforge.client.model.generators.BlockModelProvider;
import net.minecraftforge.client.model.generators.BlockStateProvider;
import net.minecraftforge.client.model.generators.ConfiguredModel;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.common.data.BlockTagsProvider;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.common.data.LanguageProvider;
import net.minecraftforge.data.event.GatherDataEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class PatchDatagen {
    @SubscribeEvent
    public static void gatherData(GatherDataEvent event) {
        DataGenerator generator = event.getGenerator();
        PackOutput packOutput = generator.getPackOutput();
        CompletableFuture lookupProvider = event.getLookupProvider();
        ExistingFileHelper helper = event.getExistingFileHelper();
        if (event.includeServer()) {
            generator.addProvider(event.includeServer(), (DataProvider)new Loots(packOutput));
            PatchBlockTags provider = new PatchBlockTags(packOutput, lookupProvider, helper);
            generator.addProvider(event.includeServer(), (DataProvider)provider);
            generator.addProvider(event.includeServer(), (DataProvider)new PatchItemTags(packOutput, lookupProvider, provider, helper));
        }
        if (event.includeClient()) {
            generator.addProvider(event.includeClient(), (DataProvider)new Language(packOutput));
            generator.addProvider(event.includeClient(), (DataProvider)new BlockModels(packOutput, helper));
            generator.addProvider(event.includeClient(), (DataProvider)new BlockStates(packOutput, helper));
        }
    }

    private static class Loots
    extends LootTableProvider {
        public Loots(PackOutput packOutput) {
            super(packOutput, Set.of(), List.of(new LootTableProvider.SubProviderEntry(PatchBlockLoot::new, LootContextParamSets.f_81421_)));
        }

        protected void validate(Map<ResourceLocation, LootTable> map, ValidationContext validationContext) {
            map.forEach((name, table) -> table.m_79136_(validationContext));
        }

        public static class PatchBlockLoot
        extends BlockLootSubProvider {
            protected PatchBlockLoot() {
                super(Set.of(), FeatureFlags.f_244280_.m_247355_());
            }

            protected void m_245660_() {
                for (RegistryObject<Block> registryObject : PatchRegistry.BLOCKS.getEntries()) {
                    Block block2 = registryObject.get();
                    if (!(block2 instanceof PatchBlock)) continue;
                    PatchBlock patch = (PatchBlock)block2;
                    Block patchBlock = registryObject.get();
                    this.m_246481_(patchBlock, block -> LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)this.m_246108_((ItemLike)block, LootItem.m_79579_((ItemLike)((ItemLike)patch.getPatchDelegate().get())).m_230984_(List.of(Integer.valueOf(2), Integer.valueOf(3), Integer.valueOf(4)), value -> SetItemCountFunction.m_165412_((NumberProvider)ConstantValue.m_165692_((float)value.intValue())).m_79080_((LootItemCondition.Builder)LootItemBlockStatePropertyCondition.m_81769_((Block)patchBlock).m_81784_(StatePropertiesPredicate.Builder.m_67693_().m_67694_((Property)patch.getProperty(), value.intValue()))))))));
                }
            }

            protected Iterable<Block> getKnownBlocks() {
                return PatchRegistry.BLOCKS.getEntries().stream().map(RegistryObject::get)::iterator;
            }
        }
    }

    public static class PatchBlockTags
    extends BlockTagsProvider {
        public PatchBlockTags(PackOutput packOutput, CompletableFuture<HolderLookup.Provider> lookupProvider, @Nullable ExistingFileHelper existingFileHelper) {
            super(packOutput, lookupProvider, "flowerpatch", existingFileHelper);
        }

        protected void m_6577_(HolderLookup.Provider provider) {
            for (RegistryObject<Block> registryObject : PatchRegistry.BLOCKS.getEntries()) {
                Block block = registryObject.get();
                if (!(block instanceof FlowerPatchBlock)) continue;
                FlowerPatchBlock flowerPatchBlock = (FlowerPatchBlock)block;
                this.m_206424_(BlockTags.f_13041_).m_255245_((Object)flowerPatchBlock);
            }
            this.m_206424_(Constants.BONEMEAL_ABLE_FLOWERS).m_255179_((Object[])new Block[]{Blocks.f_50111_, Blocks.f_50112_, Blocks.f_50113_, Blocks.f_50114_, Blocks.f_50115_, Blocks.f_50116_, Blocks.f_50117_, Blocks.f_50118_, Blocks.f_50119_, Blocks.f_50120_, Blocks.f_50121_, Blocks.f_50071_, Blocks.f_271329_});
        }
    }

    public static class PatchItemTags
    extends ItemTagsProvider {
        public PatchItemTags(PackOutput packOutput, CompletableFuture<HolderLookup.Provider> lookupProvider, BlockTagsProvider blockTagsProvider, ExistingFileHelper existingFileHelper) {
            super(packOutput, lookupProvider, blockTagsProvider.m_274426_(), "flowerpatch", existingFileHelper);
        }

        protected void m_6577_(HolderLookup.Provider provider) {
            this.m_206424_(Constants.BONEMEAL).m_255245_((Object)Items.f_42499_);
        }
    }

    private static class Language
    extends LanguageProvider {
        public Language(PackOutput packOutput) {
            super(packOutput, "flowerpatch", "en_us");
        }

        protected void addTranslations() {
            for (RegistryObject<Block> registryObject : PatchRegistry.BLOCKS.getEntries()) {
                Block block = registryObject.get();
                if (!(block instanceof PatchBlock)) continue;
                PatchBlock patchBlock = (PatchBlock)block;
                this.addBlock(registryObject, I18n.m_118938_((String)patchBlock.getPatchDelegate().get().m_7705_(), (Object[])new Object[0]) + " Patch");
            }
            this.add("text.autoconfig.flowerpatch.option.general", "General");
            this.add("text.autoconfig.flowerpatch.option.general.flowerToPatchBonemealing", "flowerToPatchBonemealing");
            this.add("text.autoconfig.flowerpatch.option.general.patchBonemealing", "patchBonemealing");
        }
    }

    private static class BlockModels
    extends BlockModelProvider {
        public BlockModels(PackOutput packOutput, ExistingFileHelper helper) {
            super(packOutput, "flowerpatch", helper);
        }

        protected void registerModels() {
            for (RegistryObject<Block> registryObject : PatchRegistry.BLOCKS.getEntries()) {
                if (!(registryObject.get() instanceof PatchBlock)) continue;
                this.generatePatchModels(registryObject.get());
            }
        }

        protected void generatePatchModels(Block block) {
            this.crossBlock(block);
        }

        private void crossBlock(Block block) {
            this.patchBlock(block, 2);
            this.patchBlock(block, 3);
            this.patchBlock(block, 4);
        }

        private BlockModelBuilder patchBlock(Block block, int flowers) {
            String path = ForgeRegistries.BLOCKS.getKey((Object)block).m_135815_() + "_" + flowers;
            return (BlockModelBuilder)((BlockModelBuilder)this.singleTexture(path, this.modLoc("block/patch" + flowers), "cross", this.mcLoc("block/" + ForgeRegistries.BLOCKS.getKey((Object)((PatchBlock)block).getPatchDelegate().get()).m_135815_()))).renderType("cutout");
        }
    }

    private static class BlockStates
    extends BlockStateProvider {
        public BlockStates(PackOutput packOutput, ExistingFileHelper helper) {
            super(packOutput, "flowerpatch", helper);
        }

        protected void registerStatesAndModels() {
            for (RegistryObject<Block> registryObject : PatchRegistry.BLOCKS.getEntries()) {
                if (!(registryObject.get() instanceof PatchBlock)) continue;
                this.generatePatchState(registryObject.get());
            }
        }

        protected void generatePatchState(Block block) {
            ModelFile.ExistingModelFile patchModel2 = this.models().getExistingFile(this.modLoc("block/" + ForgeRegistries.BLOCKS.getKey((Object)block).m_135815_() + "_2"));
            ModelFile.ExistingModelFile patchModel3 = this.models().getExistingFile(this.modLoc("block/" + ForgeRegistries.BLOCKS.getKey((Object)block).m_135815_() + "_3"));
            ModelFile.ExistingModelFile patchModel4 = this.models().getExistingFile(this.modLoc("block/" + ForgeRegistries.BLOCKS.getKey((Object)block).m_135815_() + "_4"));
            PatchBlock patchBlock = (PatchBlock)block;
            this.getVariantBuilder(block).partialState().with((Property)patchBlock.getProperty(), (Comparable)Integer.valueOf(2)).addModels(new ConfiguredModel[]{new ConfiguredModel((ModelFile)patchModel2), new ConfiguredModel((ModelFile)patchModel2, 0, 90, false), new ConfiguredModel((ModelFile)patchModel2, 0, 180, false), new ConfiguredModel((ModelFile)patchModel2, 0, 270, false)}).partialState().with((Property)patchBlock.getProperty(), (Comparable)Integer.valueOf(3)).addModels(new ConfiguredModel[]{new ConfiguredModel((ModelFile)patchModel3), new ConfiguredModel((ModelFile)patchModel3, 0, 90, false), new ConfiguredModel((ModelFile)patchModel3, 0, 180, false), new ConfiguredModel((ModelFile)patchModel3, 0, 270, false)}).partialState().with((Property)patchBlock.getProperty(), (Comparable)Integer.valueOf(4)).addModels(new ConfiguredModel[]{new ConfiguredModel((ModelFile)patchModel4), new ConfiguredModel((ModelFile)patchModel4, 0, 90, false), new ConfiguredModel((ModelFile)patchModel4, 0, 180, false), new ConfiguredModel((ModelFile)patchModel4, 0, 270, false)});
        }
    }
}

