/*
 * Decompiled with CFR 0.152.
 */
package vectorwing.farmersdelight.common.loot.modifier;

import com.google.common.base.Suppliers;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.function.Supplier;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraftforge.common.loot.IGlobalLootModifier;
import net.minecraftforge.common.loot.LootModifier;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;

public class ReplaceItemModifier
extends LootModifier {
    public static final Supplier<Codec<ReplaceItemModifier>> CODEC = Suppliers.memoize(() -> RecordCodecBuilder.create(inst -> ReplaceItemModifier.codecStart((RecordCodecBuilder.Instance)inst).and(inst.group((App)ForgeRegistries.ITEMS.getCodec().fieldOf("removed_item").forGetter(m -> m.removedItem), (App)ForgeRegistries.ITEMS.getCodec().fieldOf("added_item").forGetter(m -> m.addedItem), (App)Codec.INT.optionalFieldOf("count", (Object)1).forGetter(m -> m.addedCount))).apply((Applicative)inst, ReplaceItemModifier::new)));
    private final Item removedItem;
    private final Item addedItem;
    private final int addedCount;

    protected ReplaceItemModifier(LootItemCondition[] conditions, Item removedItem, Item addedItem, int addedCount) {
        super(conditions);
        this.removedItem = removedItem;
        this.addedItem = addedItem;
        this.addedCount = addedCount;
    }

    @NotNull
    protected ObjectArrayList<ItemStack> doApply(ObjectArrayList<ItemStack> generatedLoot, LootContext lootContext) {
        ItemStack addedStack = new ItemStack((ItemLike)this.addedItem, this.addedCount);
        generatedLoot.forEach(item -> {
            if (item.m_150930_(this.removedItem)) {
                generatedLoot.remove(item);
            }
        });
        if (addedStack.m_41613_() < addedStack.m_41741_()) {
            generatedLoot.add((Object)addedStack);
        } else {
            ItemStack subStack;
            for (int i = addedStack.m_41613_(); i > 0; i -= subStack.m_41613_()) {
                subStack = addedStack.m_41777_();
                subStack.m_41764_(Math.min(addedStack.m_41741_(), i));
                generatedLoot.add((Object)subStack);
            }
        }
        return generatedLoot;
    }

    public Codec<? extends IGlobalLootModifier> codec() {
        return CODEC.get();
    }
}

