/*
 * Decompiled with CFR 0.152.
 */
package com.glodblock.github.extendedae.container;

import appeng.api.inventories.InternalInventory;
import appeng.helpers.InventoryAction;
import appeng.menu.AEBaseMenu;
import appeng.menu.implementations.MenuTypeBuilder;
import appeng.util.inv.AppEngInternalInventory;
import appeng.util.inv.FilteredInternalInventory;
import appeng.util.inv.filter.IAEItemFilter;
import com.glodblock.github.extendedae.common.me.matrix.ClusterAssemblerMatrix;
import com.glodblock.github.extendedae.common.tileentities.matrix.TileAssemblerMatrixBase;
import com.glodblock.github.extendedae.common.tileentities.matrix.TileAssemblerMatrixCrafter;
import com.glodblock.github.extendedae.common.tileentities.matrix.TileAssemblerMatrixPattern;
import com.glodblock.github.extendedae.network.EPPNetworkHandler;
import com.glodblock.github.extendedae.network.packet.SAssemblerMatrixUpdate;
import com.glodblock.github.glodium.network.packet.IMessage;
import com.glodblock.github.glodium.network.packet.SGenericPacket;
import com.glodblock.github.glodium.network.packet.sync.IActionHolder;
import com.glodblock.github.glodium.network.packet.sync.Paras;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.longs.Long2ReferenceMap;
import it.unimi.dsi.fastutil.longs.Long2ReferenceOpenHashMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ContainerAssemblerMatrix
extends AEBaseMenu
implements IActionHolder {
    public static final MenuType<ContainerAssemblerMatrix> TYPE = MenuTypeBuilder.create(ContainerAssemblerMatrix::new, TileAssemblerMatrixBase.class).build("assembler_matrix");
    private final Map<String, Consumer<Paras>> actions = this.createHolder();
    private final List<PatternSlotTracker> trackers = new ArrayList<PatternSlotTracker>();
    private final Long2ReferenceMap<PatternSlotTracker> trackerMap = new Long2ReferenceOpenHashMap();
    private final TileAssemblerMatrixBase host;
    private int runningThreads = 0;

    public ContainerAssemblerMatrix(int id, Inventory playerInventory, TileAssemblerMatrixBase host) {
        super(TYPE, id, playerInventory, (Object)host);
        this.actions.put("cancel", o -> this.cancel());
        this.host = host;
        this.setupPatternInventory();
        this.createPlayerInventorySlots(playerInventory);
    }

    private void cancel() {
        ClusterAssemblerMatrix cluster = this.host.getCluster();
        if (cluster != null && !cluster.isDestroyed()) {
            cluster.getBlockEntities().forEachRemaining(te -> {
                if (te instanceof TileAssemblerMatrixCrafter) {
                    TileAssemblerMatrixCrafter crafter = (TileAssemblerMatrixCrafter)((Object)te);
                    crafter.stop();
                }
            });
        }
    }

    private int runningThreads() {
        ClusterAssemblerMatrix c = this.host.getCluster();
        if (c == null) {
            return 0;
        }
        return c.getBusyCrafterAmount();
    }

    protected ItemStack transferStackToMenu(ItemStack input) {
        InternalInventory slot = this.getAvailableSlot();
        if (slot != null) {
            return slot.addItems(input);
        }
        return input;
    }

    @Nullable
    private InternalInventory getAvailableSlot() {
        for (PatternSlotTracker tr : this.trackerMap.values()) {
            for (int x = 0; x < tr.server.size(); ++x) {
                if (!tr.server.getStackInSlot(x).m_41619_()) continue;
                return new FilteredInternalInventory(tr.server.getSlotInv(x), (IAEItemFilter)new TileAssemblerMatrixPattern.Filter(() -> this.getHost().m_58904_()));
            }
        }
        return null;
    }

    public void doAction(ServerPlayer player, InventoryAction action, int slot, long id) {
        PatternSlotTracker inv = (PatternSlotTracker)this.trackerMap.get(id);
        if (inv == null) {
            return;
        }
        if (slot < 0 || slot >= inv.server.size()) {
            return;
        }
        ItemStack is = inv.server.getStackInSlot(slot);
        FilteredInternalInventory patternSlot = new FilteredInternalInventory(inv.server.getSlotInv(slot), (IAEItemFilter)new TileAssemblerMatrixPattern.Filter(() -> this.getHost().m_58904_()));
        ItemStack carried = this.m_142621_();
        switch (action) {
            case PICKUP_OR_SET_DOWN: {
                if (!carried.m_41619_()) {
                    ItemStack inSlot = patternSlot.getStackInSlot(0);
                    if (inSlot.m_41619_()) {
                        this.m_142503_(patternSlot.addItems(carried));
                        break;
                    }
                    inSlot = inSlot.m_41777_();
                    ItemStack inHand = carried.m_41777_();
                    patternSlot.setItemDirect(0, ItemStack.f_41583_);
                    this.m_142503_(ItemStack.f_41583_);
                    this.m_142503_(patternSlot.addItems(inHand.m_41777_()));
                    if (this.m_142621_().m_41619_()) {
                        this.m_142503_(inSlot);
                        break;
                    }
                    this.m_142503_(inHand);
                    patternSlot.setItemDirect(0, inSlot);
                    break;
                }
                this.m_142503_(patternSlot.getStackInSlot(0));
                patternSlot.setItemDirect(0, ItemStack.f_41583_);
                break;
            }
            case SPLIT_OR_PLACE_SINGLE: {
                if (!carried.m_41619_()) {
                    ItemStack extra = carried.m_41620_(1);
                    if (!extra.m_41619_()) {
                        extra = patternSlot.addItems(extra);
                    }
                    if (extra.m_41619_()) break;
                    carried.m_41769_(extra.m_41613_());
                    break;
                }
                if (is.m_41619_()) break;
                this.m_142503_(patternSlot.extractItem(0, (is.m_41613_() + 1) / 2, false));
                break;
            }
            case SHIFT_CLICK: {
                ItemStack stack = patternSlot.getStackInSlot(0).m_41777_();
                if (!player.m_150109_().m_36054_(stack)) {
                    patternSlot.setItemDirect(0, stack);
                    break;
                }
                patternSlot.setItemDirect(0, ItemStack.f_41583_);
                break;
            }
            case MOVE_REGION: {
                for (int x = 0; x < inv.server.size(); ++x) {
                    ItemStack stack = inv.server.getStackInSlot(x);
                    if (!player.m_150109_().m_36054_(stack)) {
                        patternSlot.setItemDirect(0, stack);
                        continue;
                    }
                    patternSlot.setItemDirect(0, ItemStack.f_41583_);
                }
                break;
            }
            case CREATIVE_DUPLICATE: {
                if (!player.m_150110_().f_35937_ || !carried.m_41619_()) break;
                this.m_142503_(is.m_41619_() ? ItemStack.f_41583_ : is.m_41777_());
            }
        }
    }

    public void m_38946_() {
        if (this.isClientSide()) {
            return;
        }
        super.m_38946_();
        Player player = this.getPlayer();
        if (player instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            for (PatternSlotTracker tracker : this.trackers) {
                if (tracker.init) {
                    SAssemblerMatrixUpdate ptk = tracker.createPacket();
                    if (ptk == null) continue;
                    EPPNetworkHandler.INSTANCE.sendTo(ptk, player2);
                    continue;
                }
                tracker.init = true;
                EPPNetworkHandler.INSTANCE.sendTo(tracker.fullPacket(), player2);
            }
            int newRunningThreads = this.runningThreads();
            if (this.runningThreads != newRunningThreads) {
                this.runningThreads = newRunningThreads;
                EPPNetworkHandler.INSTANCE.sendTo((IMessage)new SGenericPacket("running_update", new Object[]{newRunningThreads}), player2);
            }
        }
    }

    private void setupPatternInventory() {
        if (this.isClientSide()) {
            return;
        }
        this.trackers.clear();
        this.trackerMap.clear();
        ClusterAssemblerMatrix cluster = this.host.getCluster();
        if (cluster != null && !cluster.isDestroyed()) {
            for (TileAssemblerMatrixPattern pattern : cluster.getPatterns()) {
                PatternSlotTracker tracker = new PatternSlotTracker(pattern);
                this.trackers.add(tracker);
                this.trackerMap.put(pattern.getLocateID(), (Object)tracker);
            }
        }
    }

    public TileAssemblerMatrixBase getHost() {
        return this.host;
    }

    @NotNull
    public Map<String, Consumer<Paras>> getActionMap() {
        return this.actions;
    }

    private static class PatternSlotTracker {
        private final TileAssemblerMatrixPattern invHost;
        private final InternalInventory client;
        private final InternalInventory server;
        private final Int2ObjectMap<ItemStack> changedMap = new Int2ObjectOpenHashMap();
        private boolean init = false;

        public PatternSlotTracker(TileAssemblerMatrixPattern host) {
            this.invHost = host;
            this.client = new AppEngInternalInventory(36);
            this.server = host.getPatternInventory();
        }

        private Int2ObjectMap<ItemStack> getChangedMap() {
            this.changedMap.clear();
            for (int x = 0; x < this.server.size(); ++x) {
                ItemStack cs;
                ItemStack ss = this.server.getStackInSlot(x);
                if (ItemStack.m_150942_((ItemStack)ss, (ItemStack)(cs = this.client.getStackInSlot(x)))) continue;
                this.changedMap.put(x, (Object)ss.m_41777_());
                this.client.setItemDirect(x, ss.m_41777_());
            }
            return this.changedMap;
        }

        private Int2ObjectMap<ItemStack> getFullMap() {
            this.changedMap.clear();
            for (int x = 0; x < this.server.size(); ++x) {
                this.changedMap.put(x, (Object)this.server.getStackInSlot(x).m_41777_());
            }
            return this.changedMap;
        }

        @Nullable
        public SAssemblerMatrixUpdate createPacket() {
            Int2ObjectMap<ItemStack> map = this.getChangedMap();
            if (map.isEmpty()) {
                return null;
            }
            return new SAssemblerMatrixUpdate(this.invHost.getLocateID(), map);
        }

        public SAssemblerMatrixUpdate fullPacket() {
            return new SAssemblerMatrixUpdate(this.invHost.getLocateID(), this.getFullMap());
        }
    }
}

