/*
 * Decompiled with CFR 0.152.
 */
package jackyy.exchangers.handler;

import jackyy.exchangers.handler.ItemHandler;
import jackyy.exchangers.handler.mode.ModeHorizontalCol;
import jackyy.exchangers.handler.mode.ModePlane;
import jackyy.exchangers.handler.mode.ModeVerticalCol;
import jackyy.exchangers.item.ItemExchangerBase;
import jackyy.exchangers.registry.ModConfigs;
import jackyy.gunpowderlib.helper.ChatHelper;
import jackyy.gunpowderlib.helper.NBTHelper;
import jackyy.gunpowderlib.helper.StringHelper;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import java.util.Set;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.IForgeShearable;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.TierSortingRegistry;
import net.minecraftforge.common.util.BlockSnapshot;
import net.minecraftforge.event.level.BlockEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.registries.ForgeRegistries;

public class ExchangerHandler {
    public static final String[] rangeList = new String[]{"1x1", "3x3", "5x5", "7x7", "9x9", "11x11", "13x13", "15x15", "17x17", "19x19", "21x21", "23x23", "25x25"};

    public static void setDefaultTagCompound(ItemStack stack) {
        Set keySet;
        if (!stack.m_41782_()) {
            CompoundTag compound = new CompoundTag();
            stack.m_41751_(compound);
        }
        if (!(keySet = NBTHelper.getTag((ItemStack)stack).m_128431_()).contains("blockstate")) {
            NBTHelper.getTag((ItemStack)stack).m_128365_("blockstate", (Tag)NbtUtils.m_129202_((BlockState)Blocks.f_50016_.m_49966_()));
        }
        if (!keySet.contains("mode")) {
            NBTHelper.getTag((ItemStack)stack).m_128405_("mode", 0);
        }
        if (!keySet.contains("range")) {
            NBTHelper.getTag((ItemStack)stack).m_128405_("range", 0);
        }
        if (!keySet.contains("forceDropItems")) {
            NBTHelper.getTag((ItemStack)stack).m_128379_("forceDropItems", false);
        }
        if (!keySet.contains("directionalPlacement")) {
            NBTHelper.getTag((ItemStack)stack).m_128379_("directionalPlacement", false);
        }
        if (!keySet.contains("fuzzyPlacement")) {
            NBTHelper.getTag((ItemStack)stack).m_128379_("fuzzyPlacement", false);
        }
        if (!keySet.contains("fuzzyPlacementChance")) {
            NBTHelper.getTag((ItemStack)stack).m_128405_("fuzzyPlacementChance", 100);
        }
        if (!keySet.contains("voidItems")) {
            NBTHelper.getTag((ItemStack)stack).m_128379_("voidItems", false);
        }
    }

    public static int getExPerBlockUse(ItemStack stack) {
        return ((ItemExchangerBase)stack.m_41720_()).getPerBlockUse();
    }

    public static int getPerBlockEnergy(ItemStack stack) {
        int level;
        if (((Boolean)ModConfigs.CONFIG.unbreakingPoweredExchangers.get()).booleanValue() && new Random().nextInt(2 + (level = Mth.m_14045_((int)stack.getEnchantmentLevel(Enchantments.f_44986_), (int)0, (int)10))) >= 2) {
            return 0;
        }
        return ExchangerHandler.getExPerBlockUse(stack);
    }

    public static Tier getExHarvestLevel(ItemStack stack) {
        ItemExchangerBase exchanger = (ItemExchangerBase)stack.m_41720_();
        Tier tier = TierSortingRegistry.byName((ResourceLocation)new ResourceLocation(exchanger.getHarvestLevel()));
        Tier defaultTier = TierSortingRegistry.byName((ResourceLocation)new ResourceLocation(exchanger.getDefaultHarvestLevel()));
        return tier == null ? defaultTier : tier;
    }

    public static int getExRange(ItemStack stack) {
        return ((ItemExchangerBase)stack.m_41720_()).getMaxRange();
    }

    public static boolean getExIsCreative(ItemStack stack) {
        return ((ItemExchangerBase)stack.m_41720_()).isCreative();
    }

    public static boolean getExIsPowered(ItemStack stack) {
        return ((ItemExchangerBase)stack.m_41720_()).isPowered();
    }

    public static void switchRange(ItemStack stack, boolean decrease) {
        ExchangerHandler.setDefaultTagCompound(stack);
        int rangeSwitch = NBTHelper.getTag((ItemStack)stack).m_128451_("range");
        rangeSwitch = decrease ? --rangeSwitch : ++rangeSwitch;
        if (!stack.m_41619_()) {
            if (rangeSwitch > ExchangerHandler.getExRange(stack)) {
                rangeSwitch = 0;
            } else if (rangeSwitch < 0) {
                rangeSwitch = ExchangerHandler.getExRange(stack);
            }
        }
        NBTHelper.getTag((ItemStack)stack).m_128405_("range", rangeSwitch);
    }

    public static void switchMode(Player player, ItemStack stack) {
        ExchangerHandler.setDefaultTagCompound(stack);
        int mode = NBTHelper.getTag((ItemStack)stack).m_128451_("mode");
        mode = player.m_6144_() ? --mode : ++mode;
        if (!stack.m_41619_()) {
            if (mode > 2) {
                mode = 0;
            } else if (mode < 0) {
                mode = 2;
            }
        }
        NBTHelper.getTag((ItemStack)stack).m_128405_("mode", mode);
        switch (mode) {
            case 0: {
                ChatHelper.msgPlayerRaw((Player)player, (Component)StringHelper.localize((String)"exchangers", (String)"msg.mode", (Object[])new Object[]{ModePlane.getDisplayName().m_130940_(ChatFormatting.GREEN)}));
                break;
            }
            case 1: {
                ChatHelper.msgPlayerRaw((Player)player, (Component)StringHelper.localize((String)"exchangers", (String)"msg.mode", (Object[])new Object[]{ModeHorizontalCol.getDisplayName().m_130940_(ChatFormatting.GREEN)}));
                break;
            }
            case 2: {
                ChatHelper.msgPlayerRaw((Player)player, (Component)StringHelper.localize((String)"exchangers", (String)"msg.mode", (Object[])new Object[]{ModeVerticalCol.getDisplayName().m_130940_(ChatFormatting.GREEN)}));
            }
        }
    }

    public static void toggleForceDropItems(Player player, ItemStack stack) {
        ExchangerHandler.setDefaultTagCompound(stack);
        boolean toggle = NBTHelper.getTag((ItemStack)stack).m_128471_("forceDropItems");
        if (!stack.m_41619_()) {
            toggle = !toggle;
        }
        NBTHelper.getTag((ItemStack)stack).m_128379_("forceDropItems", toggle);
        ChatHelper.msgPlayer((Player)player, (String)"exchangers", (String)(toggle ? "msg.force_drop_items.on" : "msg.force_drop_items.off"));
    }

    public static void toggleDirectionalPlacement(Player player, ItemStack stack) {
        ExchangerHandler.setDefaultTagCompound(stack);
        boolean toggle = NBTHelper.getTag((ItemStack)stack).m_128471_("directionalPlacement");
        if (!stack.m_41619_()) {
            toggle = !toggle;
        }
        NBTHelper.getTag((ItemStack)stack).m_128379_("directionalPlacement", toggle);
        ChatHelper.msgPlayer((Player)player, (String)"exchangers", (String)(toggle ? "msg.directional_placement.on" : "msg.directional_placement.off"));
    }

    public static void toggleFuzzyPlacement(Player player, ItemStack stack) {
        ExchangerHandler.setDefaultTagCompound(stack);
        boolean toggle = NBTHelper.getTag((ItemStack)stack).m_128471_("fuzzyPlacement");
        if (!stack.m_41619_()) {
            toggle = !toggle;
        }
        NBTHelper.getTag((ItemStack)stack).m_128379_("fuzzyPlacement", toggle);
        ChatHelper.msgPlayer((Player)player, (String)"exchangers", (String)(toggle ? "msg.fuzzy_placement.on" : "msg.fuzzy_placement.off"));
    }

    public static void setFuzzyPlacementChance(ItemStack stack, int chance) {
        ExchangerHandler.setDefaultTagCompound(stack);
        int currentChance = NBTHelper.getTag((ItemStack)stack).m_128451_("fuzzyPlacementChance");
        if (!stack.m_41619_()) {
            currentChance = chance;
        }
        NBTHelper.getTag((ItemStack)stack).m_128405_("fuzzyPlacementChance", currentChance);
    }

    public static void toggleVoidItems(Player player, ItemStack stack) {
        ExchangerHandler.setDefaultTagCompound(stack);
        boolean toggle = NBTHelper.getTag((ItemStack)stack).m_128471_("voidItems");
        if (!stack.m_41619_()) {
            toggle = !toggle;
        }
        NBTHelper.getTag((ItemStack)stack).m_128379_("voidItems", toggle);
        ChatHelper.msgPlayer((Player)player, (String)"exchangers", (String)(toggle ? "msg.void_items.on" : "msg.void_items.off"));
    }

    public static boolean isWhitelisted(Level world, BlockPos pos) {
        for (String block : ((String)ModConfigs.CONFIG.blocksWhitelist.get()).trim().split(";")) {
            if (!world.m_8055_(pos).m_222976_().m_203373_(new ResourceLocation(block))) continue;
            return true;
        }
        return false;
    }

    public static boolean isBlacklisted(Level world, BlockPos pos) {
        for (String block : ((String)ModConfigs.CONFIG.blocksBlacklist.get()).trim().split(";")) {
            if (!world.m_8055_(pos).m_222976_().m_203373_(new ResourceLocation(block))) continue;
            return true;
        }
        return false;
    }

    public static void placeBlock(ItemStack stack, Player player, Level world, BlockPos pos, Direction side, UseOnContext context) {
        CompoundTag tag = NBTHelper.getTag((ItemStack)stack);
        BlockState state = NbtUtils.m_247651_((HolderGetter)world.m_246945_(Registries.f_256747_), (CompoundTag)tag.m_128469_("blockstate"));
        Block block = state.m_60734_();
        BlockState oldState = world.m_8055_(pos);
        Block oldblock = oldState.m_60734_();
        float blockHardness = oldState.m_60800_((BlockGetter)world, pos);
        if (block == Blocks.f_50016_) {
            return;
        }
        if (block == oldblock && state == oldState) {
            return;
        }
        if (world.m_7702_(pos) != null && !ExchangerHandler.isWhitelisted(world, pos)) {
            ChatHelper.msgPlayer((Player)player, (String)"exchangers", (String)"error.invalid_block.te");
            return;
        }
        if (ExchangerHandler.isBlacklisted(world, pos)) {
            ChatHelper.msgPlayer((Player)player, (String)"exchangers", (String)"error.blacklisted");
            return;
        }
        if (!ExchangerHandler.getExIsCreative(stack)) {
            if (blockHardness < -0.1f) {
                ChatHelper.msgPlayer((Player)player, (String)"exchangers", (String)"error.invalid_block.unbreakable");
                return;
            }
            if (ExchangerHandler.getExIsPowered(stack) && NBTHelper.getTag((ItemStack)stack).m_128451_("Energy") < ExchangerHandler.getPerBlockEnergy(stack)) {
                ChatHelper.msgPlayer((Player)player, (String)"exchangers", (String)"error.out_of_power");
                return;
            }
            if (!TierSortingRegistry.isCorrectTierForDrops((Tier)ExchangerHandler.getExHarvestLevel(stack), (BlockState)oldState)) {
                ChatHelper.msgPlayer((Player)player, (String)"exchangers", (String)"error.low_harvest_level");
                return;
            }
        }
        Set<BlockPos> suitableBlocks = ExchangerHandler.findSuitableBlocks(stack, world, player, side, pos, oldState);
        Set<Object> toBePlaced = new HashSet();
        boolean notEnough = false;
        world.captureBlockSnapshots = false;
        for (BlockPos blockPos : suitableBlocks) {
            if (tag.m_128471_("fuzzyPlacement")) {
                if (new Random().nextInt(100) >= tag.m_128451_("fuzzyPlacementChance")) continue;
                toBePlaced.add(blockPos);
                continue;
            }
            toBePlaced = suitableBlocks;
        }
        for (BlockPos blockPos : toBePlaced) {
            BlockEvent.EntityPlaceEvent event = new BlockEvent.EntityPlaceEvent(BlockSnapshot.create((ResourceKey)world.m_46472_(), (LevelAccessor)world, (BlockPos)blockPos, (int)3), Blocks.f_50016_.m_49966_(), (Entity)player);
            if (state.m_61138_((Property)BlockStateProperties.f_61362_)) {
                state = (BlockState)state.m_61124_((Property)BlockStateProperties.f_61362_, (Comparable)Boolean.valueOf(false));
            }
            if (!tag.m_128471_("directionalPlacement")) {
                world.m_7731_(blockPos, state, 3);
            }
            if (tag.m_128471_("directionalPlacement")) {
                BlockState placeState = block.m_5573_(new BlockPlaceContext(context));
                if (placeState != null) {
                    world.m_7731_(blockPos, placeState, 3);
                } else {
                    world.m_7731_(blockPos, state, 3);
                }
            }
            if (!MinecraftForge.EVENT_BUS.post((Event)event)) {
                if (ItemHandler.consumeItemInInventory(block.m_5456_(), player.m_150109_(), player)) {
                    if (!(player.m_7500_() || ExchangerHandler.getExIsCreative(stack) || tag.m_128471_("voidItems"))) {
                        if (((Boolean)ModConfigs.CONFIG.doExchangersSilkTouch.get()).booleanValue() || stack.getEnchantmentLevel(Enchantments.f_44985_) > 0) {
                            ItemStack oldblockItem = !(oldblock instanceof IForgeShearable) ? ItemHandler.getSilkTouchDrop(oldState) : oldblock.getCloneItemStack(oldState, null, (BlockGetter)world, pos, player);
                            if (oldblockItem.m_41720_().equals(Items.f_41852_)) {
                                oldblockItem = oldblock.getCloneItemStack(oldState, null, (BlockGetter)world, pos, player);
                            }
                            ItemHandler.giveItem(world, player, oldblockItem);
                        } else {
                            ServerLevel serverWorld = (ServerLevel)world;
                            ItemStack tool = oldState.m_204336_(BlockTags.f_144282_) ? new ItemStack((ItemLike)Items.f_42395_) : (oldState.m_204336_(BlockTags.f_144280_) ? new ItemStack((ItemLike)Items.f_42396_) : (oldState.m_204336_(BlockTags.f_144283_) ? new ItemStack((ItemLike)Items.f_42394_) : new ItemStack((ItemLike)Items.f_42398_)));
                            int fortuneLevel = stack.getEnchantmentLevel(Enchantments.f_44987_);
                            tool.m_41663_(Enchantments.f_44987_, fortuneLevel);
                            LootParams.Builder builder = new LootParams.Builder(serverWorld).m_287286_(LootContextParams.f_81460_, (Object)Vec3.m_82512_((Vec3i)pos)).m_287286_(LootContextParams.f_81463_, (Object)tool);
                            List oldblockItems = oldState.m_287290_(builder);
                            for (ItemStack oldblockItem : oldblockItems) {
                                ItemHandler.giveItem(world, player, oldblockItem);
                            }
                        }
                        if (!ExchangerHandler.getExIsPowered(stack)) {
                            stack.m_41622_(1, (LivingEntity)player, entity -> entity.m_21166_(EquipmentSlot.MAINHAND));
                        } else if (tag.m_128451_("Energy") >= ExchangerHandler.getPerBlockEnergy(stack)) {
                            tag.m_128405_("Energy", tag.m_128451_("Energy") - ExchangerHandler.getPerBlockEnergy(stack));
                        }
                        player.f_36096_.m_38946_();
                    }
                    world.m_6263_(null, (double)blockPos.m_123341_(), (double)blockPos.m_123342_(), (double)blockPos.m_123343_(), SoundEvents.f_11852_, SoundSource.BLOCKS, 0.1f, 1.0f);
                    continue;
                }
                world.restoringBlockSnapshots = true;
                event.getBlockSnapshot().restore(true);
                world.restoringBlockSnapshots = false;
                notEnough = true;
                continue;
            }
            world.restoringBlockSnapshots = true;
            event.getBlockSnapshot().restore(true);
            world.restoringBlockSnapshots = false;
            ChatHelper.msgPlayer((Player)player, (String)"exchangers", (String)"error.event_cancelled");
        }
        if (notEnough) {
            ChatHelper.msgPlayer((Player)player, (String)"exchangers", (String)"error.out_of_block");
        }
        world.captureBlockSnapshots = true;
    }

    public static void selectBlock(ItemStack stack, Player player, Level world, BlockPos pos) {
        ExchangerHandler.setDefaultTagCompound(stack);
        BlockState state = world.m_8055_(pos);
        float blockHardness = state.m_60800_((BlockGetter)world, pos);
        if (world.m_7702_(pos) != null && !ExchangerHandler.isWhitelisted(world, pos)) {
            ChatHelper.msgPlayer((Player)player, (String)"exchangers", (String)"error.invalid_block.te");
            return;
        }
        if (ExchangerHandler.isBlacklisted(world, pos)) {
            ChatHelper.msgPlayer((Player)player, (String)"exchangers", (String)"error.blacklisted");
            return;
        }
        if (!ExchangerHandler.getExIsCreative(stack) && blockHardness < -0.1f) {
            ChatHelper.msgPlayer((Player)player, (String)"exchangers", (String)"error.invalid_block.unbreakable");
            return;
        }
        NBTHelper.getTag((ItemStack)stack).m_128365_("blockstate", (Tag)NbtUtils.m_129202_((BlockState)state));
    }

    public static Set<BlockPos> findSuitableBlocks(ItemStack stack, Level world, Player player, Direction sideHit, BlockPos pos, BlockState centerState) {
        HashSet<BlockPos> coordinates = new HashSet<BlockPos>();
        int range = NBTHelper.getTag((ItemStack)stack).m_128451_("range");
        int mode = NBTHelper.getTag((ItemStack)stack).m_128451_("mode");
        switch (mode) {
            case 0: {
                ModePlane.invoke(coordinates, range, world, sideHit, pos, centerState);
                break;
            }
            case 1: {
                ModeHorizontalCol.invoke(coordinates, range, world, player, sideHit, pos, centerState);
                break;
            }
            case 2: {
                ModeVerticalCol.invoke(coordinates, range, world, player, sideHit, pos, centerState);
            }
        }
        return coordinates;
    }

    public static void checkAndAddBlock(Level world, BlockPos pos, BlockState centerState, Set<BlockPos> coordinates) {
        BlockState state = world.m_8055_(pos);
        if (state == centerState) {
            coordinates.add(pos);
        }
    }

    public static MutableComponent getBlockName(Block block) {
        ItemStack stack = new ItemStack((ItemLike)block, 1);
        MutableComponent name = stack.m_41786_().m_6881_();
        if (name.toString().isEmpty()) {
            name = ForgeRegistries.BLOCKS.getKey((Object)block) != null ? Component.m_237113_((String)ForgeRegistries.BLOCKS.getKey((Object)block).toString()) : StringHelper.localize((String)"exchangers", (String)"tooltip.selected_block.error", (Object[])new Object[0]);
        }
        return name;
    }
}

