/*
 * Decompiled with CFR 0.152.
 */
package com.enderio.base.common.item.capacitors;

import com.enderio.api.capability.IMultiCapabilityItem;
import com.enderio.api.capability.MultiCapabilityProvider;
import com.enderio.api.capacitor.CapacitorModifier;
import com.enderio.api.capacitor.ICapacitorData;
import com.enderio.base.common.capacitor.CapacitorUtil;
import com.enderio.base.common.capacitor.LootCapacitorData;
import com.enderio.base.common.init.EIOCapabilities;
import com.enderio.base.common.item.capacitors.BaseCapacitorItem;
import com.enderio.base.common.lang.EIOLang;
import java.util.Optional;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.util.LazyOptional;
import org.jetbrains.annotations.Nullable;

public class LootCapacitorItem
extends BaseCapacitorItem
implements IMultiCapabilityItem {
    public LootCapacitorItem(Item.Properties pProperties) {
        super(pProperties);
    }

    @Override
    @Nullable
    public MultiCapabilityProvider initCapabilities(ItemStack stack, CompoundTag nbt, MultiCapabilityProvider provider) {
        provider.add(EIOCapabilities.CAPACITOR, LazyOptional.of(() -> new LootCapacitorData(stack)));
        return provider;
    }

    public Component m_7626_(ItemStack pStack) {
        Optional<ICapacitorData> capacitorDataOpt = CapacitorUtil.getCapacitorData(pStack);
        if (capacitorDataOpt.isEmpty()) {
            return super.m_7626_(pStack);
        }
        ICapacitorData capacitorData = capacitorDataOpt.get();
        if (capacitorData.getAllModifiers().isEmpty()) {
            return this.getBaseName(capacitorData);
        }
        return this.getModifierQuality(capacitorData).m_6881_().m_130946_(" ").m_7220_((Component)this.getModifierType(capacitorData)).m_130946_(" ").m_7220_((Component)this.getBaseName(capacitorData));
    }

    private MutableComponent getBaseName(ICapacitorData capacitorData) {
        float base = capacitorData.getBase();
        if (base < 1.0f) {
            return EIOLang.LOOT_CAPACITOR_BASE_DUD;
        }
        if (base < 1.5f) {
            return EIOLang.LOOT_CAPACITOR_BASE_NORMAL;
        }
        if (base < 2.5f) {
            return EIOLang.LOOT_CAPACITOR_BASE_ENHANCED;
        }
        if (base < 3.5f) {
            return EIOLang.LOOT_CAPACITOR_BASE_WONDER;
        }
        return EIOLang.LOOT_CAPACITOR_BASE_IMPOSSIBLE;
    }

    private MutableComponent getModifierType(ICapacitorData capacitorData) {
        Optional firstType = capacitorData.getAllModifiers().keySet().stream().findFirst();
        if (firstType.isEmpty()) {
            throw new IllegalArgumentException();
        }
        if (firstType.get() == CapacitorModifier.ENERGY_CAPACITY) {
            return EIOLang.LOOT_CAPACITOR_TYPE_ENERGY_CAPACITY;
        }
        if (firstType.get() == CapacitorModifier.ENERGY_USE) {
            return EIOLang.LOOT_CAPACITOR_TYPE_ENERGY_USE;
        }
        if (firstType.get() == CapacitorModifier.FUEL_EFFICIENCY) {
            return EIOLang.LOOT_CAPACITOR_TYPE_FUEL_EFFICIENCY;
        }
        if (firstType.get() == CapacitorModifier.BURNING_ENERGY_GENERATION) {
            return EIOLang.LOOT_CAPACITOR_TYPE_BURNING_ENERGY_GENERATION;
        }
        return EIOLang.LOOT_CAPACITOR_TYPE_UNKNOWN;
    }

    private MutableComponent getModifierQuality(ICapacitorData capacitorData) {
        Optional<Float> firstModifier = capacitorData.getAllModifiers().values().stream().findFirst();
        if (firstModifier.isEmpty()) {
            throw new IllegalArgumentException();
        }
        float modifier = firstModifier.get().floatValue();
        if (modifier < 1.0f) {
            return EIOLang.LOOT_CAPACITOR_MODIFIER_FAILED;
        }
        if (modifier < 1.5f) {
            return EIOLang.LOOT_CAPACITOR_MODIFIER_SIMPLE;
        }
        if (modifier < 2.5f) {
            return EIOLang.LOOT_CAPACITOR_MODIFIER_NICE;
        }
        if (modifier < 3.0f) {
            return EIOLang.LOOT_CAPACITOR_MODIFIER_GOOD;
        }
        if (modifier < 3.5f) {
            return EIOLang.LOOT_CAPACITOR_MODIFIER_ENHANCED;
        }
        if (modifier < 4.0f) {
            return EIOLang.LOOT_CAPACITOR_MODIFIER_PREMIUM;
        }
        if (modifier < 4.25f) {
            return EIOLang.LOOT_CAPACITOR_MODIFIER_INCREDIBLY;
        }
        return EIOLang.LOOT_CAPACITOR_MODIFIER_UNSTABLE;
    }
}

