/*
 * Decompiled with CFR 0.152.
 */
package com.enderio.base.common.block.painted;

import com.enderio.base.common.blockentity.SinglePaintedBlockEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.Tag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import net.minecraftforge.common.extensions.IForgeBlock;
import org.jetbrains.annotations.Nullable;

public interface IPaintedBlock
extends IForgeBlock {
    default public float getFriction(BlockState state, LevelReader level, BlockPos pos, @Nullable Entity entity) {
        return this.getPaintState((BlockGetter)level, pos).getFriction(level, pos, entity);
    }

    default public SoundType getSoundType(BlockState state, LevelReader level, BlockPos pos, @Nullable Entity entity) {
        return this.getPaintState((BlockGetter)level, pos).getSoundType(level, pos, entity);
    }

    default public boolean shouldDisplayFluidOverlay(BlockState state, BlockAndTintGetter level, BlockPos pos, FluidState fluidState) {
        return this.getPaintState((BlockGetter)level, pos).shouldDisplayFluidOverlay(level, pos, fluidState);
    }

    default public boolean supportsExternalFaceHiding(BlockState state) {
        return true;
    }

    default public BlockState getPaintState(BlockGetter level, BlockPos pos) {
        return this.getPaint(level, pos).m_49966_();
    }

    default public Block getPaint(BlockGetter level, BlockPos pos) {
        SinglePaintedBlockEntity paintedBlockEntity;
        Block paint;
        BlockEntity blockEntity = level.getExistingBlockEntity(pos);
        if (blockEntity instanceof SinglePaintedBlockEntity && (paint = (paintedBlockEntity = (SinglePaintedBlockEntity)blockEntity).getPaint()) != null && !(paint instanceof IPaintedBlock)) {
            return paint;
        }
        return Blocks.f_50705_;
    }

    default public ItemStack getPaintedStack(BlockGetter level, BlockPos pos, ItemLike itemLike) {
        ItemStack stack = new ItemStack(itemLike);
        BlockEntity be = level.m_7702_(pos);
        if (be != null) {
            stack.m_41784_().m_128365_("BlockEntityTag", (Tag)be.m_187482_());
        }
        return stack;
    }
}

