/*
 * Decompiled with CFR 0.152.
 */
package edivad.edivadlib.compat.top;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import edivad.edivadlib.tools.utils.GuiUtils;
import mcjty.theoneprobe.api.IElement;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.network.chat.MutableComponent;
import org.jetbrains.annotations.Nullable;

public abstract class TOPElement
implements IElement {
    private final int borderColor;
    private final int textColor;

    protected TOPElement(int borderColor, int textColor) {
        this.borderColor = borderColor;
        this.textColor = textColor;
    }

    protected static void renderScaledText(GuiGraphics guiGraphics, Font font, int x, int y, int color, int maxWidth, MutableComponent component) {
        String text = component.getString();
        int length = font.m_92895_(text);
        if (length <= maxWidth) {
            guiGraphics.m_280488_(font, text, x, y, color);
        } else {
            float scale = (float)maxWidth / (float)length;
            float reverse = 1.0f / scale;
            float yAdd = 4.0f - scale * 8.0f / 2.0f;
            PoseStack poseStack = guiGraphics.m_280168_();
            poseStack.m_85836_();
            poseStack.m_85841_(scale, scale, scale);
            guiGraphics.m_280488_(font, text, (int)((float)x * reverse), (int)((float)y * reverse + yAdd), color);
            poseStack.m_85849_();
        }
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    public void render(GuiGraphics guiGraphics, int x, int y) {
        int scale;
        int width = this.getWidth();
        int height = this.getHeight();
        guiGraphics.m_280509_(x, y, x + width - 1, y + 1, this.borderColor);
        guiGraphics.m_280509_(x, y, x + 1, y + height - 1, this.borderColor);
        guiGraphics.m_280509_(x + width - 1, y, x + width, y + height - 1, this.borderColor);
        guiGraphics.m_280509_(x, y + height - 1, x + width, y + height, this.borderColor);
        TextureAtlasSprite icon = this.getIcon();
        if (icon != null && (scale = this.getScaledLevel(width - 2)) > 0) {
            boolean colored = this.applyRenderColor();
            GuiUtils.drawTiledSprite(x + 1, y + 1, height - 2, scale, height - 2, icon, 16, 16, 0);
            if (colored) {
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            }
        }
        TOPElement.renderScaledText(guiGraphics, Minecraft.m_91087_().f_91062_, x + 4, y + 3, this.textColor, this.getWidth() - 8, this.getText());
    }

    public int getWidth() {
        return 100;
    }

    public int getHeight() {
        return 13;
    }

    public abstract int getScaledLevel(int var1);

    @Nullable
    public abstract TextureAtlasSprite getIcon();

    public abstract MutableComponent getText();

    protected boolean applyRenderColor() {
        return false;
    }
}

