/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.items.tools;

import com.brandon3055.brandonscore.api.TechLevel;
import com.brandon3055.brandonscore.api.power.IOPStorage;
import com.brandon3055.brandonscore.capability.MultiCapabilityProvider;
import com.brandon3055.brandonscore.utils.DataUtils;
import com.brandon3055.brandonscore.utils.EnergyUtils;
import com.brandon3055.draconicevolution.api.IInvCharge;
import com.brandon3055.draconicevolution.api.capability.DECapabilities;
import com.brandon3055.draconicevolution.api.capability.ModuleHost;
import com.brandon3055.draconicevolution.api.config.BooleanProperty;
import com.brandon3055.draconicevolution.api.modules.ModuleCategory;
import com.brandon3055.draconicevolution.api.modules.lib.ModularOPStorage;
import com.brandon3055.draconicevolution.api.modules.lib.ModuleHostImpl;
import com.brandon3055.draconicevolution.init.DEContent;
import com.brandon3055.draconicevolution.init.EquipCfg;
import com.brandon3055.draconicevolution.init.ModuleCfg;
import com.brandon3055.draconicevolution.init.TechProperties;
import com.brandon3055.draconicevolution.integration.equipment.EquipmentManager;
import com.brandon3055.draconicevolution.items.equipment.DETier;
import com.brandon3055.draconicevolution.items.equipment.IModularItem;
import com.brandon3055.draconicevolution.lib.WTFException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class DraconiumCapacitor
extends Item
implements IInvCharge,
IModularItem {
    private TechLevel techLevel;

    public DraconiumCapacitor(TechProperties properties) {
        super((Item.Properties)properties);
        this.techLevel = properties.getTechLevel();
    }

    @Override
    public boolean canCharge(ItemStack stack, LivingEntity player, boolean isHeld) {
        return isHeld;
    }

    @Override
    public TechLevel getTechLevel() {
        return this.techLevel;
    }

    @Override
    public ModuleHostImpl createHost(ItemStack stack) {
        ModuleHostImpl host = this == DEContent.CAPACITOR_CREATIVE.get() ? new ModuleHostImpl(this.techLevel, 1, 1, "capacitor", ModuleCfg.removeInvalidModules, new ModuleCategory[0]) : new ModuleHostImpl(this.techLevel, ModuleCfg.capacitorWidth(this.techLevel), ModuleCfg.capacitorHeight(this.techLevel), "capacitor", ModuleCfg.removeInvalidModules, new ModuleCategory[0]);
        host.addPropertyBuilder(props -> {
            props.add(new BooleanProperty("charge_held_item", false));
            props.add(new BooleanProperty("charge_armor", false));
            props.add(new BooleanProperty("charge_hot_bar", false));
            props.add(new BooleanProperty("charge_main", false));
            if (EquipmentManager.equipModLoaded()) {
                props.add(new BooleanProperty("charge_" + EquipmentManager.equipModID(), false));
            }
        });
        return host;
    }

    @Override
    public MultiCapabilityProvider initCapabilities(ItemStack stack, @Nullable CompoundTag nbt) {
        MultiCapabilityProvider prov = IModularItem.super.initCapabilities(stack, nbt);
        if (this == DEContent.CAPACITOR_CREATIVE.get() && prov != null) {
            ModuleHost host = (ModuleHost)prov.getCapability(DECapabilities.MODULE_HOST_CAPABILITY).orElseThrow(WTFException::new);
            host.getModuleCategories().remove(ModuleCategory.ENERGY);
        }
        return prov;
    }

    @Override
    @Nullable
    public ModularOPStorage createOPStorage(ItemStack stack, ModuleHostImpl host) {
        if (this == DEContent.CAPACITOR_CREATIVE.get()) {
            return new ModularOPStorage(host, Long.MAX_VALUE, Long.MAX_VALUE){

                public long getOPStored() {
                    return 0x3FFFFFFFFFFFFFFFL;
                }

                public long receiveOP(long maxReceive, boolean simulate) {
                    return maxReceive;
                }

                public long extractOP(long maxExtract, boolean simulate) {
                    return maxExtract;
                }

                public boolean canExtract() {
                    return true;
                }
            }.setIOMode(true, true);
        }
        return new ModularOPStorage(host, EquipCfg.getBaseCapEnergy(this.techLevel), EquipCfg.getBaseCapTransfer(this.techLevel)).setIOMode(true, true);
    }

    @Override
    public void handleTick(ItemStack stack, LivingEntity entity, @Nullable EquipmentSlot slot, boolean inEquipModSlot) {
        IModularItem.super.handleTick(stack, entity, slot, inEquipModSlot);
        ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
        stack.getCapability(DECapabilities.PROPERTY_PROVIDER_CAPABILITY).ifPresent(props -> {
            boolean held = props.getBool("charge_held_item").getValue();
            boolean armor = props.getBool("charge_armor").getValue();
            boolean hot_bar = props.getBool("charge_hot_bar").getValue();
            boolean main = props.getBool("charge_main").getValue();
            if (EquipmentManager.equipModLoaded() && props.getBool("charge_" + EquipmentManager.equipModID()).getValue()) {
                stacks.addAll(EquipmentManager.getAllItems(entity));
            }
            if (entity instanceof Player) {
                Player player = (Player)entity;
                if (hot_bar && main) {
                    stacks.addAll((Collection<ItemStack>)player.m_150109_().f_35974_);
                } else if (hot_bar) {
                    stacks.addAll(player.m_150109_().f_35974_.subList(0, 9));
                } else if (main) {
                    stacks.addAll(player.m_150109_().f_35974_.subList(9, 36));
                }
                if (held) {
                    if (!hot_bar) {
                        stacks.add(entity.m_21205_());
                    }
                    stacks.add(entity.m_21206_());
                }
            } else if (held) {
                entity.m_6167_().forEach(stacks::add);
            }
            if (armor) {
                entity.m_6168_().forEach(stacks::add);
            }
        });
        stacks.remove(stack);
        if (!stacks.isEmpty()) {
            this.updateEnergy(stack, entity, stacks);
        }
    }

    public void updateEnergy(ItemStack capacitor, LivingEntity player, List<ItemStack> stacks) {
        capacitor.getCapability(DECapabilities.OP_STORAGE).ifPresent(e -> {
            IOPStorage storage = e;
            for (ItemStack stack : stacks) {
                Item item;
                if (!EnergyUtils.canReceiveEnergy((ItemStack)stack) || (item = stack.m_41720_()) instanceof IInvCharge && !((IInvCharge)item).canCharge(stack, player, DataUtils.contains((Iterable)player.m_6167_(), (Object)stack))) continue;
                EnergyUtils.insertEnergy((ItemStack)stack, (long)EnergyUtils.extractEnergy((ItemStack)capacitor, (long)EnergyUtils.insertEnergy((ItemStack)stack, (long)storage.getOPStored(), (boolean)true), (boolean)false), (boolean)false);
            }
        });
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack stack, @Nullable Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        this.addModularItemInformation(stack, worldIn, tooltip, flagIn);
    }

    public int m_6473_() {
        return DETier.getEnchantability(this.techLevel);
    }

    public boolean m_8120_(ItemStack stack) {
        return true;
    }

    public boolean m_142522_(ItemStack stack) {
        return this.damageBarVisible(stack);
    }

    public int m_142158_(ItemStack stack) {
        return this.damageBarWidth(stack);
    }

    public int m_142159_(ItemStack stack) {
        return this.damageBarColour(stack);
    }

    public boolean m_41386_(DamageSource source) {
        return source.m_276093_(DamageTypes.f_268724_);
    }

    public boolean onEntityItemUpdate(ItemStack stack, ItemEntity entity) {
        if (entity.m_32059_() >= 0) {
            entity.m_32064_();
        }
        return super.onEntityItemUpdate(stack, entity);
    }
}

