/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.items.equipment;

import codechicken.lib.util.ItemUtils;
import codechicken.lib.vec.Vector3;
import com.brandon3055.brandonscore.api.TechLevel;
import com.brandon3055.brandonscore.capability.MultiCapabilityProvider;
import com.brandon3055.brandonscore.inventory.BlockToStackHelper;
import com.brandon3055.draconicevolution.api.IDraconicMelee;
import com.brandon3055.draconicevolution.api.capability.DECapabilities;
import com.brandon3055.draconicevolution.api.capability.ModuleHost;
import com.brandon3055.draconicevolution.api.capability.PropertyProvider;
import com.brandon3055.draconicevolution.api.config.ConfigProperty;
import com.brandon3055.draconicevolution.api.config.IntegerProperty;
import com.brandon3055.draconicevolution.api.modules.ModuleCategory;
import com.brandon3055.draconicevolution.api.modules.ModuleTypes;
import com.brandon3055.draconicevolution.api.modules.data.AOEData;
import com.brandon3055.draconicevolution.api.modules.lib.ModularOPStorage;
import com.brandon3055.draconicevolution.api.modules.lib.ModuleHostImpl;
import com.brandon3055.draconicevolution.init.EquipCfg;
import com.brandon3055.draconicevolution.init.ModuleCfg;
import com.brandon3055.draconicevolution.init.TechProperties;
import com.brandon3055.draconicevolution.items.equipment.DETier;
import com.brandon3055.draconicevolution.items.equipment.IModularTieredItem;
import com.mojang.datafixers.util.Pair;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.HoeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SupportType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ToolActions;
import net.minecraftforge.common.util.BlockSnapshot;
import net.minecraftforge.event.ForgeEventFactory;

public class ModularHoe
extends HoeItem
implements IModularTieredItem,
IDraconicMelee {
    private final TechLevel techLevel;
    private final DETier itemTier;

    public ModularHoe(DETier tier, TechProperties props) {
        super((Tier)tier, 0, 0.0f, (Item.Properties)props);
        this.techLevel = props.getTechLevel();
        this.itemTier = (DETier)this.m_43314_();
    }

    @Override
    public TechLevel getTechLevel() {
        return this.techLevel;
    }

    @Override
    public DETier getItemTier() {
        return this.itemTier;
    }

    @Override
    public double getSwingSpeedMultiplier() {
        return EquipCfg.hoeSwingSpeedMultiplier;
    }

    @Override
    public double getDamageMultiplier() {
        return EquipCfg.hoeDamageMultiplier;
    }

    @Override
    public ModuleHostImpl createHost(ItemStack stack) {
        ModuleHostImpl host = new ModuleHostImpl(this.techLevel, ModuleCfg.toolWidth(this.techLevel), ModuleCfg.toolHeight(this.techLevel), "hoe", ModuleCfg.removeInvalidModules, new ModuleCategory[0]);
        host.addCategories(ModuleCategory.TOOL_HOE);
        return host;
    }

    @Override
    public void initCapabilities(ItemStack stack, ModuleHostImpl host, MultiCapabilityProvider provider) {
        host.addPropertyBuilder(props -> {
            AOEData aoe = host.getModuleData(ModuleTypes.AOE);
            if (aoe != null) {
                props.add(new IntegerProperty("tool_aoe", aoe.aoe()).range(0, aoe.aoe()).setFormatter(ConfigProperty.IntegerFormatter.AOE));
            }
        });
    }

    @Override
    @Nullable
    public ModularOPStorage createOPStorage(ItemStack stack, ModuleHostImpl host) {
        return new ModularOPStorage(host, EquipCfg.getBaseToolEnergy(this.techLevel), EquipCfg.getBaseToolTransfer(this.techLevel));
    }

    @Override
    public float m_8102_(ItemStack stack, BlockState state) {
        return IModularTieredItem.super.m_8102_(stack, state);
    }

    @Override
    public float getBaseEfficiency() {
        return this.m_43314_().m_6624_();
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack stack, @Nullable Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        this.addModularItemInformation(stack, worldIn, tooltip, flagIn);
    }

    public boolean m_142522_(ItemStack stack) {
        return this.damageBarVisible(stack);
    }

    public int m_142158_(ItemStack stack) {
        return this.damageBarWidth(stack);
    }

    public int m_142159_(ItemStack stack) {
        return this.damageBarColour(stack);
    }

    public boolean m_41386_(DamageSource source) {
        return source.m_276093_(DamageTypes.f_268724_);
    }

    public boolean onEntityItemUpdate(ItemStack stack, ItemEntity entity) {
        if (entity.m_32059_() >= 0) {
            entity.m_32064_();
        }
        return super.onEntityItemUpdate(stack, entity);
    }

    public boolean m_8120_(ItemStack p_41456_) {
        return true;
    }

    public InteractionResult m_6225_(UseOnContext context) {
        ItemStack stack = context.m_43722_();
        ModuleHost host = (ModuleHost)stack.getCapability(DECapabilities.MODULE_HOST_CAPABILITY).orElseThrow(IllegalStateException::new);
        int aoe = host.getModuleData(ModuleTypes.AOE, new AOEData(0)).aoe();
        if (host instanceof PropertyProvider && ((PropertyProvider)((Object)host)).hasInt("tool_aoe")) {
            aoe = ((PropertyProvider)((Object)host)).getInt("tool_aoe").getValue();
        }
        Level level = context.m_43725_();
        if (!this.attemptTillOp(context) && !level.m_8055_(context.m_8083_()).m_60713_(Blocks.f_50093_)) {
            return InteractionResult.FAIL;
        }
        Player player = context.m_43723_();
        if (player == null || player.m_6144_()) {
            return InteractionResult.SUCCESS;
        }
        BlockPos origin = context.m_8083_();
        int aoe_range = aoe;
        BlockToStackHelper.startItemCapture();
        for (BlockPos aoePos : BlockPos.m_121940_((BlockPos)origin.m_7918_(-aoe_range, 0, -aoe_range), (BlockPos)origin.m_7918_(aoe_range, 0, aoe_range))) {
            boolean up2OK;
            boolean canceled;
            boolean lowerBlockOk;
            if (aoePos.equals((Object)origin)) continue;
            BlockState aoeState = level.m_8055_(aoePos);
            boolean airOrReplaceable = level.m_46859_(aoePos) || aoeState.m_204336_(BlockTags.f_278394_);
            boolean bl = lowerBlockOk = level.m_8055_(aoePos.m_7495_()).m_60659_((BlockGetter)level, aoePos.m_7495_(), Direction.UP, SupportType.CENTER) || level.m_8055_(aoePos.m_7495_()).m_60713_(Blocks.f_50093_);
            if (airOrReplaceable && lowerBlockOk && (player.m_150110_().f_35937_ || player.m_150109_().m_36063_(new ItemStack((ItemLike)Items.f_42329_))) && !(canceled = ForgeEventFactory.onBlockPlace((Entity)player, (BlockSnapshot)BlockSnapshot.create((ResourceKey)level.m_46472_(), (LevelAccessor)level, (BlockPos)aoePos), (Direction)Direction.UP)) && (player.m_150110_().f_35937_ || this.consumeItem(Items.f_42329_, player.m_150109_()))) {
                level.m_46597_(aoePos, Blocks.f_50493_.m_49966_());
            }
            boolean canDropAbove = level.m_8055_(aoePos.m_7494_()).m_60713_(Blocks.f_50493_) || level.m_8055_(aoePos.m_7494_()).m_60713_(Blocks.f_50440_) || level.m_8055_(aoePos.m_7494_()).m_60713_(Blocks.f_50093_);
            boolean canRemoveAbove = canDropAbove || level.m_8055_(aoePos.m_7494_()).m_204336_(BlockTags.f_278394_);
            boolean bl2 = up2OK = level.m_46859_(aoePos.m_7494_().m_7494_()) || level.m_8055_(aoePos.m_7494_().m_7494_()).m_204336_(BlockTags.f_278394_);
            if (!level.m_46859_(aoePos.m_7494_()) && canRemoveAbove && up2OK) {
                if (!level.f_46443_ && canDropAbove) {
                    level.m_7967_((Entity)new ItemEntity(level, player.m_20185_(), player.m_20186_(), player.m_20189_(), new ItemStack((ItemLike)Blocks.f_50493_)));
                }
                level.m_7471_(aoePos.m_7494_(), false);
            }
            this.attemptTillOp(ModularHoe.updateContext(context, aoePos));
        }
        Set drops = BlockToStackHelper.collectAndEndCapture();
        if (!level.f_46443_) {
            for (ItemStack drop : drops) {
                ItemUtils.dropItem((ItemStack)drop, (Level)level, (Vector3)Vector3.fromEntityCenter((Entity)player));
            }
        }
        return InteractionResult.SUCCESS;
    }

    public boolean attemptTillOp(UseOnContext context) {
        Pair pair;
        BlockPos blockpos;
        Level level = context.m_43725_();
        BlockState toolModifiedState = level.m_8055_(blockpos = context.m_8083_()).getToolModifiedState(context, ToolActions.HOE_TILL, false);
        Pair pair2 = pair = toolModifiedState == null ? null : Pair.of(ctx -> true, (Object)ModularHoe.m_150858_((BlockState)toolModifiedState));
        if (pair == null) {
            return false;
        }
        Predicate predicate = (Predicate)pair.getFirst();
        Consumer consumer = (Consumer)pair.getSecond();
        if (predicate.test(context)) {
            Player player = context.m_43723_();
            level.m_5594_(player, blockpos, SoundEvents.f_11955_, SoundSource.BLOCKS, 1.0f, 1.0f);
            if (!level.f_46443_) {
                consumer.accept(context);
                if (player != null) {
                    context.m_43722_().m_41622_(1, (LivingEntity)player, p_150845_ -> p_150845_.m_21190_(context.m_43724_()));
                }
            }
            return true;
        }
        return false;
    }

    public boolean consumeItem(Item target, Inventory inventory) {
        for (ItemStack item : inventory.f_35974_) {
            if (item.m_41619_() || !item.m_150930_(target)) continue;
            item.m_41774_(1);
            inventory.m_6596_();
            return true;
        }
        return false;
    }

    private static UseOnContext updateContext(UseOnContext context, BlockPos newPos) {
        BlockPos pos = context.m_8083_();
        Vec3 newLocation = context.m_43720_().m_82520_((double)(newPos.m_123341_() - pos.m_123341_()), (double)(newPos.m_123342_() - pos.m_123342_()), (double)(newPos.m_123343_() - pos.m_123343_()));
        return new UseOnContext(context.m_43725_(), context.m_43723_(), context.m_43724_(), context.m_43722_(), new BlockHitResult(newLocation, context.m_43719_(), newPos, context.m_43721_()));
    }
}

