/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.init;

import com.brandon3055.brandonscore.api.TechLevel;
import com.brandon3055.draconicevolution.api.IDraconicMelee;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageType;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class DEDamage {
    private static Map<ResourceKey<DamageType>, DamageSource> SOURCES = new HashMap<ResourceKey<DamageType>, DamageSource>();
    public static ResourceKey<DamageType> FUSION_EXPLOSION = ResourceKey.m_135785_((ResourceKey)Registries.f_268580_, (ResourceLocation)new ResourceLocation("draconicevolution", "fusion_explosion"));
    public static ResourceKey<DamageType> KILL = DamageTypes.f_286979_;
    public static ResourceKey<DamageType> CRYSTAL_MOVE = ResourceKey.m_135785_((ResourceKey)Registries.f_268580_, (ResourceLocation)new ResourceLocation("draconicevolution", "crystal_move"));
    public static ResourceKey<DamageType> CHAOS_IMPLOSION = ResourceKey.m_135785_((ResourceKey)Registries.f_268580_, (ResourceLocation)new ResourceLocation("draconicevolution", "chaos_implosion"));
    public static ResourceKey<DamageType> GUARDIAN = ResourceKey.m_135785_((ResourceKey)Registries.f_268580_, (ResourceLocation)new ResourceLocation("draconicevolution", "guardian"));
    public static ResourceKey<DamageType> GUARDIAN_PROJECTILE = ResourceKey.m_135785_((ResourceKey)Registries.f_268580_, (ResourceLocation)new ResourceLocation("draconicevolution", "guardian_projectile"));
    public static ResourceKey<DamageType> GUARDIAN_LASER = ResourceKey.m_135785_((ResourceKey)Registries.f_268580_, (ResourceLocation)new ResourceLocation("draconicevolution", "guardian_laser"));
    public static ResourceKey<DamageType> DRACONIUM_ARROW = ResourceKey.m_135785_((ResourceKey)Registries.f_268580_, (ResourceLocation)new ResourceLocation("draconicevolution", "draconium_arrow"));
    public static ResourceKey<DamageType> DRACONIUM_ARROW_SPOOF = ResourceKey.m_135785_((ResourceKey)Registries.f_268580_, (ResourceLocation)new ResourceLocation("draconicevolution", "draconium_arrow_spoof"));
    public static ResourceKey<DamageType> WYVERN_ARROW = ResourceKey.m_135785_((ResourceKey)Registries.f_268580_, (ResourceLocation)new ResourceLocation("draconicevolution", "wyvern_arrow"));
    public static ResourceKey<DamageType> WYVERN_ARROW_SPOOF = ResourceKey.m_135785_((ResourceKey)Registries.f_268580_, (ResourceLocation)new ResourceLocation("draconicevolution", "wyvern_arrow_spoof"));
    public static ResourceKey<DamageType> DRACONIC_ARROW = ResourceKey.m_135785_((ResourceKey)Registries.f_268580_, (ResourceLocation)new ResourceLocation("draconicevolution", "draconic_arrow"));
    public static ResourceKey<DamageType> DRACONIC_ARROW_SPOOF = ResourceKey.m_135785_((ResourceKey)Registries.f_268580_, (ResourceLocation)new ResourceLocation("draconicevolution", "draconic_arrow_spoof"));
    public static ResourceKey<DamageType> CHAOTIC_ARROW = ResourceKey.m_135785_((ResourceKey)Registries.f_268580_, (ResourceLocation)new ResourceLocation("draconicevolution", "chaotic_arrow"));
    public static ResourceKey<DamageType> CHAOTIC_ARROW_SPOOF = ResourceKey.m_135785_((ResourceKey)Registries.f_268580_, (ResourceLocation)new ResourceLocation("draconicevolution", "chaotic_arrow_spoof"));

    public static DamageSource fusionDamage(Level level) {
        return DEDamage.getSource(level, FUSION_EXPLOSION);
    }

    public static DamageSource killDamage(Level level) {
        return DEDamage.getSource(level, (ResourceKey<DamageType>)DamageTypes.f_286979_);
    }

    public static DamageSource crystalMove(Level level) {
        return DEDamage.getSource(level, CRYSTAL_MOVE);
    }

    public static DamageSource chaosImplosion(Level level) {
        return DEDamage.getSource(level, CHAOS_IMPLOSION);
    }

    public static DamageSource guardianProjectile(Level level, @Nullable Entity projectile, @Nullable Entity owner) {
        return DEDamage.getSource(level, GUARDIAN_PROJECTILE, projectile, owner);
    }

    public static DamageSource guardianLaser(Level level, @Nullable Entity attacker) {
        return DEDamage.getSource(level, GUARDIAN_LASER, attacker);
    }

    public static DamageSource guardian(Level level, @Nullable Entity attacker) {
        return DEDamage.getSource(level, GUARDIAN, attacker);
    }

    public static DamageSource draconicArrow(Level level, @Nullable Entity projectile, @Nullable Entity owner, TechLevel techLevel, boolean bypassImmune) {
        ResourceKey<DamageType> key = switch (techLevel) {
            default -> throw new IncompatibleClassChangeError();
            case TechLevel.DRACONIUM -> {
                if (bypassImmune) {
                    yield DRACONIUM_ARROW_SPOOF;
                }
                yield DRACONIUM_ARROW;
            }
            case TechLevel.WYVERN -> {
                if (bypassImmune) {
                    yield WYVERN_ARROW_SPOOF;
                }
                yield WYVERN_ARROW;
            }
            case TechLevel.DRACONIC -> {
                if (bypassImmune) {
                    yield DRACONIC_ARROW_SPOOF;
                }
                yield DRACONIC_ARROW;
            }
            case TechLevel.CHAOTIC -> bypassImmune ? CHAOTIC_ARROW_SPOOF : CHAOTIC_ARROW;
        };
        return DEDamage.getSource(level, key, bypassImmune ? null : projectile, owner);
    }

    private static DamageSource getSource(Level level, ResourceKey<DamageType> type, @Nullable Entity attacker) {
        return new DamageSource((Holder)level.m_9598_().m_175515_(Registries.f_268580_).m_246971_(type), attacker);
    }

    private static DamageSource getSource(Level level, ResourceKey<DamageType> type, @Nullable Entity projectile, @Nullable Entity owner) {
        return new DamageSource((Holder)level.m_9598_().m_175515_(Registries.f_268580_).m_246971_(type), projectile, owner);
    }

    private static DamageSource getSource(Level level, ResourceKey<DamageType> type) {
        return SOURCES.computeIfAbsent(type, e -> new DamageSource((Holder)level.m_9598_().m_175515_(Registries.f_268580_).m_246971_(e)));
    }

    @Nullable
    public static TechLevel getDamageLevel(DamageSource source) {
        Player player;
        ItemStack stack;
        Item item;
        if (source.m_269533_(Tags.CHAOTIC)) {
            return TechLevel.CHAOTIC;
        }
        if (source.m_269533_(Tags.DRACONIC)) {
            return TechLevel.DRACONIC;
        }
        if (source.m_269533_(Tags.WYVERN)) {
            return TechLevel.WYVERN;
        }
        if (source.m_269533_(Tags.DRACONIUM)) {
            return TechLevel.DRACONIUM;
        }
        Entity entity = source.m_7639_();
        if (entity instanceof Player && (item = (stack = (player = (Player)entity).m_21205_()).m_41720_()) instanceof IDraconicMelee) {
            IDraconicMelee melee = (IDraconicMelee)item;
            return melee.getTechLevel();
        }
        return null;
    }

    public static class Tags {
        public static final TagKey<DamageType> CHAOTIC = TagKey.m_203882_((ResourceKey)Registries.f_268580_, (ResourceLocation)new ResourceLocation("draconicevolution", "chaotic"));
        public static final TagKey<DamageType> DRACONIC = TagKey.m_203882_((ResourceKey)Registries.f_268580_, (ResourceLocation)new ResourceLocation("draconicevolution", "draconic"));
        public static final TagKey<DamageType> WYVERN = TagKey.m_203882_((ResourceKey)Registries.f_268580_, (ResourceLocation)new ResourceLocation("draconicevolution", "wyvern"));
        public static final TagKey<DamageType> DRACONIUM = TagKey.m_203882_((ResourceKey)Registries.f_268580_, (ResourceLocation)new ResourceLocation("draconicevolution", "draconium"));
        public static final TagKey<DamageType> PROJECTILE_ANTI_DODGE = TagKey.m_203882_((ResourceKey)Registries.f_268580_, (ResourceLocation)new ResourceLocation("draconicevolution", "proj_anti_dodge"));
    }
}

