/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.client.render.item;

import codechicken.lib.model.PerspectiveModelState;
import codechicken.lib.render.CCModel;
import codechicken.lib.render.CCRenderState;
import codechicken.lib.render.item.IItemRenderer;
import codechicken.lib.render.model.OBJParser;
import codechicken.lib.render.pipeline.IVertexOperation;
import codechicken.lib.util.TransformUtils;
import codechicken.lib.vec.Matrix4;
import codechicken.lib.vec.Scale;
import codechicken.lib.vec.Vector3;
import com.brandon3055.brandonscore.client.shader.BCShaders;
import com.brandon3055.brandonscore.client.shader.ChaosEntityShader;
import com.brandon3055.draconicevolution.init.DEContent;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.util.Map;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderStateShard;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;

public class RenderItemChaosShard
implements IItemRenderer {
    private static final RenderType CHAOS_CRYSTAL_INNER = RenderType.m_173209_((String)"draconicevolution:chaos_crystal_inner", (VertexFormat)DefaultVertexFormat.f_85812_, (VertexFormat.Mode)VertexFormat.Mode.TRIANGLES, (int)256, (RenderType.CompositeState)RenderType.CompositeState.m_110628_().m_173292_(new RenderStateShard.ShaderStateShard(() -> ((ChaosEntityShader)BCShaders.CHAOS_ENTITY_SHADER).getShaderInstance())).m_173290_((RenderStateShard.EmptyTextureStateShard)new RenderStateShard.TextureStateShard(new ResourceLocation("draconicevolution", "textures/item/equipment/chaos_shader.png"), true, false)).m_110685_(RenderStateShard.f_110139_).m_110661_(RenderStateShard.f_110110_).m_110671_(RenderStateShard.f_110152_).m_110677_(RenderStateShard.f_110154_).m_110691_(false));
    private static final RenderType CHAOS_CRYSTAL = RenderType.m_173209_((String)"draconicevolution:chaos_crystal", (VertexFormat)DefaultVertexFormat.f_85812_, (VertexFormat.Mode)VertexFormat.Mode.TRIANGLES, (int)256, (RenderType.CompositeState)RenderType.CompositeState.m_110628_().m_173292_(new RenderStateShard.ShaderStateShard(GameRenderer::m_172646_)).m_173290_((RenderStateShard.EmptyTextureStateShard)new RenderStateShard.TextureStateShard(new ResourceLocation("draconicevolution", "textures/block/chaos_crystal.png"), false, false)).m_110685_(RenderStateShard.f_110139_).m_110671_(RenderStateShard.f_110152_).m_110677_(RenderStateShard.f_110154_).m_110691_(false));
    private final CCModel shard;
    private final Item item;

    public RenderItemChaosShard(Item item) {
        this.item = item;
        Map map = new OBJParser(new ResourceLocation("draconicevolution", "models/item/chaos_shard.obj")).ignoreMtl().parse();
        this.shard = CCModel.combine(map.values()).backfacedCopy().computeNormals();
    }

    public void renderItem(ItemStack stack, ItemDisplayContext context, PoseStack mStack, MultiBufferSource getter, int packedLight, int packedOverlay) {
        Matrix4 mat = new Matrix4(mStack);
        CCRenderState ccrs = CCRenderState.instance();
        ccrs.reset();
        ccrs.brightness = packedLight;
        ccrs.overlay = packedOverlay;
        mat.apply(new Scale(this.item == DEContent.CHAOS_SHARD.get() ? 1.0 : (this.item == DEContent.CHAOS_FRAG_LARGE.get() ? 0.75 : (this.item == DEContent.CHAOS_FRAG_MEDIUM.get() ? 0.5 : 0.25))).at(new Vector3(0.5, 0.5, 0.5)));
        BCShaders.CHAOS_ENTITY_SHADER.getModelMatUniform().glUniformMatrix4f(new Matrix4());
        BCShaders.CHAOS_ENTITY_SHADER.getSimpleLightUniform().glUniform1b(true);
        BCShaders.CHAOS_ENTITY_SHADER.getDisableLightUniform().glUniform1b(false);
        BCShaders.CHAOS_ENTITY_SHADER.getDisableOverlayUniform().glUniform1b(false);
        ccrs.bind(CHAOS_CRYSTAL_INNER, getter);
        this.shard.render(ccrs, new IVertexOperation[]{mat});
        ccrs.baseColour = -16;
        ccrs.bind(CHAOS_CRYSTAL, getter);
        this.shard.render(ccrs, new IVertexOperation[]{mat});
    }

    @Nullable
    public PerspectiveModelState getModelState() {
        return TransformUtils.DEFAULT_ITEM;
    }

    public boolean m_7541_() {
        return false;
    }

    public boolean m_7539_() {
        return false;
    }

    public boolean m_7547_() {
        return false;
    }
}

