/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.client.render;

import codechicken.lib.util.ArrayUtils;
import codechicken.lib.vec.Quat;
import codechicken.lib.vec.Rotation;
import codechicken.lib.vec.Transformation;
import codechicken.lib.vec.Vector3;
import com.brandon3055.brandonscore.utils.MathUtils;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import java.util.Random;
import net.minecraft.client.Camera;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.util.Mth;
import org.joml.Matrix4f;

public class EffectLib {
    private static final Vector3[] vectors = (Vector3[])ArrayUtils.fill((Object[])new Vector3[8], (Object)new Vector3());

    public static void renderLightningP2P(PoseStack mStack, MultiBufferSource getter, Vector3 startPos, Vector3 endPos, int segCount, long randSeed, float scaleMod, float deflectMod, boolean autoScale, float segTaper, int colour) {
        double height = endPos.y - startPos.y;
        float relScale = autoScale ? (float)height / 128.0f : 1.0f;
        float segHeight = (float)height / (float)segCount;
        float[] segXOffset = new float[segCount + 1];
        float[] segZOffset = new float[segCount + 1];
        float xOffSum = 0.0f;
        float zOffSum = 0.0f;
        Random random = new Random(randSeed);
        for (int segment = 0; segment < segCount + 1; ++segment) {
            segXOffset[segment] = xOffSum + (float)startPos.x;
            segZOffset[segment] = zOffSum + (float)startPos.z;
            if (segment >= segCount) continue;
            xOffSum += (5.0f - random.nextFloat() * 10.0f) * relScale * deflectMod;
            zOffSum += (5.0f - random.nextFloat() * 10.0f) * relScale * deflectMod;
        }
        xOffSum -= (float)(endPos.x - startPos.x);
        zOffSum -= (float)(endPos.z - startPos.z);
        VertexConsumer builder = getter.m_6299_(RenderType.m_110502_());
        Matrix4f matrix4f = mStack.m_85850_().m_252922_();
        for (int layer = 0; layer < 4; ++layer) {
            float red = (float)(colour >> 16 & 0xFF) / 255.0f;
            float green = (float)(colour >> 8 & 0xFF) / 255.0f;
            float blue = (float)(colour & 0xFF) / 255.0f;
            float alpha = 0.3f;
            if (layer == 0) {
                alpha = 1.0f;
                blue = 1.0f;
                green = 1.0f;
                red = 1.0f;
            }
            for (int seg = 0; seg < segCount; ++seg) {
                float pos = (float)seg / (float)segCount;
                float x = segXOffset[seg] - xOffSum * pos;
                float z = segZOffset[seg] - zOffSum * pos;
                float nextPos = (float)(seg + 1) / (float)segCount;
                float nextX = segXOffset[seg + 1] - xOffSum * nextPos;
                float nextZ = segZOffset[seg + 1] - zOffSum * nextPos;
                float layerOffsetA = (0.1f + (float)layer * 0.2f * (1.0f + segTaper)) * relScale * scaleMod;
                float layerOffsetB = (0.1f + (float)layer * 0.2f * (1.0f - segTaper)) * relScale * scaleMod;
                EffectLib.addSegmentQuad(matrix4f, builder, x, (float)startPos.y, z, seg, nextX, nextZ, red, green, blue, alpha, layerOffsetA, layerOffsetB, false, false, true, false, segHeight);
                EffectLib.addSegmentQuad(matrix4f, builder, x, (float)startPos.y, z, seg, nextX, nextZ, red, green, blue, alpha, layerOffsetA, layerOffsetB, true, false, true, true, segHeight);
                EffectLib.addSegmentQuad(matrix4f, builder, x, (float)startPos.y, z, seg, nextX, nextZ, red, green, blue, alpha, layerOffsetA, layerOffsetB, true, true, false, true, segHeight);
                EffectLib.addSegmentQuad(matrix4f, builder, x, (float)startPos.y, z, seg, nextX, nextZ, red, green, blue, alpha, layerOffsetA, layerOffsetB, false, true, false, false, segHeight);
            }
        }
    }

    public static void renderLightningP2PRotate(PoseStack mStack, MultiBufferSource getter, Vector3 startPos, Vector3 endPos, int segCount, long randSeed, float scaleMod, float deflectMod, boolean autoScale, float segTaper, int colour) {
        mStack.m_85836_();
        double length = MathUtils.distance((Vector3)startPos, (Vector3)endPos);
        Vector3 virtualEndPos = startPos.copy().add(0.0, length, 0.0);
        Vector3 dirVec = endPos.copy();
        dirVec.subtract(startPos);
        dirVec.normalize();
        double dirVecXZDist = Math.sqrt(dirVec.x * dirVec.x + dirVec.z * dirVec.z);
        float yRot = (float)(Mth.m_14136_((double)dirVec.x, (double)dirVec.z) * 57.2957763671875);
        float xRot = (float)(Mth.m_14136_((double)dirVec.y, (double)dirVecXZDist) * 57.2957763671875);
        mStack.m_85837_(startPos.x, startPos.y, startPos.z);
        mStack.m_252781_(Axis.f_252436_.m_252977_(yRot - 90.0f));
        mStack.m_252781_(Axis.f_252403_.m_252977_(xRot - 90.0f));
        mStack.m_85837_(-startPos.x, -startPos.y, -startPos.z);
        EffectLib.renderLightningP2P(mStack, getter, startPos, virtualEndPos, segCount, randSeed, scaleMod, deflectMod, autoScale, segTaper, colour);
        mStack.m_85849_();
    }

    private static void addSegmentQuad(Matrix4f matrix4f, VertexConsumer builder, float x1, float yOffset, float z1, int segIndex, float x2, float z2, float red, float green, float blue, float alpha, float offsetA, float offsetB, boolean invA, boolean invB, boolean invC, boolean invD, float segHeight) {
        builder.m_252986_(matrix4f, x1 + (invA ? offsetB : -offsetB), yOffset + (float)segIndex * segHeight, z1 + (invB ? offsetB : -offsetB)).m_85950_(red, green, blue, alpha).m_5752_();
        builder.m_252986_(matrix4f, x2 + (invA ? offsetA : -offsetA), yOffset + ((float)segIndex + 1.0f) * segHeight, z2 + (invB ? offsetA : -offsetA)).m_85950_(red, green, blue, alpha).m_5752_();
        builder.m_252986_(matrix4f, x2 + (invC ? offsetA : -offsetA), yOffset + ((float)segIndex + 1.0f) * segHeight, z2 + (invD ? offsetA : -offsetA)).m_85950_(red, green, blue, alpha).m_5752_();
        builder.m_252986_(matrix4f, x1 + (invC ? offsetB : -offsetB), yOffset + (float)segIndex * segHeight, z1 + (invD ? offsetB : -offsetB)).m_85950_(red, green, blue, alpha).m_5752_();
    }

    public static void drawParticle(Camera renderInfo, VertexConsumer builder, TextureAtlasSprite sprite, float x, float y, float z, float scale, int light) {
        Rotation rot = new Rotation(new Quat(renderInfo.m_253121_()));
        vectors[0].set(-1.0, -1.0, 0.0).apply((Transformation)rot).multiply((double)scale).add((double)x, (double)y, (double)z);
        vectors[1].set(-1.0, 1.0, 0.0).apply((Transformation)rot).multiply((double)scale).add((double)x, (double)y, (double)z);
        vectors[2].set(1.0, 1.0, 0.0).apply((Transformation)rot).multiply((double)scale).add((double)x, (double)y, (double)z);
        vectors[3].set(1.0, -1.0, 0.0).apply((Transformation)rot).multiply((double)scale).add((double)x, (double)y, (double)z);
        float uMin = sprite.m_118409_();
        float uMax = sprite.m_118410_();
        float vMin = sprite.m_118411_();
        float vMax = sprite.m_118412_();
        builder.m_5483_(EffectLib.vectors[0].x, EffectLib.vectors[0].y, EffectLib.vectors[0].z).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_7421_(uMax, vMax).m_85969_(light).m_5752_();
        builder.m_5483_(EffectLib.vectors[1].x, EffectLib.vectors[1].y, EffectLib.vectors[1].z).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_7421_(uMax, vMin).m_85969_(light).m_5752_();
        builder.m_5483_(EffectLib.vectors[2].x, EffectLib.vectors[2].y, EffectLib.vectors[2].z).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_7421_(uMin, vMin).m_85969_(light).m_5752_();
        builder.m_5483_(EffectLib.vectors[3].x, EffectLib.vectors[3].y, EffectLib.vectors[3].z).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_7421_(uMin, vMax).m_85969_(light).m_5752_();
    }

    public static void drawParticle(Rotation rotation, VertexConsumer builder, TextureAtlasSprite sprite, float r, float g, float b, double x, double y, double z, float scale, int light) {
        vectors[0].set(-1.0, -1.0, 0.0).apply((Transformation)rotation).multiply((double)scale).add(x, y, z);
        vectors[1].set(-1.0, 1.0, 0.0).apply((Transformation)rotation).multiply((double)scale).add(x, y, z);
        vectors[2].set(1.0, 1.0, 0.0).apply((Transformation)rotation).multiply((double)scale).add(x, y, z);
        vectors[3].set(1.0, -1.0, 0.0).apply((Transformation)rotation).multiply((double)scale).add(x, y, z);
        float uMin = sprite.m_118409_();
        float uMax = sprite.m_118410_();
        float vMin = sprite.m_118411_();
        float vMax = sprite.m_118412_();
        builder.m_5483_(EffectLib.vectors[0].x, EffectLib.vectors[0].y, EffectLib.vectors[0].z).m_85950_(r, g, b, 1.0f).m_7421_(uMax, vMax).m_85969_(light).m_5752_();
        builder.m_5483_(EffectLib.vectors[1].x, EffectLib.vectors[1].y, EffectLib.vectors[1].z).m_85950_(r, g, b, 1.0f).m_7421_(uMax, vMin).m_85969_(light).m_5752_();
        builder.m_5483_(EffectLib.vectors[2].x, EffectLib.vectors[2].y, EffectLib.vectors[2].z).m_85950_(r, g, b, 1.0f).m_7421_(uMin, vMin).m_85969_(light).m_5752_();
        builder.m_5483_(EffectLib.vectors[3].x, EffectLib.vectors[3].y, EffectLib.vectors[3].z).m_85950_(r, g, b, 1.0f).m_7421_(uMin, vMax).m_85969_(light).m_5752_();
    }
}

