/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.blocks.tileentity.flowgate;

import com.brandon3055.draconicevolution.blocks.tileentity.flowgate.TileFlowGate;
import com.brandon3055.draconicevolution.init.DEContent;
import com.brandon3055.draconicevolution.inventory.FlowGateMenu;
import com.brandon3055.draconicevolution.lib.WTFException;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.network.NetworkHooks;

public class TileFluidGate
extends TileFlowGate {
    private FlowHandler inputHandler = new FlowHandler(this, true);
    private FlowHandler outputHandler = new FlowHandler(this, false);

    public TileFluidGate(BlockPos pos, BlockState state) {
        super((BlockEntityType)DEContent.TILE_FLUID_GATE.get(), pos, state);
    }

    @Override
    public String getUnits() {
        return "MB/t";
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> capability, @Nullable Direction side) {
        if (capability == ForgeCapabilities.FLUID_HANDLER && side != null && side.m_122434_() == this.getDirection().m_122434_()) {
            return side == this.getDirection() ? LazyOptional.of(() -> this.outputHandler) : LazyOptional.of(() -> this.inputHandler);
        }
        return super.getCapability(capability, side);
    }

    public AbstractContainerMenu m_7208_(int id, Inventory inventory, Player player) {
        return new FlowGateMenu(id, player.m_150109_(), this);
    }

    public boolean onBlockActivated(BlockState state, Player player, InteractionHand handIn, BlockHitResult hit) {
        if (player instanceof ServerPlayer) {
            NetworkHooks.openScreen((ServerPlayer)((ServerPlayer)player), (MenuProvider)this, (BlockPos)this.f_58858_);
        }
        return true;
    }

    private class FlowHandler
    implements IFluidHandler {
        private final TileFluidGate gate;
        private final boolean isInput;

        public FlowHandler(TileFluidGate gate, boolean isInput) {
            this.gate = gate;
            this.isInput = isInput;
        }

        public int getTanks() {
            LazyOptional fluidHandler;
            BlockEntity tile;
            if (this.isInput && (tile = TileFluidGate.this.getTarget()) != null && (fluidHandler = tile.getCapability(ForgeCapabilities.FLUID_HANDLER, TileFluidGate.this.getDirection().m_122424_())).isPresent()) {
                return ((IFluidHandler)fluidHandler.orElseThrow(WTFException::new)).getTanks();
            }
            return 1;
        }

        @Nonnull
        public FluidStack getFluidInTank(int tank) {
            LazyOptional fluidHandler;
            BlockEntity tile;
            if (!this.isInput && (tile = TileFluidGate.this.getSource()) != null && (fluidHandler = tile.getCapability(ForgeCapabilities.FLUID_HANDLER, TileFluidGate.this.getDirection().m_122424_())).isPresent()) {
                return ((IFluidHandler)fluidHandler.orElseThrow(WTFException::new)).getFluidInTank(tank);
            }
            return FluidStack.EMPTY;
        }

        public int getTankCapacity(int tank) {
            LazyOptional fluidHandler;
            BlockEntity tile;
            if (this.isInput && (tile = TileFluidGate.this.getTarget()) != null && (fluidHandler = tile.getCapability(ForgeCapabilities.FLUID_HANDLER, TileFluidGate.this.getDirection().m_122424_())).isPresent()) {
                return ((IFluidHandler)fluidHandler.orElseThrow(WTFException::new)).getTankCapacity(tank);
            }
            return 0;
        }

        public boolean isFluidValid(int tank, @Nonnull FluidStack stack) {
            LazyOptional fluidHandler;
            BlockEntity tile;
            if (this.isInput && (tile = TileFluidGate.this.getTarget()) != null && (fluidHandler = tile.getCapability(ForgeCapabilities.FLUID_HANDLER, TileFluidGate.this.getDirection().m_122424_())).isPresent()) {
                return ((IFluidHandler)fluidHandler.orElseThrow(WTFException::new)).isFluidValid(tank, stack);
            }
            return false;
        }

        public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
            LazyOptional fluidHandler;
            BlockEntity tile;
            if (this.isInput && (tile = TileFluidGate.this.getTarget()) != null && (fluidHandler = tile.getCapability(ForgeCapabilities.FLUID_HANDLER, TileFluidGate.this.getDirection().m_122424_())).isPresent()) {
                IFluidHandler handler = (IFluidHandler)fluidHandler.orElseThrow(WTFException::new);
                int transfer = (int)Math.min(TileFluidGate.this.getFlow(), (long)handler.fill(resource, IFluidHandler.FluidAction.SIMULATE));
                if (transfer < resource.getAmount()) {
                    FluidStack newStack = resource.copy();
                    newStack.setAmount(transfer);
                    return handler.fill(newStack, action);
                }
                return handler.fill(resource, action);
            }
            return 0;
        }

        @Nonnull
        public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction action) {
            if (!this.isInput) {
                LazyOptional fluidHandler;
                BlockEntity tile;
                if ((long)resource.getAmount() > TileFluidGate.this.getFlow()) {
                    resource.setAmount((int)TileFluidGate.this.getFlow());
                }
                if ((tile = TileFluidGate.this.getSource()) != null && (fluidHandler = tile.getCapability(ForgeCapabilities.FLUID_HANDLER, TileFluidGate.this.getDirection().m_122424_())).isPresent()) {
                    return ((IFluidHandler)fluidHandler.orElseThrow(WTFException::new)).drain(resource, action);
                }
            }
            return FluidStack.EMPTY;
        }

        @Nonnull
        public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
            BlockEntity tile;
            if (!this.isInput && (tile = TileFluidGate.this.getSource()) != null) {
                LazyOptional fluidHandler;
                if ((long)maxDrain > TileFluidGate.this.getFlow()) {
                    maxDrain = (int)TileFluidGate.this.getFlow();
                }
                if ((fluidHandler = tile.getCapability(ForgeCapabilities.FLUID_HANDLER, TileFluidGate.this.getDirection().m_122424_())).isPresent()) {
                    return ((IFluidHandler)fluidHandler.orElseThrow(WTFException::new)).drain(maxDrain, action);
                }
            }
            return FluidStack.EMPTY;
        }
    }
}

