/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.api.modules.lib;

import com.brandon3055.brandonscore.api.power.IOPStorage;
import com.brandon3055.draconicevolution.api.capability.DECapabilities;
import com.brandon3055.draconicevolution.api.modules.lib.ModuleContext;
import com.brandon3055.draconicevolution.items.equipment.IModularItem;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.util.LazyOptional;
import org.jetbrains.annotations.Nullable;

public class LimitedModuleContext
extends ModuleContext {
    private final ItemStack stack;
    private final LivingEntity entity;
    private final Level level;
    private final EquipmentSlot slot;
    private boolean inEquipModSlot = false;

    public LimitedModuleContext(ItemStack stack, LivingEntity entity, Level level, EquipmentSlot slot) {
        this.stack = stack;
        this.entity = entity;
        this.level = level;
        this.slot = slot;
    }

    public LimitedModuleContext setInEquipModSlot(boolean inEquipModSlot) {
        this.inEquipModSlot = inEquipModSlot;
        return this;
    }

    @Override
    @Nullable
    public IOPStorage getOpStorage() {
        LazyOptional optional = this.stack.getCapability(DECapabilities.OP_STORAGE);
        if (optional.isPresent()) {
            return (IOPStorage)optional.orElseThrow(IllegalStateException::new);
        }
        return null;
    }

    @Override
    public ModuleContext.Type getType() {
        return ModuleContext.Type.LIMITED;
    }

    @Nullable
    public ItemStack getStack() {
        return this.stack;
    }

    @Nullable
    public Level getLevel() {
        return this.level;
    }

    public IModularItem getItem() {
        return (IModularItem)this.stack.m_41720_();
    }

    @Nullable
    public LivingEntity getEntity() {
        return this.entity;
    }

    @Nullable
    public EquipmentSlot getSlot() {
        return this.slot;
    }

    public boolean isEquipped() {
        return this.getItem().isEquipped(this.getStack(), this.getSlot(), this.inEquipModSlot);
    }
}

