/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.nbt.path.navigate;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import org.cyclops.cyclopscore.nbt.path.navigate.INbtPathNavigation;

public class NbtPathNavigationList
implements INbtPathNavigation {
    private final List<INbtPathNavigation> navigations;

    public NbtPathNavigationList(List<INbtPathNavigation> navigations) {
        this.navigations = navigations;
    }

    @Override
    public boolean isLeafKey(String key) {
        for (INbtPathNavigation navigation : this.navigations) {
            if (!navigation.isLeafKey(key)) continue;
            return true;
        }
        return false;
    }

    @Override
    @Nullable
    public INbtPathNavigation getNext(String key) {
        ArrayList subNavigations = Lists.newArrayList();
        for (INbtPathNavigation navigation : this.navigations) {
            INbtPathNavigation subNavigation = navigation.getNext(key);
            if (subNavigation == null) continue;
            subNavigations.add(subNavigation);
        }
        if (subNavigations.isEmpty()) {
            return null;
        }
        return new NbtPathNavigationList(subNavigations);
    }
}

