/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.commoncapabilities.modcompat.vanilla.capability.energystorage;

import net.minecraft.core.Direction;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.energy.IEnergyStorage;
import org.cyclops.commoncapabilities.modcompat.vanilla.capability.VanillaEntityItemCapabilityDelegator;

public class VanillaEntityItemEnergyStorage
extends VanillaEntityItemCapabilityDelegator<IEnergyStorage>
implements IEnergyStorage {
    public VanillaEntityItemEnergyStorage(ItemEntity entity, Direction side) {
        super(entity, side);
    }

    @Override
    protected Capability<IEnergyStorage> getCapabilityType() {
        return ForgeCapabilities.ENERGY;
    }

    public int receiveEnergy(int maxReceive, boolean simulate) {
        ItemStack itemStack = this.getItemStack();
        return this.getCapability(itemStack).map(energyStorage -> {
            int ret = energyStorage.receiveEnergy(maxReceive, simulate);
            if (!simulate && ret > 0) {
                this.updateItemStack(itemStack);
            }
            return ret;
        }).orElse(0);
    }

    public int extractEnergy(int maxExtract, boolean simulate) {
        ItemStack itemStack = this.getItemStack();
        return this.getCapability(itemStack).map(energyStorage -> {
            int ret = energyStorage.extractEnergy(maxExtract, simulate);
            if (!simulate && ret > 0) {
                this.updateItemStack(itemStack);
            }
            return ret;
        }).orElse(0);
    }

    public int getEnergyStored() {
        return this.getCapability().map(IEnergyStorage::getEnergyStored).orElse(0);
    }

    public int getMaxEnergyStored() {
        return this.getCapability().map(IEnergyStorage::getMaxEnergyStored).orElse(0);
    }

    public boolean canExtract() {
        return this.getCapability().map(IEnergyStorage::canExtract).orElse(false);
    }

    public boolean canReceive() {
        return this.getCapability().map(IEnergyStorage::canReceive).orElse(false);
    }
}

