/*
 * Decompiled with CFR 0.152.
 */
package codechicken.lib.gui.modular.lib.geometry;

import codechicken.lib.gui.modular.lib.geometry.Axis;

public enum Direction {
    UP(Axis.Y),
    LEFT(Axis.X),
    DOWN(Axis.Y),
    RIGHT(Axis.X);

    private static Direction[] VALUES;
    private final Axis axis;

    private Direction(Axis axis) {
        this.axis = axis;
    }

    public Axis getAxis() {
        return this.axis;
    }

    public Direction opposite() {
        if (this.axis == Axis.X) {
            return this == LEFT ? RIGHT : LEFT;
        }
        return this == UP ? DOWN : UP;
    }

    public Direction rotateCW() {
        return Direction.values()[(this.ordinal() + VALUES.length - 1) % VALUES.length];
    }

    public Direction rotateCCW() {
        return Direction.values()[(this.ordinal() + 1) % VALUES.length];
    }

    public double rotationTo(Direction other) {
        return (this.ordinal() - other.ordinal()) * 90;
    }

    static {
        VALUES = Direction.values();
    }
}

