/*
 * Decompiled with CFR 0.152.
 */
package codechicken.multipart.network;

import codechicken.lib.data.MCDataInput;
import codechicken.lib.packet.ICustomPacketHandler;
import codechicken.lib.packet.PacketCustom;
import codechicken.multipart.api.part.MultiPart;
import codechicken.multipart.block.TileMultipart;
import codechicken.multipart.init.MultiPartRegistries;
import codechicken.multipart.util.MultipartHelper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientPacketListener;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;

public class MultiPartCPH
implements ICustomPacketHandler.IClientPacketHandler {
    public void handlePacket(PacketCustom packet, Minecraft mc, ClientPacketListener handler) {
        switch (packet.getType()) {
            case 1: {
                MultiPartCPH.handleTileDescPacket((MCDataInput)packet, mc);
                break;
            }
            case 2: {
                MultiPartCPH.handleAddPart((MCDataInput)packet, mc);
                break;
            }
            case 3: {
                MultiPartCPH.handleRemPart((MCDataInput)packet, mc);
                break;
            }
            case 4: {
                MultiPartCPH.handleUpdatePacket((MCDataInput)packet, mc);
                break;
            }
            case 10: {
                this.handleLandingEffects(packet, mc);
            }
        }
    }

    public static void handleTileDescPacket(MCDataInput packet, Minecraft mc) {
        int num = packet.readVarInt();
        for (int i = 0; i < num; ++i) {
            BlockPos pos = packet.readPos();
            TileMultipart.handleDescPacket((Level)mc.f_91073_, pos, packet);
        }
    }

    public static void handleAddPart(MCDataInput packet, Minecraft mc) {
        BlockPos pos = packet.readPos();
        MultipartHelper.addPart((Level)mc.f_91073_, pos, MultiPartRegistries.readPart(packet));
    }

    public static void handleRemPart(MCDataInput packet, Minecraft mc) {
        byte partIndex = packet.readByte();
        BlockPos pos = packet.readPos();
        BlockEntity blockEntity = mc.f_91073_.m_7702_(pos);
        if (blockEntity instanceof TileMultipart) {
            TileMultipart tile = (TileMultipart)blockEntity;
            tile.remPart_impl(tile.getPartList().get(partIndex));
        }
    }

    public static void handleUpdatePacket(MCDataInput packet, Minecraft mc) {
        TileMultipart tile;
        MultiPart part;
        byte partIndex = packet.readByte();
        BlockPos pos = packet.readPos();
        BlockEntity blockEntity = mc.f_91073_.m_7702_(pos);
        if (blockEntity instanceof TileMultipart && (part = (tile = (TileMultipart)blockEntity).getPartList().get(partIndex)) != null) {
            part.readUpdate(packet);
        }
    }

    private void handleLandingEffects(PacketCustom packet, Minecraft mc) {
        BlockPos pos = packet.readPos();
        BlockEntity blockEntity = mc.f_91073_.m_7702_(pos);
        if (blockEntity instanceof TileMultipart) {
            TileMultipart tile = (TileMultipart)blockEntity;
            tile.addLandingEffects(packet.readVector(), packet.readVarInt());
        }
    }
}

