/*
 * Decompiled with CFR 0.152.
 */
package codechicken.multipart.api.part;

import codechicken.lib.capability.CapabilityCache;
import codechicken.lib.data.MCDataInput;
import codechicken.lib.data.MCDataOutput;
import codechicken.lib.vec.Cuboid6;
import codechicken.lib.vec.Vector3;
import codechicken.multipart.api.MultipartType;
import codechicken.multipart.block.TileMultipart;
import codechicken.multipart.network.MultiPartSPH;
import codechicken.multipart.util.PartRayTraceResult;
import codechicken.multipart.util.TickScheduler;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.client.particle.ParticleEngine;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Nullable;

public interface MultiPart {
    @Contract(pure=true)
    public TileMultipart tile();

    public boolean hasTile();

    @Contract(pure=true)
    default public Level level() {
        if (!1.$assertionsDisabled && this.tile().m_58904_() == null) {
            throw new AssertionError();
        }
        return this.tile().m_58904_();
    }

    default public boolean hasLevel() {
        return this.tile().m_58898_();
    }

    @Contract(pure=true)
    default public BlockPos pos() {
        return this.tile().m_58899_();
    }

    @Contract(pure=true)
    default public CapabilityCache capCache() {
        return this.tile().getCapCache();
    }

    @Contract(pure=true)
    public MultipartType<?> getType();

    default public void writeDesc(MCDataOutput packet) {
    }

    default public void readDesc(MCDataInput packet) {
    }

    default public void save(CompoundTag tag) {
    }

    default public void load(CompoundTag tag) {
    }

    default public void sendUpdate(Consumer<MCDataOutput> func) {
        MultiPartSPH.dispatchPartUpdate(this, func);
    }

    default public void readUpdate(MCDataInput packet) {
        this.readDesc(packet);
        this.tile().markRender();
    }

    default public boolean occlusionTest(MultiPart npart) {
        return true;
    }

    default public VoxelShape getShape(CollisionContext context) {
        return Shapes.m_83040_();
    }

    default public VoxelShape getCollisionShape(CollisionContext context) {
        return this.getShape(context);
    }

    default public VoxelShape getRenderOcclusionShape() {
        return this.getShape(CollisionContext.m_82749_());
    }

    default public VoxelShape getInteractionShape() {
        return this.getShape(CollisionContext.m_82749_());
    }

    default public VoxelShape getBlockSupportShape() {
        return this.getShape(CollisionContext.m_82749_());
    }

    default public VoxelShape getVisualShape(CollisionContext context) {
        return this.getShape(context);
    }

    default public void harvest(Player player, PartRayTraceResult hit) {
        if (!player.m_150110_().f_35937_) {
            this.tile().dropItems(this.getDrops());
        }
        this.tile().remPart(this);
    }

    default public Iterable<ItemStack> getDrops() {
        return List.of();
    }

    default public ItemStack getCloneStack(PartRayTraceResult hit) {
        return ItemStack.f_41583_;
    }

    default public float getExplosionResistance(Explosion explosion) {
        return 0.0f;
    }

    default public int getLightEmission() {
        return 0;
    }

    default public float getStrength(Player player, PartRayTraceResult hit) {
        return 0.033333335f;
    }

    @Nullable
    default public SoundType getPlacementSound(UseOnContext context) {
        return null;
    }

    default public void onAdded() {
        this.onWorldJoin();
    }

    default public void preRemove() {
    }

    default public void onRemoved() {
        this.onWorldSeparate();
    }

    default public void onChunkLoad(LevelChunk chunk) {
        this.onWorldJoin();
    }

    default public void onChunkUnload() {
    }

    default public void onWorldSeparate() {
    }

    default public void onWorldJoin() {
    }

    default public void onConverted() {
        this.onAdded();
    }

    default public void invalidateConvertedTile() {
    }

    default public void onMoved() {
        this.onWorldJoin();
    }

    default public InteractionResult activate(Player player, PartRayTraceResult hit, ItemStack stack, InteractionHand hand) {
        return InteractionResult.FAIL;
    }

    default public void click(Player player, PartRayTraceResult hit, ItemStack stack) {
    }

    default public void onEntityCollision(Entity entity) {
    }

    default public void onEntityStanding(Entity entity) {
    }

    default public void onNeighborBlockChanged(BlockPos neighbor) {
    }

    default public void onPartChanged(@Nullable MultiPart part) {
    }

    default public void scheduledTick() {
    }

    default public void scheduleTick(int ticks) {
        TickScheduler.scheduleTick(this, ticks);
    }

    @OnlyIn(value=Dist.CLIENT)
    default public void addHitEffects(PartRayTraceResult hit, ParticleEngine engine) {
    }

    @OnlyIn(value=Dist.CLIENT)
    default public void addDestroyEffects(PartRayTraceResult hit, ParticleEngine engine) {
    }

    @OnlyIn(value=Dist.CLIENT)
    default public void addLandingEffects(PartRayTraceResult hit, Vector3 entity, int numberOfParticles) {
    }

    @OnlyIn(value=Dist.CLIENT)
    default public void addRunningEffects(PartRayTraceResult hit, Entity entity) {
    }

    default public Cuboid6 getRenderBounds() {
        return Cuboid6.full;
    }

    static {
        if (1.$assertionsDisabled) {
            // empty if block
        }
    }
}

