/*
 * Decompiled with CFR 0.152.
 */
package codechicken.mixin.util;

import codechicken.mixin.util.Utils;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.net.URL;
import java.util.Collections;
import java.util.HashSet;
import java.util.ServiceConfigurationError;
import java.util.Set;
import java.util.function.Consumer;

public class SimpleServiceLoader<S> {
    private static final String PREFIX = "META-INF/services/";
    private final Class<?> serviceClazz;
    private final ClassLoader classLoader;
    private final Set<String> foundClasses = new HashSet<String>();
    private final Set<Class<? extends S>> foundServices = new HashSet<Class<? extends S>>();
    private final Set<Class<? extends S>> newServices = new HashSet<Class<? extends S>>();

    public SimpleServiceLoader(Class<S> serviceClazz) {
        this.serviceClazz = serviceClazz;
        this.classLoader = SimpleServiceLoader.getContextClassLoader();
    }

    public SimpleServiceLoader(Class<S> serviceClazz, ClassLoader classLoader) {
        this.serviceClazz = serviceClazz;
        this.classLoader = classLoader;
    }

    public SimpleServiceLoader<S> poll() {
        this.newServices.clear();
        SimpleServiceLoader.load(this.classLoader, this.serviceClazz, line -> {
            if (!this.foundClasses.contains(line)) {
                this.foundClasses.add((String)line);
                Class<?> clazz = null;
                try {
                    clazz = Class.forName(line, false, this.classLoader);
                }
                catch (ClassNotFoundException e) {
                    SimpleServiceLoader.fail(this.serviceClazz, "Provider " + line + " not found.");
                }
                if (!this.serviceClazz.isAssignableFrom(clazz)) {
                    SimpleServiceLoader.fail(this.serviceClazz, "Provider " + line + " not a subtype");
                }
                this.foundServices.add(clazz);
                this.newServices.add(clazz);
            }
        });
        return this;
    }

    public Set<Class<? extends S>> getAllServices() {
        return Collections.unmodifiableSet(this.foundServices);
    }

    public Set<Class<? extends S>> getNewServices() {
        return Collections.unmodifiableSet(this.newServices);
    }

    public static void load(Class<?> clazz, Consumer<String> cons) {
        SimpleServiceLoader.load(SimpleServiceLoader.getContextClassLoader(), clazz, cons);
    }

    public static void load(ClassLoader cl, Class<?> clazz, Consumer<String> cons) {
        try {
            for (URL url : Utils.toIterable(cl.getResources(PREFIX + clazz.getName()))) {
                try (LineNumberReader reader = new LineNumberReader(new InputStreamReader(url.openStream()));){
                    String line;
                    while ((line = reader.readLine()) != null) {
                        int cp;
                        int n;
                        int lc = reader.getLineNumber();
                        int cIndex = line.indexOf(35);
                        if (cIndex >= 0) {
                            line = line.substring(0, cIndex);
                        }
                        if ((n = (line = line.trim()).length()) == 0) continue;
                        if (line.indexOf(32) >= 0 || line.indexOf(9) >= 0) {
                            SimpleServiceLoader.fail(clazz, url, lc, "Illegal configuration-file syntax");
                        }
                        if (!Character.isJavaIdentifierStart(cp = line.codePointAt(0))) {
                            SimpleServiceLoader.fail(clazz, url, lc, "Illegal provider-class name: " + line);
                        }
                        for (int i = Character.charCount(cp); i < n; i += Character.charCount(cp)) {
                            cp = line.codePointAt(i);
                            if (Character.isJavaIdentifierPart(cp) || cp == 46) continue;
                            SimpleServiceLoader.fail(clazz, url, lc, "Illegal provider-class name: " + line);
                        }
                        cons.accept(line);
                    }
                }
            }
        }
        catch (IOException e) {
            SimpleServiceLoader.fail(clazz, "Error reading configuration file", e);
        }
    }

    private static ClassLoader getContextClassLoader() {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        if (cl == null) {
            cl = SimpleServiceLoader.class.getClassLoader();
        }
        return cl;
    }

    private static void fail(Class<?> service, String msg, Throwable cause) throws ServiceConfigurationError {
        throw new ServiceConfigurationError(service.getName() + ": " + msg, cause);
    }

    private static void fail(Class<?> service, String msg) throws ServiceConfigurationError {
        throw new ServiceConfigurationError(service.getName() + ": " + msg);
    }

    private static void fail(Class<?> service, URL u, int line, String msg) throws ServiceConfigurationError {
        SimpleServiceLoader.fail(service, u + ":" + line + ": " + msg);
    }
}

