/*
 * Decompiled with CFR 0.152.
 */
package codechicken.mixin.util;

import codechicken.mixin.MixinCompilerImpl;
import codechicken.mixin.api.MixinDebugger;
import codechicken.mixin.util.Utils;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import net.covers1624.quack.io.IOUtils;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.util.Printer;
import org.objectweb.asm.util.Textifier;
import org.objectweb.asm.util.TraceClassVisitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleDebugger
implements MixinDebugger {
    private static final Logger LOGGER = LoggerFactory.getLogger(SimpleDebugger.class);
    private final Path folder;
    private final DumpType type;

    public SimpleDebugger(Path folder, DumpType type) {
        this.folder = folder;
        this.type = type;
        try {
            if (Files.exists(folder, new LinkOption[0])) {
                if (!Files.isDirectory(folder, new LinkOption[0])) {
                    LOGGER.warn("Expected '{}' to be a directory. Overwriting..", (Object)folder);
                    Files.delete(folder);
                } else {
                    LOGGER.atLevel(MixinCompilerImpl.LOG_LEVEL).log("Clearing debugger output. '{}'", (Object)folder.toAbsolutePath());
                    Utils.deleteFolder(folder);
                }
            }
            Files.createDirectories(folder, new FileAttribute[0]);
        }
        catch (IOException e) {
            LOGGER.error("Encountered an error setting up SimpleDebugger.", (Throwable)e);
        }
    }

    @Override
    public void defineClass(String name, byte[] bytes) {
        name = name.replace("/", ".");
        try {
            switch (this.type) {
                case TEXT: {
                    try {
                        LOGGER.atLevel(MixinCompilerImpl.LOG_LEVEL).log("Dumping '{}' as text", (Object)name);
                        Path path = this.folder.resolve(name + ".txt");
                        try (BufferedWriter writer = Files.newBufferedWriter(IOUtils.makeParents((Path)path), new OpenOption[0]);){
                            TraceClassVisitor cv = new TraceClassVisitor(null, (Printer)new Textifier(), new PrintWriter(writer));
                            ClassReader reader = new ClassReader(bytes);
                            reader.accept((ClassVisitor)cv, 8);
                            break;
                        }
                    }
                    catch (IOException e) {
                        throw e;
                    }
                    catch (Exception e) {
                        LOGGER.warn("Fatal exception dumping as text. Dumping as binary.", (Throwable)e);
                    }
                }
                case BINARY: {
                    LOGGER.atLevel(MixinCompilerImpl.LOG_LEVEL).log("Dumping '{}' as binary.", (Object)name);
                    Path path = this.folder.resolve(name + ".class");
                    try (OutputStream os = Files.newOutputStream(IOUtils.makeParents((Path)path), new OpenOption[0]);){
                        os.write(bytes);
                        break;
                    }
                }
            }
        }
        catch (IOException e) {
            LOGGER.error("Unable to dump '{}' to disk.", (Object)name, (Object)e);
        }
    }

    public static enum DumpType {
        TEXT,
        BINARY;

    }
}

