/*
 * Decompiled with CFR 0.152.
 */
package codechicken.microblock.part.hollow;

import codechicken.lib.math.MathHelper;
import codechicken.lib.raytracer.VoxelShapeCache;
import codechicken.lib.vec.Cuboid6;
import codechicken.lib.vec.Rotation;
import codechicken.lib.vec.Transformation;
import codechicken.lib.vec.Vector3;
import codechicken.microblock.api.MicroMaterial;
import codechicken.microblock.api.SlottedHollowConnect;
import codechicken.microblock.init.CBMicroblockModContent;
import codechicken.microblock.part.StandardMicroFactory;
import codechicken.microblock.part.StandardMicroblockPart;
import codechicken.microblock.part.face.FaceMicroblockPart;
import codechicken.microblock.util.MaskedCuboid;
import codechicken.multipart.api.part.FacePart;
import codechicken.multipart.api.part.MultiPart;
import codechicken.multipart.api.part.NormalOcclusionPart;
import com.google.common.collect.Iterables;
import it.unimi.dsi.fastutil.ints.Int2ObjectArrayMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMaps;
import java.util.List;
import net.covers1624.quack.collection.FastStream;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class HollowMicroblockPart
extends StandardMicroblockPart
implements FacePart,
NormalOcclusionPart {
    private static final Int2ObjectMap<VoxelShape> OCCLUSION_SHAPE_CACHE = Int2ObjectMaps.synchronize((Int2ObjectMap)new Int2ObjectArrayMap());
    private static final Int2ObjectMap<VoxelShape> COLLISION_SHAPE_CACHE = Int2ObjectMaps.synchronize((Int2ObjectMap)new Int2ObjectArrayMap());
    public static final Cuboid6[][] pBoxes = new Cuboid6[256][4];
    public static final VoxelShape[] pShapes = new VoxelShape[256];
    public static final Cuboid6[] occBounds = new Cuboid6[256];

    public HollowMicroblockPart(MicroMaterial material) {
        super(material);
        this.renderMask |= 0x800;
    }

    public int getHoleSize() {
        MultiPart multiPart;
        if (this.hasTile() && (multiPart = this.tile().getSlottedPart(6)) instanceof SlottedHollowConnect) {
            SlottedHollowConnect part = (SlottedHollowConnect)((Object)multiPart);
            return MathHelper.clip((int)part.getHoleSize(this.getSlot()), (int)1, (int)11);
        }
        return 8;
    }

    @Override
    public StandardMicroFactory getMicroFactory() {
        return (StandardMicroFactory)CBMicroblockModContent.HOLLOW_MICROBLOCK_PART.get();
    }

    @Override
    public Cuboid6 getBounds() {
        return FaceMicroblockPart.aBounds[this.shape];
    }

    @Override
    public VoxelShape getShape(CollisionContext context) {
        return this.getCollisionShape(context);
    }

    @Override
    public VoxelShape getPartialOcclusionShape() {
        return pShapes[this.shape];
    }

    @Override
    public VoxelShape getCollisionShape(CollisionContext context) {
        int holeSize = this.getHoleSize();
        return (VoxelShape)COLLISION_SHAPE_CACHE.computeIfAbsent(holeSize << 8 | this.shape, i -> HollowMicroblockPart.computeCollisionShape(holeSize, this.shape));
    }

    @Override
    public VoxelShape getInteractionShape() {
        return this.getCollisionShape(CollisionContext.m_82749_());
    }

    @Override
    public VoxelShape getOcclusionShape() {
        int holeSize = this.getHoleSize();
        return (VoxelShape)OCCLUSION_SHAPE_CACHE.computeIfAbsent(holeSize << 8 | this.shape, i -> HollowMicroblockPart.computeOcclusionShape(holeSize, this.shape));
    }

    @Override
    public boolean allowCompleteOcclusion() {
        return true;
    }

    @Override
    public boolean occlusionTest(MultiPart nPart) {
        return NormalOcclusionPart.super.occlusionTest(nPart) && super.occlusionTest(nPart);
    }

    @Override
    public int redstoneConductionMap() {
        return 16;
    }

    private static VoxelShape computeOcclusionShape(int holeSize, int shape) {
        int slot = shape & 0xF;
        Cuboid6 c = occBounds[shape];
        double d1 = 0.5 - (double)holeSize / 32.0;
        double d2 = 0.5 + (double)holeSize / 32.0;
        double x1 = c.min.x;
        double x2 = c.max.x;
        double y1 = c.min.y;
        double y2 = c.max.y;
        double z1 = c.min.z;
        double z2 = c.max.z;
        return switch (slot) {
            case 0, 1 -> (VoxelShape)FastStream.of((Object[])new Cuboid6[]{new Cuboid6(d2, y1, d1, x2, y2, d2), new Cuboid6(x1, y1, d1, d1, y2, d2), new Cuboid6(x1, y1, d2, x2, y2, z2), new Cuboid6(x1, y1, z1, x2, y2, d1)}).map(VoxelShapeCache::getShape).fold((Object)Shapes.m_83040_(), Shapes::m_83110_);
            case 2, 3 -> (VoxelShape)FastStream.of((Object[])new Cuboid6[]{new Cuboid6(d1, d2, z1, d2, y2, z2), new Cuboid6(d1, y1, z1, d2, d1, z2), new Cuboid6(d2, y1, z1, x2, y2, z2), new Cuboid6(x1, y1, z1, d1, y2, z2)}).map(VoxelShapeCache::getShape).fold((Object)Shapes.m_83040_(), Shapes::m_83110_);
            case 4, 5 -> (VoxelShape)FastStream.of((Object[])new Cuboid6[]{new Cuboid6(x1, d1, d2, x2, d2, z2), new Cuboid6(x1, d1, z1, x2, d2, d1), new Cuboid6(x1, d2, z1, x2, y2, z2), new Cuboid6(x1, y1, z1, x2, d1, z2)}).map(VoxelShapeCache::getShape).fold((Object)Shapes.m_83040_(), Shapes::m_83110_);
            default -> throw new IllegalStateException("Unexpected value: " + slot);
        };
    }

    private static VoxelShape computeCollisionShape(int holeSize, int shape) {
        double d1 = 0.5 - (double)holeSize / 32.0;
        double d2 = 0.5 + (double)holeSize / 32.0;
        double t = (double)(shape >> 4) / 8.0;
        Transformation tr = Rotation.sideRotations[shape & 0xF].at(Vector3.CENTER);
        return (VoxelShape)FastStream.of((Object[])new Cuboid6[]{new Cuboid6(0.0, 0.0, 0.0, 1.0, t, d1), new Cuboid6(0.0, 0.0, d2, 1.0, t, 1.0), new Cuboid6(0.0, 0.0, d1, d1, t, d2), new Cuboid6(d2, 0.0, d1, 1.0, t, d2)}).map(e -> e.apply(tr)).map(VoxelShapeCache::getShape).fold((Object)Shapes.m_83040_(), Shapes::m_83110_);
    }

    @Override
    public Iterable<MaskedCuboid> getRenderCuboids(boolean isInventory) {
        if (isInventory) {
            return this.buildBoxes(this.getBounds(), 0, false);
        }
        if (this.isTransparent()) {
            return this.buildBoxes(this.renderBounds, this.renderMask, false);
        }
        return Iterables.concat(this.buildBoxes(this.renderBounds, this.renderMask | 1 << this.getSlot(), false), this.buildBoxes(Cuboid6.full, ~(1 << this.getSlot()), true));
    }

    @Override
    public void recalcBounds() {
        super.recalcBounds();
        this.renderMask = this.renderMask & 0xFF | this.getHoleSize() << 8;
    }

    private List<MaskedCuboid> buildBoxes(Cuboid6 c, int sideMask, boolean face) {
        int size = this.renderMask >> 8;
        double d1 = 0.5 - (double)size / 32.0;
        double d2 = 0.5 + (double)size / 32.0;
        double x1 = c.min.x;
        double x2 = c.max.x;
        double y1 = c.min.y;
        double y2 = c.max.y;
        double z1 = c.min.z;
        double z2 = c.max.z;
        int iMask = 0;
        switch (this.getSlot()) {
            case 0: 
            case 1: {
                if (face) {
                    iMask = 60;
                }
                return List.of(new MaskedCuboid(new Cuboid6(d1, y1, d2, d2, y2, z2), 0x3B | iMask), new MaskedCuboid(new Cuboid6(d1, y1, z1, d2, y2, d1), 0x37 | iMask), new MaskedCuboid(new Cuboid6(d2, y1, d1, x2, y2, d2), sideMask & 0x23 | 0xC | iMask), new MaskedCuboid(new Cuboid6(x1, y1, d1, d1, y2, d2), sideMask & 0x13 | 0xC | iMask), new MaskedCuboid(new Cuboid6(x1, y1, d2, x2, y2, z2), sideMask & 0x3B | 4 | iMask), new MaskedCuboid(new Cuboid6(x1, y1, z1, x2, y2, d1), sideMask & 0x37 | 8 | iMask));
            }
            case 2: 
            case 3: {
                if (face) {
                    iMask = 51;
                }
                return List.of(new MaskedCuboid(new Cuboid6(d2, d1, z1, x2, d2, z2), 0x2F | iMask), new MaskedCuboid(new Cuboid6(x1, d1, z1, d1, d2, z2), 0x1F | iMask), new MaskedCuboid(new Cuboid6(d1, d2, z1, d2, y2, z2), sideMask & 0xE | 0x30 | iMask), new MaskedCuboid(new Cuboid6(d1, y1, z1, d2, d1, z2), sideMask & 0xD | 0x30 | iMask), new MaskedCuboid(new Cuboid6(d2, y1, z1, x2, y2, z2), sideMask & 0x2F | 0x10 | iMask), new MaskedCuboid(new Cuboid6(x1, y1, z1, d1, y2, z2), sideMask & 0x1F | 0x20 | iMask));
            }
            case 4: 
            case 5: {
                if (face) {
                    iMask = 15;
                }
                return List.of(new MaskedCuboid(new Cuboid6(x1, d2, d1, x2, y2, d2), 0x3E | iMask), new MaskedCuboid(new Cuboid6(x1, y1, d1, x2, d1, d2), 0x3D | iMask), new MaskedCuboid(new Cuboid6(x1, d1, d2, x2, d2, z2), sideMask & 0x38 | 3 | iMask), new MaskedCuboid(new Cuboid6(x1, d1, z1, x2, d2, d1), sideMask & 0x34 | 3 | iMask), new MaskedCuboid(new Cuboid6(x1, d2, z1, x2, y2, z2), sideMask & 0x3E | 1 | iMask), new MaskedCuboid(new Cuboid6(x1, y1, z1, x2, d1, z2), sideMask & 0x3D | 2 | iMask));
            }
        }
        throw new IllegalStateException("Unexpected value: " + this.getSlot());
    }

    static {
        for (int s = 0; s < 6; ++s) {
            Transformation tr = Rotation.sideRotations[s].at(Vector3.CENTER);
            for (int t = 1; t < 8; ++t) {
                int i = t << 4 | s;
                double d = (double)t / 8.0;
                double w1 = 0.125;
                HollowMicroblockPart.pBoxes[i][0] = new Cuboid6(0.0, 0.0, 0.0, w1, d, 1.0).apply(tr);
                HollowMicroblockPart.pBoxes[i][1] = new Cuboid6(1.0 - w1, 0.0, 0.0, 1.0, d, 1.0).apply(tr);
                HollowMicroblockPart.pBoxes[i][2] = new Cuboid6(w1, 0.0, 0.0, 1.0 - w1, d, w1).apply(tr);
                HollowMicroblockPart.pBoxes[i][3] = new Cuboid6(w1, 0.0, 1.0 - w1, 1.0 - w1, d, 1.0).apply(tr);
                HollowMicroblockPart.occBounds[i] = new Cuboid6(0.125, 0.0, 0.125, 0.875, d, 0.875).apply(tr);
                HollowMicroblockPart.pShapes[i] = (VoxelShape)FastStream.of((Object[])pBoxes[i]).map(VoxelShapeCache::getShape).fold((Object)Shapes.m_83040_(), Shapes::m_83110_);
            }
        }
    }
}

