/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.brandonscore.inventory;

import java.util.HashMap;
import java.util.Map;
import java.util.function.BiPredicate;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.items.ItemStackHandler;

public class TileItemStackHandler
extends ItemStackHandler {
    private final BlockEntity tile;
    private BiPredicate<Integer, ItemStack> stackValidator = null;
    private Runnable loadListener = null;
    private Consumer<Integer> contentsChangeListener = null;
    private Map<Integer, Predicate<ItemStack>> slotValidators = new HashMap<Integer, Predicate<ItemStack>>();
    private ItemStack prevStack = ItemStack.f_41583_;
    private Supplier<Integer> perSlotLimit = null;
    private int slotLimit = 64;

    public TileItemStackHandler(BlockEntity tile) {
        this.tile = tile;
    }

    public TileItemStackHandler(BlockEntity tile, int size) {
        super(size);
        this.tile = tile;
    }

    public TileItemStackHandler(BlockEntity tile, NonNullList<ItemStack> stacks) {
        super(stacks);
        this.tile = tile;
    }

    public TileItemStackHandler setStackValidator(BiPredicate<Integer, ItemStack> stackValidator) {
        this.stackValidator = stackValidator;
        return this;
    }

    public TileItemStackHandler setStackValidator(Predicate<ItemStack> stackValidator) {
        this.stackValidator = (integer, stack) -> stackValidator.test((ItemStack)stack);
        return this;
    }

    public TileItemStackHandler setSlotValidator(int slot, Predicate<ItemStack> validator) {
        this.slotValidators.put(slot, validator);
        return this;
    }

    public TileItemStackHandler setLoadListener(Runnable loadListener) {
        this.loadListener = loadListener;
        return this;
    }

    public TileItemStackHandler setContentsChangeListener(Consumer<Integer> contentsChangeListener) {
        this.contentsChangeListener = contentsChangeListener;
        return this;
    }

    public TileItemStackHandler setPerSlotLimit(Supplier<Integer> perSlotLimit) {
        this.perSlotLimit = perSlotLimit;
        return this;
    }

    public TileItemStackHandler setSlotLimit(int slotLimit) {
        this.slotLimit = slotLimit;
        return this;
    }

    @Nonnull
    public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
        this.prevStack = this.getStackInSlot(slot);
        if (!this.isItemValid(slot, stack)) {
            return stack;
        }
        return super.insertItem(slot, stack, simulate);
    }

    @Nonnull
    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        this.prevStack = this.getStackInSlot(slot);
        return super.extractItem(slot, amount, simulate);
    }

    public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
        if (this.slotValidators.containsKey(slot)) {
            return this.slotValidators.get(slot).test(stack);
        }
        return this.stackValidator == null || this.stackValidator.test(slot, stack);
    }

    public CompoundTag serializeNBT() {
        ListTag nbtTagList = new ListTag();
        for (int i = 0; i < this.stacks.size(); ++i) {
            if (((ItemStack)this.stacks.get(i)).m_41619_()) continue;
            CompoundTag itemTag = new CompoundTag();
            itemTag.m_128405_("Slot", i);
            ((ItemStack)this.stacks.get(i)).m_41739_(itemTag);
            nbtTagList.add((Object)itemTag);
        }
        CompoundTag nbt = new CompoundTag();
        nbt.m_128365_("Items", (Tag)nbtTagList);
        return nbt;
    }

    public void deserializeNBT(CompoundTag nbt) {
        this.stacks.clear();
        ListTag tagList = nbt.m_128437_("Items", 10);
        for (int i = 0; i < tagList.size(); ++i) {
            CompoundTag itemTags = tagList.m_128728_(i);
            int slot = itemTags.m_128451_("Slot");
            if (slot < 0 || slot >= this.stacks.size()) continue;
            this.stacks.set(slot, (Object)ItemStack.m_41712_((CompoundTag)itemTags));
        }
        this.onLoad();
    }

    protected void onContentsChanged(int slot) {
        super.onContentsChanged(slot);
        if (this.contentsChangeListener != null) {
            this.contentsChangeListener.accept(slot);
        }
        this.tile.m_6596_();
    }

    protected void onLoad() {
        super.onLoad();
        if (this.loadListener != null) {
            this.loadListener.run();
        }
    }

    public ItemStack getListenerPrevStack() {
        return this.prevStack;
    }

    public int getSlotLimit(int slot) {
        return this.perSlotLimit == null ? this.slotLimit : this.perSlotLimit.get();
    }
}

