/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.brandonscore.api;

import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.util.thread.EffectiveSide;

public class TimeKeeper {
    private static int serverTick = 0;
    private static int clientTick = 0;

    @SubscribeEvent
    protected void clientTick(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            ++clientTick;
        }
    }

    @SubscribeEvent
    protected void serverTick(TickEvent.ServerTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            ++serverTick;
        }
    }

    public static int getServerTick() {
        return serverTick;
    }

    public static int getClientTick() {
        return clientTick;
    }

    public static int interval(int intervalTicks, int rollover) {
        int tick = EffectiveSide.get().isClient() ? TimeKeeper.getClientTick() : TimeKeeper.getServerTick();
        return tick / intervalTicks % rollover;
    }

    static {
        MinecraftForge.EVENT_BUS.register((Object)new TimeKeeper());
    }
}

