/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.item.equipment.tool.terrasteel;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.PriorityQueue;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import org.jetbrains.annotations.NotNull;
import vazkii.botania.api.BotaniaAPI;
import vazkii.botania.api.item.SequentialBreaker;
import vazkii.botania.common.item.StoneOfTemperanceItem;
import vazkii.botania.common.item.equipment.tool.ToolCommons;
import vazkii.botania.common.item.equipment.tool.manasteel.ManasteelAxeItem;

public class TerraTruncatorItem
extends ManasteelAxeItem
implements SequentialBreaker {
    private static final int BLOCK_SWAP_RATE = 10;
    public static final int BLOCK_RANGE = 32;
    private static final int LEAF_BLOCK_RANGE = 3;
    private static final int MANA_PER_DAMAGE = 100;
    private static final Map<ResourceKey<Level>, Set<BlockSwapper>> blockSwappers = new HashMap<ResourceKey<Level>, Set<BlockSwapper>>();
    private static boolean tickingSwappers = false;

    public TerraTruncatorItem(Item.Properties props) {
        super(BotaniaAPI.instance().getTerrasteelItemTier(), 5.0f, -3.0f, props);
    }

    public static boolean shouldBreak(Player player) {
        return !player.m_6144_() && !StoneOfTemperanceItem.hasTemperanceActive(player);
    }

    public boolean onBlockStartBreak(ItemStack stack, BlockPos pos, Player player) {
        BlockHitResult raycast = ToolCommons.raytraceFromEntity((Entity)player, 10.0, false);
        if (raycast.m_6662_() == HitResult.Type.BLOCK) {
            Direction face = raycast.m_82434_();
            this.breakOtherBlock(player, stack, pos, pos, face);
            if (player.m_36341_()) {
                BotaniaAPI.instance().breakOnAllCursors(player, stack, pos, face);
            }
        }
        return false;
    }

    @Override
    public int getManaPerDamage() {
        return 100;
    }

    @Override
    public void breakOtherBlock(Player player, ItemStack stack, BlockPos pos, BlockPos originPos, Direction side) {
        if (TerraTruncatorItem.shouldBreak(player) && !tickingSwappers) {
            TerraTruncatorItem.addBlockSwapper(player.m_9236_(), player, stack, pos);
        }
    }

    public static void onTickEnd(ServerLevel world) {
        ResourceKey dim = world.m_46472_();
        if (blockSwappers.containsKey(dim)) {
            tickingSwappers = true;
            Set<BlockSwapper> swappers = blockSwappers.get(dim);
            swappers.removeIf(next -> next == null || !next.tick());
            tickingSwappers = false;
        }
    }

    private static void addBlockSwapper(Level world, Player player, ItemStack stack, BlockPos origCoords) {
        if (world.f_46443_) {
            return;
        }
        BlockSwapper swapper = new BlockSwapper(world, player, stack, origCoords, 32);
        ResourceKey dim = world.m_46472_();
        blockSwappers.computeIfAbsent((ResourceKey<Level>)dim, d -> new HashSet()).add(swapper);
    }

    private static class BlockSwapper {
        public static final int SINGLE_BLOCK_RADIUS = 1;
        private final Level world;
        private final Player player;
        private final ItemStack truncator;
        private final PriorityQueue<SwapCandidate> candidateQueue = new PriorityQueue();
        private final Set<BlockPos> completedCoords = new HashSet<BlockPos>();

        public BlockSwapper(Level world, Player player, ItemStack truncator, BlockPos origCoords, int range) {
            this.world = world;
            this.player = player;
            this.truncator = truncator;
            this.candidateQueue.offer(new SwapCandidate(origCoords, range));
        }

        public boolean tick() {
            if (this.candidateQueue.isEmpty()) {
                return false;
            }
            int remainingSwaps = 10;
            while (remainingSwaps > 0 && !this.candidateQueue.isEmpty()) {
                SwapCandidate cand = this.candidateQueue.poll();
                if (this.completedCoords.contains(cand.coordinates) || cand.range <= 0) continue;
                ToolCommons.removeBlockWithDrops(this.player, this.truncator, this.world, cand.coordinates, state -> state.m_204336_(BlockTags.f_144280_) || state.m_204336_(BlockTags.f_13035_));
                --remainingSwaps;
                this.completedCoords.add(cand.coordinates);
                for (BlockPos adj : this.adjacent(cand.coordinates)) {
                    BlockState state2 = this.world.m_8055_(adj);
                    boolean isWood = state2.m_204336_(BlockTags.f_13106_);
                    boolean isLeaf = state2.m_204336_(BlockTags.f_13035_);
                    boolean shouldPropagateThrough = isWood || isLeaf || state2.m_60713_(Blocks.f_220833_);
                    if (!shouldPropagateThrough) continue;
                    int newRange = isLeaf ? Math.min(3, cand.range - 1) : cand.range - 1;
                    this.candidateQueue.offer(new SwapCandidate(adj, newRange));
                }
            }
            return true;
        }

        public List<BlockPos> adjacent(BlockPos original) {
            ArrayList<BlockPos> coords = new ArrayList<BlockPos>();
            for (int dx = -1; dx <= 1; ++dx) {
                for (int dy = -1; dy <= 1; ++dy) {
                    for (int dz = -1; dz <= 1; ++dz) {
                        if (dx == 0 && dy == 0 && dz == 0) continue;
                        coords.add(original.m_7918_(dx, dy, dz));
                    }
                }
            }
            return coords;
        }

        public record SwapCandidate(BlockPos coordinates, int range) implements Comparable<SwapCandidate>
        {
            @Override
            public int compareTo(@NotNull SwapCandidate other) {
                return other.range - this.range;
            }
        }
    }
}

