/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.item.equipment.tool.terrasteel;

import java.util.List;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ThrowableProjectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import org.jetbrains.annotations.Nullable;
import vazkii.botania.api.BotaniaAPI;
import vazkii.botania.api.internal.ManaBurst;
import vazkii.botania.api.mana.BurstProperties;
import vazkii.botania.api.mana.LensEffectItem;
import vazkii.botania.common.entity.ManaBurstEntity;
import vazkii.botania.common.handler.BotaniaSounds;
import vazkii.botania.common.item.BotaniaItems;
import vazkii.botania.common.item.equipment.tool.manasteel.ManasteelSwordItem;
import vazkii.botania.network.serverbound.LeftClickPacket;
import vazkii.botania.xplat.ClientXplatAbstractions;

public class TerraBladeItem
extends ManasteelSwordItem
implements LensEffectItem {
    private static final int MANA_PER_DAMAGE = 100;

    public TerraBladeItem(Item.Properties props) {
        super(BotaniaAPI.instance().getTerrasteelItemTier(), props);
    }

    public static void leftClick(ItemStack stack) {
        if (!stack.m_41619_() && stack.m_41720_() instanceof TerraBladeItem) {
            ClientXplatAbstractions.INSTANCE.sendToServer(LeftClickPacket.INSTANCE);
        }
    }

    public static InteractionResult attackEntity(Player player, Level world, InteractionHand hand, Entity target, @Nullable EntityHitResult hit) {
        if (!player.m_9236_().f_46443_) {
            TerraBladeItem.trySpawnBurst(player);
        }
        return InteractionResult.PASS;
    }

    public static void trySpawnBurst(Player player) {
        TerraBladeItem.trySpawnBurst(player, player.m_36403_(0.0f));
    }

    public static void trySpawnBurst(Player player, float attackStrength) {
        if (!player.m_5833_() && !player.m_21205_().m_41619_() && player.m_21205_().m_150930_(BotaniaItems.terraSword) && attackStrength == 1.0f) {
            ManaBurstEntity burst = TerraBladeItem.getBurst(player, player.m_21205_());
            player.m_9236_().m_7967_((Entity)burst);
            player.m_21205_().m_41622_(1, (LivingEntity)player, p -> p.m_21190_(InteractionHand.MAIN_HAND));
            player.m_9236_().m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), BotaniaSounds.terraBlade, SoundSource.PLAYERS, 1.0f, 1.0f);
        }
    }

    @Override
    public int getManaPerDamage() {
        return 100;
    }

    public static ManaBurstEntity getBurst(Player player, ItemStack stack) {
        ManaBurstEntity burst = new ManaBurstEntity(player);
        float motionModifier = 7.0f;
        burst.setColor(0x20FF20);
        burst.setMana(100);
        burst.setStartingMana(100);
        burst.setMinManaLoss(40);
        burst.setManaLossPerTick(4.0f);
        burst.setGravity(0.0f);
        burst.m_20256_(burst.m_20184_().m_82490_((double)motionModifier));
        burst.setSourceLens(stack.m_41777_());
        return burst;
    }

    @Override
    public void apply(ItemStack stack, BurstProperties props, Level level) {
    }

    @Override
    public boolean collideBurst(ManaBurst burst, HitResult pos, boolean isManaBlock, boolean shouldKill, ItemStack stack) {
        return shouldKill;
    }

    @Override
    public void updateBurst(ManaBurst burst, ItemStack stack) {
        ThrowableProjectile entity = burst.entity();
        AABB axis = new AABB(entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), entity.f_19790_, entity.f_19791_, entity.f_19792_).m_82400_(1.0);
        List entities = entity.m_9236_().m_45976_(LivingEntity.class, axis);
        Entity thrower = entity.m_19749_();
        for (LivingEntity living : entities) {
            if (living == thrower) continue;
            if (living instanceof Player) {
                Player throwingPlayer;
                Player livingPlayer = (Player)living;
                if (thrower instanceof Player && !(throwingPlayer = (Player)thrower).m_7099_(livingPlayer)) continue;
            }
            if (living.f_20916_ != 0) continue;
            int cost = 33;
            int mana = burst.getMana();
            if (mana < cost) continue;
            burst.setMana(mana - cost);
            float damage = 4.0f + BotaniaAPI.instance().getTerrasteelItemTier().m_6631_();
            if (burst.isFake() || entity.m_9236_().f_46443_) continue;
            DamageSource source = living.m_269291_().m_269425_();
            if (thrower instanceof Player) {
                Player player = (Player)thrower;
                source = player.m_269291_().m_269075_(player);
            } else if (thrower instanceof LivingEntity) {
                LivingEntity livingEntity = (LivingEntity)thrower;
                source = livingEntity.m_269291_().m_269333_(livingEntity);
            }
            living.m_6469_(source, damage);
            entity.m_146870_();
            break;
        }
    }

    @Override
    public boolean doParticles(ManaBurst burst, ItemStack stack) {
        return true;
    }
}

