/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.block.flower.generating;

import com.google.common.collect.Iterables;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.animal.Sheep;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import vazkii.botania.api.block_entity.BindableSpecialFlowerBlockEntity;
import vazkii.botania.api.block_entity.GeneratingFlowerBlockEntity;
import vazkii.botania.api.block_entity.RadiusDescriptor;
import vazkii.botania.client.core.helper.RenderHelper;
import vazkii.botania.common.block.BotaniaFlowerBlocks;
import vazkii.botania.common.helper.ColorHelper;
import vazkii.botania.common.helper.DelayHelper;

public class SpectrolusBlockEntity
extends GeneratingFlowerBlockEntity {
    public static final String TAG_NEXT_COLOR = "nextColor";
    private static final int WOOL_GEN = 1200;
    private static final int SHEEP_GEN = 5000;
    private static final int BABY_SHEEP_GEN = 1;
    private static final int RANGE = 1;
    private DyeColor nextColor = DyeColor.WHITE;

    public SpectrolusBlockEntity(BlockPos pos, BlockState state) {
        super(BotaniaFlowerBlocks.SPECTROLUS, pos, state);
    }

    @Override
    public void tickFlower() {
        super.tickFlower();
        if (this.m_58904_().f_46443_) {
            return;
        }
        List sheeps = this.m_58904_().m_6443_(Sheep.class, new AABB(this.getEffectivePos()), Entity::m_6084_);
        AABB itemAABB = new AABB(this.getEffectivePos().m_7918_(-1, -1, -1), this.getEffectivePos().m_7918_(2, 2, 2));
        Predicate<ItemEntity> selector = e -> DelayHelper.canInteractWithImmediate(this, e);
        List items = this.m_58904_().m_6443_(ItemEntity.class, itemAABB, selector);
        for (Entity target : Iterables.concat((Iterable)sheeps, (Iterable)items)) {
            ItemEntity item;
            ItemStack stack;
            if (target instanceof Sheep) {
                Sheep sheep = (Sheep)target;
                if (!sheep.m_29875_() && sheep.m_29874_() == this.nextColor) {
                    this.addManaAndCycle(sheep.m_6162_() ? 1 : 5000);
                    float pitch = sheep.m_6162_() ? (this.f_58857_.f_46441_.m_188501_() - this.f_58857_.f_46441_.m_188501_()) * 0.2f + 1.5f : (this.f_58857_.f_46441_.m_188501_() - this.f_58857_.f_46441_.m_188501_()) * 0.2f + 1.0f;
                    sheep.m_5496_(SoundEvents.f_12342_, 0.9f, pitch);
                    sheep.m_5496_(SoundEvents.f_11912_, 1.0f, 1.0f);
                    ItemStack morbid = new ItemStack((ItemLike)(sheep.m_6060_() ? Items.f_42659_ : Items.f_42658_));
                    ((ServerLevel)this.m_58904_()).m_8767_((ParticleOptions)new ItemParticleOption(ParticleTypes.f_123752_, morbid), target.m_20185_(), target.m_20186_() + (double)target.m_20192_(), target.m_20189_(), 20, 0.1, 0.1, 0.1, 0.05);
                    ItemStack wool = new ItemStack((ItemLike)ColorHelper.WOOL_MAP.apply(sheep.m_29874_()));
                    ((ServerLevel)this.m_58904_()).m_8767_((ParticleOptions)new ItemParticleOption(ParticleTypes.f_123752_, wool), target.m_20185_(), target.m_20186_() + (double)target.m_20192_(), target.m_20189_(), 20, 0.1, 0.1, 0.1, 0.05);
                }
                sheep.m_21153_(0.0f);
                continue;
            }
            if (!(target instanceof ItemEntity) || (stack = (item = (ItemEntity)target).m_32055_()).m_41619_() || !ColorHelper.isWool(Block.m_49814_((Item)stack.m_41720_()))) continue;
            Block expected = ColorHelper.WOOL_MAP.apply(this.nextColor);
            if (expected.m_5456_() == stack.m_41720_()) {
                this.addManaAndCycle(1200);
                ((ServerLevel)this.m_58904_()).m_8767_((ParticleOptions)new ItemParticleOption(ParticleTypes.f_123752_, stack), target.m_20185_(), target.m_20186_(), target.m_20189_(), 20, 0.1, 0.1, 0.1, 0.05);
            }
            target.m_146870_();
        }
    }

    private void addManaAndCycle(int toAdd) {
        this.addMana(toAdd);
        this.nextColor = this.nextColor == DyeColor.BLACK ? DyeColor.WHITE : DyeColor.values()[this.nextColor.ordinal() + 1];
        this.sync();
    }

    @Override
    public RadiusDescriptor getRadius() {
        return RadiusDescriptor.Rectangle.square(this.getEffectivePos(), 1);
    }

    @Override
    public int getMaxMana() {
        return 16000;
    }

    @Override
    public int getColor() {
        return ColorHelper.getColorLegibleOnGrayBackground(this.nextColor);
    }

    @Override
    public void writeToPacketNBT(CompoundTag cmp) {
        super.writeToPacketNBT(cmp);
        cmp.m_128405_(TAG_NEXT_COLOR, this.nextColor.ordinal());
    }

    @Override
    public void readFromPacketNBT(CompoundTag cmp) {
        super.readFromPacketNBT(cmp);
        this.nextColor = DyeColor.m_41053_((int)cmp.m_128451_(TAG_NEXT_COLOR));
    }

    public static class WandHud
    extends BindableSpecialFlowerBlockEntity.BindableFlowerWandHud<SpectrolusBlockEntity> {
        public WandHud(SpectrolusBlockEntity flower) {
            super(flower);
        }

        @Override
        public void renderHUD(GuiGraphics gui, Minecraft mc) {
            ItemStack stack = new ItemStack((ItemLike)ColorHelper.WOOL_MAP.apply(((SpectrolusBlockEntity)this.flower).nextColor));
            if (stack.m_41619_()) {
                super.renderHUD(gui, mc);
            } else {
                int halfWidth = RenderHelper.itemWithNameWidth(mc, stack) / 2;
                int centerY = mc.m_91268_().m_85446_() / 2;
                super.renderHUD(gui, mc, halfWidth + 2, halfWidth + 2, 48);
                RenderHelper.renderItemWithNameCentered(gui, mc, stack, centerY + 30, ColorHelper.getColorLegibleOnGrayBackground(((SpectrolusBlockEntity)this.flower).nextColor));
            }
        }
    }
}

