/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.block.block_entity.mana;

import com.google.common.base.Predicates;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import vazkii.botania.api.BotaniaAPI;
import vazkii.botania.api.BotaniaAPIClient;
import vazkii.botania.api.block.WandHUD;
import vazkii.botania.api.block.Wandable;
import vazkii.botania.api.internal.VanillaPacketDispatcher;
import vazkii.botania.api.item.ManaDissolvable;
import vazkii.botania.api.mana.KeyLocked;
import vazkii.botania.api.mana.ManaBlockType;
import vazkii.botania.api.mana.ManaItem;
import vazkii.botania.api.mana.ManaNetworkAction;
import vazkii.botania.api.mana.ManaPool;
import vazkii.botania.api.mana.spark.ManaSpark;
import vazkii.botania.api.mana.spark.SparkAttachable;
import vazkii.botania.api.recipe.ManaInfusionRecipe;
import vazkii.botania.api.state.BotaniaStateProperties;
import vazkii.botania.client.core.helper.RenderHelper;
import vazkii.botania.client.fx.SparkleParticleData;
import vazkii.botania.client.fx.WispParticleData;
import vazkii.botania.client.gui.HUDHandler;
import vazkii.botania.common.block.BotaniaBlocks;
import vazkii.botania.common.block.block_entity.BotaniaBlockEntities;
import vazkii.botania.common.block.block_entity.BotaniaBlockEntity;
import vazkii.botania.common.block.block_entity.mana.BellowsBlockEntity;
import vazkii.botania.common.block.block_entity.mana.ThrottledPacket;
import vazkii.botania.common.block.mana.ManaPoolBlock;
import vazkii.botania.common.crafting.BotaniaRecipeTypes;
import vazkii.botania.common.handler.BotaniaSounds;
import vazkii.botania.common.handler.ManaNetworkHandler;
import vazkii.botania.common.helper.EntityHelper;
import vazkii.botania.common.item.BotaniaItems;
import vazkii.botania.common.item.ManaTabletItem;
import vazkii.botania.common.proxy.Proxy;
import vazkii.botania.xplat.BotaniaConfig;
import vazkii.botania.xplat.XplatAbstractions;

public class ManaPoolBlockEntity
extends BotaniaBlockEntity
implements ManaPool,
KeyLocked,
SparkAttachable,
ThrottledPacket,
Wandable {
    public static final int PARTICLE_COLOR = 50943;
    public static final int MAX_MANA = 1000000;
    private static final int MAX_MANA_DILLUTED = 10000;
    private static final String TAG_MANA = "mana";
    private static final String TAG_OUTPUTTING = "outputting";
    private static final String TAG_MANA_CAP = "manaCap";
    private static final String TAG_CAN_ACCEPT = "canAccept";
    private static final String TAG_CAN_SPARE = "canSpare";
    private static final String TAG_INPUT_KEY = "inputKey";
    private static final String TAG_OUTPUT_KEY = "outputKey";
    private static final int CRAFT_EFFECT_EVENT = 0;
    private static final int CHARGE_EFFECT_EVENT = 1;
    private boolean outputting = false;
    private Optional<DyeColor> legacyColor = Optional.empty();
    private int mana;
    private int manaCap = -1;
    private int soundTicks = 0;
    private boolean canAccept = true;
    private boolean canSpare = true;
    boolean isDoingTransfer = false;
    int ticksDoingTransfer = 0;
    private String inputKey = "";
    private final String outputKey = "";
    private int ticks = 0;
    private boolean sendPacket = false;

    public ManaPoolBlockEntity(BlockPos pos, BlockState state) {
        super(BotaniaBlockEntities.POOL, pos, state);
    }

    @Override
    public boolean isFull() {
        BlockState stateBelow = this.f_58857_.m_8055_(this.f_58858_.m_7495_());
        return !stateBelow.m_60713_(BotaniaBlocks.manaVoid) && this.getCurrentMana() >= this.getMaxMana();
    }

    @Override
    public void receiveMana(int mana) {
        int old = this.mana;
        this.mana = Math.max(0, Math.min(this.getCurrentMana() + mana, this.getMaxMana()));
        if (old != this.mana) {
            this.m_6596_();
            this.markDispatchable();
        }
    }

    public void m_7651_() {
        super.m_7651_();
        BotaniaAPI.instance().getManaNetworkInstance().fireManaNetworkEvent(this, ManaBlockType.POOL, ManaNetworkAction.REMOVE);
    }

    public static int calculateComparatorLevel(int mana, int max) {
        int val = (int)((double)mana / (double)max * 15.0);
        if (mana > 0) {
            val = Math.max(val, 1);
        }
        return val;
    }

    public ManaInfusionRecipe getMatchingRecipe(@NotNull ItemStack stack, @NotNull BlockState state) {
        ArrayList<ManaInfusionRecipe> matchingNonCatRecipes = new ArrayList<ManaInfusionRecipe>();
        ArrayList<ManaInfusionRecipe> matchingCatRecipes = new ArrayList<ManaInfusionRecipe>();
        for (ManaInfusionRecipe recipe : BotaniaRecipeTypes.getRecipes(this.f_58857_, BotaniaRecipeTypes.MANA_INFUSION_TYPE).values()) {
            if (!recipe.matches(stack)) continue;
            if (recipe.getRecipeCatalyst() == null) {
                matchingNonCatRecipes.add(recipe);
                continue;
            }
            if (!recipe.getRecipeCatalyst().test(state)) continue;
            matchingCatRecipes.add(recipe);
        }
        return !matchingCatRecipes.isEmpty() ? (ManaInfusionRecipe)matchingCatRecipes.get(0) : (!matchingNonCatRecipes.isEmpty() ? (ManaInfusionRecipe)matchingNonCatRecipes.get(0) : null);
    }

    public boolean collideEntityItem(ItemEntity item) {
        if (this.f_58857_.f_46443_ || !item.m_6084_() || item.m_32055_().m_41619_()) {
            return false;
        }
        ItemStack stack = item.m_32055_();
        Item item2 = stack.m_41720_();
        if (item2 instanceof ManaDissolvable) {
            ManaDissolvable dissolvable = (ManaDissolvable)item2;
            dissolvable.onDissolveTick(this, item);
        }
        if (XplatAbstractions.INSTANCE.itemFlagsComponent((ItemEntity)item).manaInfusionSpawned) {
            return false;
        }
        ManaInfusionRecipe recipe = this.getMatchingRecipe(stack, this.f_58857_.m_8055_(this.f_58858_.m_7495_()));
        if (recipe != null) {
            int mana = recipe.getManaToConsume();
            if (this.getCurrentMana() >= mana) {
                this.receiveMana(-mana);
                ItemStack output = recipe.getRecipeOutput(this.f_58857_.m_9598_(), stack);
                EntityHelper.shrinkItem(item);
                item.m_6853_(false);
                ItemEntity outputItem = new ItemEntity(this.f_58857_, (double)this.f_58858_.m_123341_() + 0.5, (double)this.f_58858_.m_123342_() + 1.5, (double)this.f_58858_.m_123343_() + 0.5, output);
                XplatAbstractions.INSTANCE.itemFlagsComponent((ItemEntity)outputItem).manaInfusionSpawned = true;
                this.f_58857_.m_7967_((Entity)outputItem);
                this.craftingEffect(true);
                return true;
            }
        }
        return false;
    }

    public void craftingEffect(boolean playSound) {
        if (playSound && this.soundTicks == 0) {
            this.f_58857_.m_5594_(null, this.f_58858_, BotaniaSounds.manaPoolCraft, SoundSource.BLOCKS, 1.0f, 1.0f);
            this.soundTicks = 6;
        }
        this.f_58857_.m_142346_(null, GameEvent.f_223702_, this.m_58899_());
        this.f_58857_.m_7696_(this.m_58899_(), this.m_58900_().m_60734_(), 0, 0);
    }

    public boolean m_7531_(int event, int param) {
        switch (event) {
            case 0: {
                if (this.f_58857_.f_46443_) {
                    for (int i = 0; i < 25; ++i) {
                        float red = (float)Math.random();
                        float green = (float)Math.random();
                        float blue = (float)Math.random();
                        SparkleParticleData data = SparkleParticleData.sparkle((float)Math.random(), red, green, blue, 10);
                        this.f_58857_.m_7106_((ParticleOptions)data, (double)this.f_58858_.m_123341_() + 0.5 + Math.random() * 0.4 - 0.2, (double)this.f_58858_.m_123342_() + 0.75, (double)this.f_58858_.m_123343_() + 0.5 + Math.random() * 0.4 - 0.2, 0.0, 0.0, 0.0);
                    }
                }
                return true;
            }
            case 1: {
                if (this.f_58857_.f_46443_ && BotaniaConfig.common().chargingAnimationEnabled()) {
                    boolean outputting = param == 1;
                    Vec3 itemVec = Vec3.m_82528_((Vec3i)this.f_58858_).m_82520_(0.5, 0.5 + Math.random() * 0.3, 0.5);
                    Vec3 tileVec = Vec3.m_82528_((Vec3i)this.f_58858_).m_82520_(0.2 + Math.random() * 0.6, 0.0, 0.2 + Math.random() * 0.6);
                    Proxy.INSTANCE.lightningFX(this.f_58857_, outputting ? tileVec : itemVec, outputting ? itemVec : tileVec, 80.0f, this.f_58857_.f_46441_.m_188505_(), 1140881820, 1140901631);
                }
                return true;
            }
        }
        return super.m_7531_(event, param);
    }

    private void initManaCapAndNetwork() {
        if (this.getMaxMana() == -1) {
            int n = this.manaCap = ((ManaPoolBlock)this.m_58900_().m_60734_()).variant == ManaPoolBlock.Variant.DILUTED ? 10000 : 1000000;
        }
        if (!ManaNetworkHandler.instance.isPoolIn(this.f_58857_, this) && !this.m_58901_()) {
            BotaniaAPI.instance().getManaNetworkInstance().fireManaNetworkEvent(this, ManaBlockType.POOL, ManaNetworkAction.ADD);
        }
    }

    public static void clientTick(Level level, BlockPos worldPosition, BlockState state, ManaPoolBlockEntity self) {
        self.initManaCapAndNetwork();
        double particleChance = 1.0 - (double)self.getCurrentMana() / (double)self.getMaxMana() * 0.1;
        if (Math.random() > particleChance) {
            float red = 0.0f;
            float green = 0.7764706f;
            float blue = 1.0f;
            WispParticleData data = WispParticleData.wisp((float)Math.random() / 3.0f, red, green, blue, 2.0f);
            level.m_7106_((ParticleOptions)data, (double)worldPosition.m_123341_() + 0.3 + Math.random() * 0.5, (double)worldPosition.m_123342_() + 0.6 + Math.random() * 0.25, (double)worldPosition.m_123343_() + Math.random(), 0.0, (double)((float)Math.random() / 25.0f), 0.0);
        }
    }

    public static void serverTick(Level level, BlockPos worldPosition, BlockState state, ManaPoolBlockEntity self) {
        if (self.legacyColor.isPresent()) {
            self.setColor(self.legacyColor);
            self.legacyColor = Optional.empty();
        }
        self.initManaCapAndNetwork();
        boolean wasDoingTransfer = self.isDoingTransfer;
        self.isDoingTransfer = false;
        if (self.soundTicks > 0) {
            --self.soundTicks;
        }
        if (self.sendPacket && self.ticks % 10 == 0) {
            VanillaPacketDispatcher.dispatchTEToNearbyPlayers(self);
            self.sendPacket = false;
        }
        List items = level.m_45976_(ItemEntity.class, new AABB(worldPosition, worldPosition.m_7918_(1, 1, 1)));
        for (ItemEntity item : items) {
            if (!item.m_6084_()) continue;
            ItemStack stack = item.m_32055_();
            ManaItem mana = XplatAbstractions.INSTANCE.findManaItem(stack);
            if (stack.m_41619_() || mana == null || (!self.outputting || !mana.canReceiveManaFromPool(self)) && (self.outputting || !mana.canExportManaToPool(self))) continue;
            boolean didSomething = false;
            int bellowCount = 0;
            if (self.outputting) {
                for (Direction dir : Direction.Plane.HORIZONTAL) {
                    BellowsBlockEntity bellows;
                    BlockEntity tile = level.m_7702_(worldPosition.m_121945_(dir));
                    if (!(tile instanceof BellowsBlockEntity) || (bellows = (BellowsBlockEntity)tile).getLinkedTile() != self) continue;
                    ++bellowCount;
                }
            }
            int transfRate = 1000 * (bellowCount + 1);
            if (self.outputting) {
                if (self.canSpare) {
                    if (self.getCurrentMana() > 0 && mana.getMana() < mana.getMaxMana()) {
                        didSomething = true;
                    }
                    int manaVal = Math.min(transfRate, Math.min(self.getCurrentMana(), mana.getMaxMana() - mana.getMana()));
                    mana.addMana(manaVal);
                    self.receiveMana(-manaVal);
                }
            } else if (self.canAccept) {
                int manaVal;
                if (mana.getMana() > 0 && !self.isFull()) {
                    didSomething = true;
                }
                if ((manaVal = Math.min(transfRate, Math.min(self.getMaxMana() - self.getCurrentMana(), mana.getMana()))) == 0 && self.f_58857_.m_8055_(worldPosition.m_7495_()).m_60713_(BotaniaBlocks.manaVoid)) {
                    manaVal = Math.min(transfRate, mana.getMana());
                }
                mana.addMana(-manaVal);
                self.receiveMana(manaVal);
            }
            if (!didSomething) continue;
            if (BotaniaConfig.common().chargingAnimationEnabled() && level.f_46441_.m_188503_(20) == 0) {
                level.m_7696_(worldPosition, state.m_60734_(), 1, self.outputting ? 1 : 0);
            }
            EntityHelper.syncItem(item);
            self.isDoingTransfer = self.outputting;
        }
        if (self.isDoingTransfer) {
            ++self.ticksDoingTransfer;
        } else {
            self.ticksDoingTransfer = 0;
            if (wasDoingTransfer) {
                VanillaPacketDispatcher.dispatchTEToNearbyPlayers(self);
            }
        }
        ++self.ticks;
    }

    @Override
    public void writePacketNBT(CompoundTag cmp) {
        cmp.m_128405_(TAG_MANA, this.getCurrentMana());
        cmp.m_128379_(TAG_OUTPUTTING, this.outputting);
        cmp.m_128405_(TAG_MANA_CAP, this.getMaxMana());
        cmp.m_128379_(TAG_CAN_ACCEPT, this.canAccept);
        cmp.m_128379_(TAG_CAN_SPARE, this.canSpare);
        cmp.m_128359_(TAG_INPUT_KEY, this.inputKey);
        cmp.m_128359_(TAG_OUTPUT_KEY, "");
    }

    @Override
    public void readPacketNBT(CompoundTag cmp) {
        this.mana = cmp.m_128451_(TAG_MANA);
        this.outputting = cmp.m_128471_(TAG_OUTPUTTING);
        if (cmp.m_128441_("color")) {
            DyeColor color = DyeColor.m_41053_((int)cmp.m_128451_("color"));
            this.legacyColor = color != DyeColor.WHITE ? Optional.of(color) : Optional.empty();
        }
        if (cmp.m_128441_(TAG_MANA_CAP)) {
            this.manaCap = cmp.m_128451_(TAG_MANA_CAP);
        }
        if (cmp.m_128441_(TAG_CAN_ACCEPT)) {
            this.canAccept = cmp.m_128471_(TAG_CAN_ACCEPT);
        }
        if (cmp.m_128441_(TAG_CAN_SPARE)) {
            this.canSpare = cmp.m_128471_(TAG_CAN_SPARE);
        }
        if (cmp.m_128441_(TAG_INPUT_KEY)) {
            this.inputKey = cmp.m_128461_(TAG_INPUT_KEY);
        }
        if (cmp.m_128441_(TAG_OUTPUT_KEY)) {
            this.inputKey = cmp.m_128461_(TAG_OUTPUT_KEY);
        }
    }

    @Override
    public boolean onUsedByWand(@Nullable Player player, ItemStack stack, Direction side) {
        if (player == null || player.m_6144_()) {
            this.outputting = !this.outputting;
            VanillaPacketDispatcher.dispatchTEToNearbyPlayers(this);
        }
        return true;
    }

    @Override
    public boolean canReceiveManaFromBursts() {
        return true;
    }

    @Override
    public boolean isOutputtingPower() {
        return this.outputting;
    }

    @Override
    public Level getManaReceiverLevel() {
        return this.m_58904_();
    }

    @Override
    public BlockPos getManaReceiverPos() {
        return this.m_58899_();
    }

    @Override
    public int getCurrentMana() {
        Block block = this.m_58900_().m_60734_();
        if (block instanceof ManaPoolBlock) {
            ManaPoolBlock pool = (ManaPoolBlock)block;
            return pool.variant == ManaPoolBlock.Variant.CREATIVE ? 1000000 : this.mana;
        }
        return 0;
    }

    @Override
    public int getMaxMana() {
        return this.manaCap;
    }

    @Override
    public String getInputKey() {
        return this.inputKey;
    }

    @Override
    public String getOutputKey() {
        return "";
    }

    @Override
    public boolean canAttachSpark(ItemStack stack) {
        return true;
    }

    @Override
    public ManaSpark getAttachedSpark() {
        List sparks = this.f_58857_.m_6443_(Entity.class, new AABB(this.f_58858_.m_7494_(), this.f_58858_.m_7494_().m_7918_(1, 1, 1)), (Predicate)Predicates.instanceOf(ManaSpark.class));
        if (sparks.size() == 1) {
            Entity e = (Entity)sparks.get(0);
            return (ManaSpark)e;
        }
        return null;
    }

    @Override
    public boolean areIncomingTranfersDone() {
        return false;
    }

    @Override
    public int getAvailableSpaceForMana() {
        int space = Math.max(0, this.getMaxMana() - this.getCurrentMana());
        if (space > 0) {
            return space;
        }
        if (this.f_58857_.m_8055_(this.f_58858_.m_7495_()).m_60713_(BotaniaBlocks.manaVoid)) {
            return this.getMaxMana();
        }
        return 0;
    }

    @Override
    public Optional<DyeColor> getColor() {
        return ((BotaniaStateProperties.OptionalDyeColor)((Object)this.m_58900_().m_61143_(BotaniaStateProperties.OPTIONAL_DYE_COLOR))).toDyeColor();
    }

    @Override
    public void setColor(Optional<DyeColor> color) {
        this.f_58857_.m_46597_(this.f_58858_, (BlockState)this.m_58900_().m_61124_(BotaniaStateProperties.OPTIONAL_DYE_COLOR, (Comparable)((Object)BotaniaStateProperties.OptionalDyeColor.fromOptionalDyeColor(color))));
    }

    @Override
    public void markDispatchable() {
        this.sendPacket = true;
    }

    public static class WandHud
    implements WandHUD {
        private final ManaPoolBlockEntity pool;

        public WandHud(ManaPoolBlockEntity pool) {
            this.pool = pool;
        }

        @Override
        public void renderHUD(GuiGraphics gui, Minecraft mc) {
            ItemStack poolStack = new ItemStack((ItemLike)this.pool.m_58900_().m_60734_());
            String name = poolStack.m_41786_().getString();
            int centerX = mc.m_91268_().m_85445_() / 2;
            int centerY = mc.m_91268_().m_85446_() / 2;
            int width = Math.max(102, mc.f_91062_.m_92895_(name)) + 4;
            RenderHelper.renderHUDBox(gui, centerX - width / 2, centerY + 8, centerX + width / 2, centerY + 48);
            BotaniaAPIClient.instance().drawSimpleManaHUD(gui, 38399, this.pool.getCurrentMana(), this.pool.getMaxMana(), name);
            RenderSystem.enableBlend();
            RenderSystem.blendFunc((int)770, (int)771);
            int arrowU = this.pool.outputting ? 22 : 0;
            int arrowV = 38;
            RenderHelper.drawTexturedModalRect(gui, HUDHandler.manaBar, centerX - 11, centerY + 30, arrowU, arrowV, 22, 15);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            ItemStack tablet = new ItemStack((ItemLike)BotaniaItems.manaTablet);
            ManaTabletItem.setStackCreative(tablet);
            gui.m_280480_(tablet, centerX - 31, centerY + 30);
            gui.m_280480_(poolStack, centerX + 15, centerY + 30);
            RenderSystem.disableBlend();
        }
    }
}

