/*
 * Decompiled with CFR 0.152.
 */
package com.glodblock.github.appflux.common.me.service;

import appeng.api.networking.IGridNode;
import appeng.api.networking.IGridService;
import appeng.api.networking.IGridServiceProvider;
import com.glodblock.github.appflux.common.me.service.IEnergyDistributor;
import java.util.IdentityHashMap;
import java.util.Map;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class EnergyDistributeService
implements IGridService,
IGridServiceProvider {
    private final Map<IGridNode, IEnergyDistributor> distributors = new IdentityHashMap<IGridNode, IEnergyDistributor>();

    public void onLevelEndTick(Level level) {
        for (IEnergyDistributor dis : this.distributors.values()) {
            dis.distribute();
            dis.charge();
        }
    }

    public void removeNode(IGridNode gridNode) {
        this.distributors.remove(gridNode);
    }

    public void addNode(IGridNode gridNode, @Nullable CompoundTag savedData) {
        IEnergyDistributor distributor = (IEnergyDistributor)gridNode.getService(IEnergyDistributor.class);
        if (distributor != null) {
            this.distributors.put(gridNode, distributor);
        }
    }
}

