/*
 * Decompiled with CFR 0.152.
 */
package com.glodblock.github.appflux.common.me.energy;

import appeng.api.config.Actionable;
import appeng.api.config.PowerUnits;
import appeng.api.networking.energy.IEnergyService;
import appeng.api.networking.security.IActionSource;
import appeng.api.networking.storage.IStorageService;
import appeng.api.stacks.AEKey;
import com.glodblock.github.appflux.common.me.key.FluxKey;
import com.glodblock.github.appflux.common.me.key.type.EnergyType;
import com.glodblock.github.appflux.config.AFConfig;
import com.glodblock.github.appflux.util.AFUtil;
import java.util.ArrayList;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.fml.ModList;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.NotNull;
import sonar.fluxnetworks.api.FluxCapabilities;

public final class EnergyHandler {
    private static final ArrayList<Pair<Capability<?>, Handler<?>>> HANDLERS = new ArrayList();
    private static final Handler<IEnergyStorage> DEFAULT = (accepter, storage, source) -> {
        int actuallyDrained;
        long differ;
        long drained;
        int toAdd = accepter.receiveEnergy(AFUtil.clampLong(AFConfig.getFluxAccessorIO()), true);
        if (toAdd > 0 && (drained = storage.getInventory().extract((AEKey)FluxKey.of(EnergyType.FE), (long)toAdd, Actionable.MODULATE, source)) > 0L && (differ = drained - (long)(actuallyDrained = accepter.receiveEnergy((int)drained, false))) > 0L) {
            storage.getInventory().insert((AEKey)FluxKey.of(EnergyType.FE), differ, Actionable.MODULATE, source);
        }
    };

    public static <T> void addHandler(Capability<T> cap, Handler<T> handler) {
        HANDLERS.add((Pair<Capability<?>, Handler<?>>)new ImmutablePair(cap, handler));
    }

    public static <T> void send(BlockEntity te, Direction side, @NotNull IStorageService storage, @NotNull IActionSource source) {
        for (Pair<Capability<?>, Handler<?>> entry : HANDLERS) {
            Object cap = AFUtil.findCapability(te, side, (Capability)entry.getLeft());
            if (cap == null) continue;
            ((Handler)entry.getRight()).send(cap, storage, source);
            return;
        }
        IEnergyStorage cap = (IEnergyStorage)AFUtil.findCapability(te, side, ForgeCapabilities.ENERGY);
        if (cap != null) {
            DEFAULT.send(cap, storage, source);
        }
    }

    public static void chargeNetwork(@NotNull IEnergyService energy, @NotNull IStorageService storage, @NotNull IActionSource source) {
        double toAdd = Math.floor(2.147483647E9 - energy.injectPower(2.147483647E9, Actionable.SIMULATE));
        long toDrain = storage.getInventory().extract((AEKey)FluxKey.of(EnergyType.FE), (long)PowerUnits.AE.convertTo(PowerUnits.RF, toAdd), Actionable.MODULATE, source);
        energy.injectPower((double)toDrain, Actionable.MODULATE);
    }

    static {
        if (ModList.get().isLoaded("fluxnetworks")) {
            EnergyHandler.addHandler(FluxCapabilities.FN_ENERGY_STORAGE, (accepter, storage, source) -> {
                long actuallyDrained;
                long differ;
                long drained;
                long toAdd = accepter.receiveEnergyL(AFConfig.getFluxAccessorIO(), true);
                if (toAdd > 0L && (drained = storage.getInventory().extract((AEKey)FluxKey.of(EnergyType.FE), toAdd, Actionable.MODULATE, source)) > 0L && (differ = drained - (actuallyDrained = accepter.receiveEnergyL(drained, false))) > 0L) {
                    storage.getInventory().insert((AEKey)FluxKey.of(EnergyType.FE), differ, Actionable.MODULATE, source);
                }
            });
        }
    }

    public static interface Handler<T> {
        public void send(@NotNull T var1, @NotNull IStorageService var2, @NotNull IActionSource var3);
    }
}

