/*
 * Decompiled with CFR 0.152.
 */
package com.glodblock.github.appflux;

import appeng.capabilities.Capabilities;
import com.glodblock.github.appflux.client.AFClientRegistryHandler;
import com.glodblock.github.appflux.common.AFItemAndBlock;
import com.glodblock.github.appflux.common.AFRegistryHandler;
import com.glodblock.github.appflux.common.me.inventory.FEGenericStackInvStorage;
import com.glodblock.github.appflux.config.AFConfig;
import com.glodblock.github.appflux.util.AFUtil;
import com.mojang.logging.LogUtils;
import net.minecraft.core.Direction;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

@Mod(value="appflux")
public class AppFlux {
    public static final String MODID = "appflux";
    public static final Logger LOGGER = LogUtils.getLogger();
    public static AppFlux INSTANCE;

    public AppFlux() {
        assert (INSTANCE == null);
        INSTANCE = this;
        IEventBus bus = FMLJavaModLoadingContext.get().getModEventBus();
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)AFConfig.SPEC);
        AFItemAndBlock.init(AFRegistryHandler.INSTANCE);
        bus.register((Object)AFRegistryHandler.INSTANCE);
        bus.addListener(this::commonSetup);
        bus.addListener(this::clientSetup);
        bus.addListener(e -> {
            if (e.getRegistryKey() == Registries.f_279569_) {
                AFRegistryHandler.INSTANCE.registerTab((Registry<CreativeModeTab>)e.getVanillaRegistry());
            }
        });
        DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> bus.register((Object)AFClientRegistryHandler.INSTANCE));
        MinecraftForge.EVENT_BUS.addGenericListener(BlockEntity.class, event -> {
            final BlockEntity blockEntity = (BlockEntity)event.getObject();
            event.addCapability(AppFlux.id("generic_inv_wrapper"), new ICapabilityProvider(){

                @NotNull
                public <T> LazyOptional<T> getCapability(@NotNull Capability<T> capability, @Nullable Direction side) {
                    if (capability == ForgeCapabilities.ENERGY && AFUtil.shouldTryCast(blockEntity, side)) {
                        return blockEntity.getCapability(Capabilities.GENERIC_INTERNAL_INV, side).lazyMap(FEGenericStackInvStorage::new).cast();
                    }
                    return LazyOptional.empty();
                }
            });
        });
    }

    public void commonSetup(FMLCommonSetupEvent event) {
        AFRegistryHandler.INSTANCE.init();
    }

    public void clientSetup(FMLClientSetupEvent event) {
        AFClientRegistryHandler.INSTANCE.init();
    }

    public static ResourceLocation id(String id) {
        return new ResourceLocation(MODID, id);
    }
}

