/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.apotheosis.ench.library;

import com.google.common.base.Strings;
import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.blaze3d.vertex.PoseStack;
import dev.shadowsoffire.apotheosis.adventure.client.AdventureContainerScreen;
import dev.shadowsoffire.apotheosis.ench.library.EnchLibraryContainer;
import dev.shadowsoffire.apotheosis.ench.library.EnchLibraryTile;
import dev.shadowsoffire.attributeslib.AttributesLib;
import dev.shadowsoffire.placebo.Placebo;
import dev.shadowsoffire.placebo.packets.ButtonClickMessage;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.ForgeRegistry;

public class EnchLibraryScreen
extends AdventureContainerScreen<EnchLibraryContainer> {
    public static final ResourceLocation TEXTURES = new ResourceLocation("apotheosis", "textures/gui/library.png");
    public static final int MAX_ENTRIES = 5;
    public static final int ENTRY_WIDTH = 113;
    public static final int ENTRY_HEIGHT = 20;
    protected float scrollOffs;
    protected boolean scrolling;
    protected int startIndex;
    protected List<LibrarySlot> data = new ArrayList<LibrarySlot>();
    protected EditBox filter = null;
    private static DecimalFormat f = new DecimalFormat("##.#");

    public EnchLibraryScreen(EnchLibraryContainer container, Inventory inv, Component title) {
        super(container, inv, title);
        this.f_97727_ = 230;
        container.setNotifier(this::containerChanged);
    }

    protected void m_7856_() {
        super.m_7856_();
        this.filter = (EditBox)this.m_142416_((GuiEventListener)new EditBox(this.f_96547_, this.getGuiLeft() + 16, this.getGuiTop() + 16, 110, 11, this.filter, (Component)Component.m_237113_((String)"")));
        this.filter.m_94182_(false);
        this.filter.m_94202_(9924943);
        this.filter.m_94151_(t -> this.containerChanged());
        this.m_7522_((GuiEventListener)this.filter);
        this.containerChanged();
    }

    public boolean m_7933_(int pKeyCode, int pScanCode, int pModifiers) {
        InputConstants.Key mouseKey = InputConstants.m_84827_((int)pKeyCode, (int)pScanCode);
        if (this.f_96541_.f_91066_.f_92092_.isActiveAndMatches(mouseKey) && this.m_7222_() == this.filter) {
            return true;
        }
        return super.m_7933_(pKeyCode, pScanCode, pModifiers);
    }

    public void m_88315_(GuiGraphics gfx, int mouseX, int mouseY, float partialTicks) {
        this.m_280273_(gfx);
        super.m_88315_(gfx, mouseX, mouseY, partialTicks);
        this.m_280072_(gfx, mouseX, mouseY);
    }

    protected void m_280072_(GuiGraphics gfx, int mouseX, int mouseY) {
        super.m_280072_(gfx, mouseX, mouseY);
        LibrarySlot libSlot = this.getHoveredSlot(mouseX, mouseY);
        if (libSlot != null) {
            int targetLevel;
            ArrayList<MutableComponent> list = new ArrayList<MutableComponent>();
            MutableComponent name = Component.m_237115_((String)libSlot.ench.m_44704_()).m_6270_(Style.f_131099_.m_131148_(TextColor.m_131266_((int)0xFFFF80)).m_131162_(Boolean.valueOf(true)));
            if (AttributesLib.getTooltipFlag().m_7050_()) {
                name = name.m_7220_((Component)Component.m_237113_((String)(" [" + BuiltInRegistries.f_256876_.m_7981_((Object)libSlot.ench) + "]")).m_130948_(Style.f_131099_.m_131140_(ChatFormatting.GRAY).m_131162_(Boolean.valueOf(false))));
            }
            list.add(name);
            if (I18n.m_118936_((String)(libSlot.ench.m_44704_() + ".desc")) || AttributesLib.getTooltipFlag().m_7050_()) {
                MutableComponent txt = Component.m_237115_((String)(libSlot.ench.m_44704_() + ".desc")).m_6270_(Style.f_131099_.m_131140_(ChatFormatting.GRAY).m_131155_(Boolean.valueOf(true)));
                list.addAll(this.f_96547_.m_92865_().m_92414_((FormattedText)txt, this.getGuiLeft() - 16, txt.m_7383_()));
                list.add(Component.m_237113_((String)""));
            }
            list.add(Component.m_237110_((String)"tooltip.enchlib.max_lvl", (Object[])new Object[]{Component.m_237115_((String)("enchantment.level." + libSlot.maxLvl))}).m_130940_(ChatFormatting.GRAY));
            list.add(Component.m_237110_((String)"tooltip.enchlib.points", (Object[])new Object[]{EnchLibraryScreen.format(libSlot.points), EnchLibraryScreen.format(((EnchLibraryContainer)this.f_97732_).getPointCap())}).m_130940_(ChatFormatting.GRAY));
            list.add(Component.m_237113_((String)""));
            ItemStack outSlot = ((EnchLibraryContainer)this.f_97732_).ioInv.m_8020_(1);
            int current = EnchantmentHelper.m_44831_((ItemStack)outSlot).getOrDefault(libSlot.ench, 0);
            boolean shift = Screen.m_96638_();
            int n = targetLevel = shift ? Math.min(libSlot.maxLvl, 1 + (int)(Math.log(libSlot.points + EnchLibraryTile.levelToPoints(current)) / Math.log(2.0))) : current + 1;
            if (targetLevel == current) {
                ++targetLevel;
            }
            int cost = EnchLibraryTile.levelToPoints(targetLevel) - EnchLibraryTile.levelToPoints(current);
            if (targetLevel > libSlot.maxLvl) {
                list.add(Component.m_237115_((String)"tooltip.enchlib.unavailable").m_6270_(Style.f_131099_.m_131140_(ChatFormatting.RED)));
            } else {
                list.add(Component.m_237110_((String)"tooltip.enchlib.extracting", (Object[])new Object[]{Component.m_237115_((String)("enchantment.level." + targetLevel))}).m_130940_(ChatFormatting.BLUE));
                list.add(Component.m_237110_((String)"tooltip.enchlib.cost", (Object[])new Object[]{cost}).m_130940_(cost > libSlot.points ? ChatFormatting.RED : ChatFormatting.GOLD));
            }
            gfx.renderComponentTooltip(this.f_96547_, list, this.getGuiLeft() - 16 - list.stream().map(arg_0 -> ((Font)this.f_96547_).m_92852_(arg_0)).max(Integer::compare).get(), mouseY, ItemStack.f_41583_);
        }
    }

    protected void m_7286_(GuiGraphics gfx, float partial, int mouseX, int mouseY) {
        int left = this.f_97735_;
        int top = this.f_97736_;
        gfx.m_280163_(TEXTURES, left, top, 0.0f, 0.0f, this.f_97726_, this.f_97727_, 307, 256);
        int scrollbarPos = (int)(90.0f * this.scrollOffs);
        gfx.m_280163_(TEXTURES, left + 13, top + 29 + scrollbarPos, 303.0f, (float)(40 + (this.isScrollBarActive() ? 0 : 12)), 4, 12, 307, 256);
        for (int idx = this.startIndex; idx < this.startIndex + 5 && idx < this.data.size(); ++idx) {
            this.renderEntry(gfx, this.data.get(idx), this.f_97735_ + 20, this.f_97736_ + 30 + 20 * (idx - this.startIndex), mouseX, mouseY);
        }
    }

    private void renderEntry(GuiGraphics gfx, LibrarySlot data, int x, int y, int mouseX, int mouseY) {
        LibrarySlot hover = this.getHoveredSlot(mouseX, mouseY);
        gfx.m_280163_(TEXTURES, x, y, 194.0f, data == hover ? 20.0f : 0.0f, 113, 20, 307, 256);
        int progress = (int)Math.round(85.0 * Math.sqrt(data.points) / (double)((float)Math.sqrt(((EnchLibraryContainer)this.f_97732_).getPointCap())));
        gfx.m_280163_(TEXTURES, x + 3, y + 14, 197.0f, 42.0f, progress, 3, 307, 256);
        PoseStack stack = gfx.m_280168_();
        stack.m_85836_();
        MutableComponent txt = Component.m_237115_((String)data.ench.m_44704_());
        float scale = 1.0f;
        if (this.f_96547_.m_92852_((FormattedText)txt) > 107) {
            scale = 60.0f / (float)this.f_96547_.m_92852_((FormattedText)txt);
        }
        stack.m_85841_(scale, scale, 1.0f);
        gfx.m_280614_(this.f_96547_, (Component)txt, (int)((float)(x + 3) / scale), (int)((float)(y + 3) / scale), 9363789, false);
        stack.m_85849_();
    }

    public boolean m_6375_(double pMouseX, double pMouseY, int pButton) {
        this.scrolling = false;
        if (this.m_6774_(14, 29, 4, 103, pMouseX, pMouseY)) {
            this.scrolling = true;
            this.m_7979_(pMouseX, pMouseY, pButton, 0.0, 0.0);
            return true;
        }
        LibrarySlot libSlot = this.getHoveredSlot((int)pMouseX, (int)pMouseY);
        if (libSlot != null) {
            int id = ((ForgeRegistry)ForgeRegistries.ENCHANTMENTS).getID((Object)libSlot.ench);
            if (Screen.m_96638_()) {
                id |= Integer.MIN_VALUE;
            }
            ((EnchLibraryContainer)this.f_97732_).onButtonClick(id);
            Placebo.CHANNEL.sendToServer((Object)new ButtonClickMessage(id));
            this.f_96541_.m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119752_((SoundEvent)SoundEvents.f_12495_, (float)1.0f));
            return true;
        }
        if (this.filter.m_274382_() && pButton == 1) {
            this.filter.m_94144_("");
            return true;
        }
        return super.m_6375_(pMouseX, pMouseY, pButton);
    }

    public boolean m_7979_(double pMouseX, double pMouseY, int pButton, double pDragX, double pDragY) {
        if (this.scrolling && this.isScrollBarActive()) {
            int barTop = this.f_97736_ + 14;
            int barBot = barTop + 103;
            this.scrollOffs = ((float)pMouseY - (float)barTop - 6.0f) / ((float)(barBot - barTop) - 12.0f) - 0.12f;
            this.scrollOffs = Mth.m_14036_((float)this.scrollOffs, (float)0.0f, (float)1.0f);
            this.startIndex = (int)((double)(this.scrollOffs * (float)this.getOffscreenRows()) + 0.5);
            return true;
        }
        return super.m_7979_(pMouseX, pMouseY, pButton, pDragX, pDragY);
    }

    public boolean m_6050_(double pMouseX, double pMouseY, double pDelta) {
        if (this.isScrollBarActive()) {
            int i = this.getOffscreenRows();
            this.scrollOffs = (float)((double)this.scrollOffs - pDelta / (double)i);
            this.scrollOffs = Mth.m_14036_((float)this.scrollOffs, (float)0.0f, (float)1.0f);
            this.startIndex = (int)((double)(this.scrollOffs * (float)i) + 0.5);
        }
        return true;
    }

    private boolean isScrollBarActive() {
        return this.data.size() > 5;
    }

    protected int getOffscreenRows() {
        return this.data.size() - 5;
    }

    private void containerChanged() {
        this.data.clear();
        List<Object2IntMap.Entry<Enchantment>> entries = this.filter(((EnchLibraryContainer)this.f_97732_).getPointsForDisplay());
        for (Object2IntMap.Entry<Enchantment> e : entries) {
            this.data.add(new LibrarySlot((Enchantment)e.getKey(), e.getIntValue(), ((EnchLibraryContainer)this.f_97732_).getMaxLevel((Enchantment)e.getKey())));
        }
        if (!this.isScrollBarActive()) {
            this.scrollOffs = 0.0f;
            this.startIndex = 0;
        }
        Collections.sort(this.data, (a, b) -> I18n.m_118938_((String)a.ench.m_44704_(), (Object[])new Object[0]).compareTo(I18n.m_118938_((String)b.ench.m_44704_(), (Object[])new Object[0])));
    }

    private List<Object2IntMap.Entry<Enchantment>> filter(List<Object2IntMap.Entry<Enchantment>> list) {
        return list.stream().filter(this::isAllowedByItem).filter(this::isAllowedBySearch).toList();
    }

    private boolean isAllowedByItem(Object2IntMap.Entry<Enchantment> e) {
        ItemStack stack = ((EnchLibraryContainer)this.f_97732_).ioInv.m_8020_(2);
        return stack.m_41619_() || ((Enchantment)e.getKey()).m_6081_(stack);
    }

    private boolean isAllowedBySearch(Object2IntMap.Entry<Enchantment> e) {
        String name = I18n.m_118938_((String)((Enchantment)e.getKey()).m_44704_(), (Object[])new Object[0]).toLowerCase(Locale.ROOT);
        String search = this.filter == null ? "" : this.filter.m_94155_().trim().toLowerCase(Locale.ROOT);
        return Strings.isNullOrEmpty((String)search) || ChatFormatting.m_126649_((String)name).contains(search);
    }

    @Nullable
    public LibrarySlot getHoveredSlot(int mouseX, int mouseY) {
        for (int i = 0; i < 5; ++i) {
            if (this.startIndex + i >= this.data.size() || !this.m_6774_(21, 31 + i * 20, 113, 18, mouseX, mouseY)) continue;
            return this.data.get(this.startIndex + i);
        }
        return null;
    }

    public static String format(int n) {
        int log = (int)StrictMath.log10(n);
        if (log <= 4) {
            return String.valueOf(n);
        }
        if (log == 5) {
            return f.format((double)n / 1000.0) + "K";
        }
        if (log <= 8) {
            return f.format((double)n / 1000000.0) + "M";
        }
        return f.format((double)n / 1.0E9) + "B";
    }

    private record LibrarySlot(Enchantment ench, int points, int maxLvl) {
    }
}

