/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.apotheosis.adventure.compat;

import dev.shadowsoffire.apotheosis.Apoth;
import dev.shadowsoffire.apotheosis.Apotheosis;
import dev.shadowsoffire.apotheosis.adventure.Adventure;
import dev.shadowsoffire.apotheosis.adventure.AdventureModule;
import dev.shadowsoffire.apotheosis.adventure.affix.AffixHelper;
import dev.shadowsoffire.apotheosis.adventure.affix.salvaging.SalvagingRecipe;
import dev.shadowsoffire.apotheosis.adventure.compat.ApothSmithingCategory;
import dev.shadowsoffire.apotheosis.adventure.compat.GemCuttingCategory;
import dev.shadowsoffire.apotheosis.adventure.compat.SalvagingCategory;
import dev.shadowsoffire.apotheosis.adventure.loot.LootRarity;
import dev.shadowsoffire.apotheosis.adventure.loot.RarityRegistry;
import dev.shadowsoffire.apotheosis.adventure.socket.AddSocketsRecipe;
import dev.shadowsoffire.apotheosis.adventure.socket.ReactiveSmithingRecipe;
import dev.shadowsoffire.apotheosis.adventure.socket.SocketHelper;
import dev.shadowsoffire.apotheosis.adventure.socket.gem.Gem;
import dev.shadowsoffire.apotheosis.adventure.socket.gem.GemInstance;
import dev.shadowsoffire.apotheosis.adventure.socket.gem.GemItem;
import dev.shadowsoffire.apotheosis.adventure.socket.gem.GemRegistry;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.ingredients.subtypes.IIngredientSubtypeInterpreter;
import mezz.jei.api.ingredients.subtypes.UidContext;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import mezz.jei.api.registration.ISubtypeRegistration;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.SmithingRecipe;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.levelgen.LegacyRandomSource;
import net.minecraftforge.registries.ForgeRegistries;

@JeiPlugin
public class AdventureJEIPlugin
implements IModPlugin {
    public static final RecipeType<SmithingRecipe> APO_SMITHING = RecipeType.create((String)"apotheosis", (String)"smithing", AdventureModule.ApothSmithingRecipe.class);
    public static final RecipeType<SalvagingRecipe> SALVAGING = RecipeType.create((String)"apotheosis", (String)"salvaging", SalvagingRecipe.class);
    public static final RecipeType<GemCuttingCategory.GemCuttingRecipe> GEM_CUTTING = RecipeType.create((String)"apotheosis", (String)"gem_cutting", GemCuttingCategory.GemCuttingRecipe.class);
    private static final List<ItemStack> DUMMY_INPUTS = Arrays.asList(Items.f_42430_, Items.f_42390_, Items.f_42428_, Items.f_42469_, Items.f_42713_).stream().map(ItemStack::new).toList();

    public ResourceLocation getPluginUid() {
        return new ResourceLocation("apotheosis", "adventure_module");
    }

    public void registerRecipes(IRecipeRegistration reg) {
        if (!Apotheosis.enableAdventure) {
            return;
        }
        ItemStack gem = new ItemStack((ItemLike)Adventure.Items.GEM.get());
        Gem gemObj = (Gem)GemRegistry.INSTANCE.getRandomItem((RandomSource)new LegacyRandomSource(1854L));
        GemItem.setGem(gem, gemObj);
        AffixHelper.setRarity(gem, gemObj.getMaxRarity());
        reg.addIngredientInfo((Object)gem, (IIngredientType)VanillaTypes.ITEM_STACK, new Component[]{Component.m_237115_((String)"info.apotheosis.socketing")});
        reg.addIngredientInfo((Object)new ItemStack((ItemLike)Adventure.Items.GEM_DUST.get()), (IIngredientType)VanillaTypes.ITEM_STACK, new Component[]{Component.m_237115_((String)"info.apotheosis.gem_crushing")});
        reg.addIngredientInfo((Object)new ItemStack((ItemLike)Adventure.Items.SIGIL_OF_UNNAMING.get()), (IIngredientType)VanillaTypes.ITEM_STACK, new Component[]{Component.m_237115_((String)"info.apotheosis.unnaming")});
        ApothSmithingCategory.registerExtension(AddSocketsRecipe.class, new AddSocketsExtension());
        reg.addRecipes(APO_SMITHING, Minecraft.m_91087_().f_91073_.m_7465_().m_44013_(net.minecraft.world.item.crafting.RecipeType.f_44113_).stream().filter(ReactiveSmithingRecipe.class::isInstance).toList());
        ArrayList<SalvagingRecipe> salvagingRecipes = new ArrayList<SalvagingRecipe>(Minecraft.m_91087_().f_91073_.m_7465_().m_44013_(Apoth.RecipeTypes.SALVAGING));
        salvagingRecipes.sort(Comparator.comparingInt(recipe -> recipe.getOutputs().stream().mapToInt(SalvagingRecipe.OutputData::getMax).max().orElse(0)));
        reg.addRecipes(SALVAGING, salvagingRecipes);
        ArrayList<GemCuttingCategory.GemCuttingRecipe> gemCutRecipes = new ArrayList<GemCuttingCategory.GemCuttingRecipe>();
        for (Gem g : GemRegistry.INSTANCE.getValues()) {
            LootRarity max = (LootRarity)RarityRegistry.getMaxRarity().get();
            for (LootRarity r = (LootRarity)RarityRegistry.getMinRarity().get(); r != max; r = r.next()) {
                if (g.clamp(r) != r) continue;
                gemCutRecipes.add(new GemCuttingCategory.GemCuttingRecipe(g, r));
            }
        }
        reg.addRecipes(GEM_CUTTING, gemCutRecipes);
    }

    public void registerCategories(IRecipeCategoryRegistration reg) {
        if (!Apotheosis.enableAdventure) {
            return;
        }
        reg.addRecipeCategories(new IRecipeCategory[]{new ApothSmithingCategory(reg.getJeiHelpers().getGuiHelper())});
        reg.addRecipeCategories(new IRecipeCategory[]{new SalvagingCategory(reg.getJeiHelpers().getGuiHelper())});
        reg.addRecipeCategories(new IRecipeCategory[]{new GemCuttingCategory(reg.getJeiHelpers().getGuiHelper())});
    }

    public void registerRecipeCatalysts(IRecipeCatalystRegistration reg) {
        if (!Apotheosis.enableAdventure) {
            return;
        }
        reg.addRecipeCatalyst(new ItemStack((ItemLike)Blocks.f_50625_), new RecipeType[]{APO_SMITHING});
        reg.addRecipeCatalyst(new ItemStack((ItemLike)Adventure.Blocks.SALVAGING_TABLE.get()), new RecipeType[]{SALVAGING});
        reg.addRecipeCatalyst(new ItemStack((ItemLike)Adventure.Blocks.GEM_CUTTING_TABLE.get()), new RecipeType[]{GEM_CUTTING});
    }

    public void registerItemSubtypes(ISubtypeRegistration reg) {
        if (!Apotheosis.enableAdventure) {
            return;
        }
        reg.registerSubtypeInterpreter((Item)Adventure.Items.GEM.get(), (IIngredientSubtypeInterpreter)new GemSubtypes());
    }

    static class AddSocketsExtension
    implements ApothSmithingCategory.Extension<AddSocketsRecipe> {
        private static final List<ItemStack> DUMMY_OUTPUTS = DUMMY_INPUTS.stream().map(ItemStack::m_41777_).map(s -> {
            SocketHelper.setSockets(s, 1);
            return s;
        }).toList();

        AddSocketsExtension() {
        }

        @Override
        public void setRecipe(IRecipeLayoutBuilder builder, AddSocketsRecipe recipe, IFocusGroup focuses) {
            builder.addSlot(RecipeIngredientRole.INPUT, 1, 1).addIngredients((IIngredientType)VanillaTypes.ITEM_STACK, DUMMY_INPUTS);
            builder.addSlot(RecipeIngredientRole.INPUT, 50, 1).addIngredients(recipe.getInput());
            builder.addSlot(RecipeIngredientRole.OUTPUT, 108, 1).addItemStacks(DUMMY_OUTPUTS);
        }

        @Override
        public void draw(AddSocketsRecipe recipe, IRecipeSlotsView recipeSlotsView, GuiGraphics gfx, double mouseX, double mouseY) {
            MutableComponent text = Component.m_237110_((String)"text.apotheosis.socket_limit", (Object[])new Object[]{recipe.getMaxSockets()});
            Font font = Minecraft.m_91087_().f_91062_;
            gfx.m_280614_(font, (Component)text, 62 - font.m_92852_((FormattedText)text) / 2, 23, 0, false);
        }
    }

    static class GemSubtypes
    implements IIngredientSubtypeInterpreter<ItemStack> {
        GemSubtypes() {
        }

        public String apply(ItemStack stack, UidContext context) {
            GemInstance inst = GemInstance.unsocketed(stack);
            if (!inst.isValidUnsocketed()) {
                return ForgeRegistries.ITEMS.getKey((Object)stack.m_41720_()).toString();
            }
            return inst.gem().getId() + "@" + inst.rarity().getId();
        }
    }
}

