/*
 * Decompiled with CFR 0.152.
 */
package net.pedroksl.advanced_ae.xmod.emi.recipes;

import appeng.core.AppEng;
import dev.emi.emi.api.recipe.BasicEmiRecipe;
import dev.emi.emi.api.recipe.EmiRecipe;
import dev.emi.emi.api.recipe.EmiRecipeCategory;
import dev.emi.emi.api.render.EmiRenderable;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.api.widget.TextWidget;
import dev.emi.emi.api.widget.WidgetHolder;
import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.material.Fluid;
import net.pedroksl.advanced_ae.common.definitions.AAEBlocks;
import net.pedroksl.advanced_ae.common.definitions.AAEText;
import net.pedroksl.advanced_ae.recipes.IngredientStack;
import net.pedroksl.advanced_ae.recipes.ReactionChamberRecipe;
import net.pedroksl.advanced_ae.xmod.emi.EMIPlugin;
import net.pedroksl.advanced_ae.xmod.emi.recipes.AAEEmiRecipeCategory;

public class EMIReactionChamberRecipe
extends BasicEmiRecipe {
    public static final EmiRecipeCategory CATEGORY = new AAEEmiRecipeCategory("reaction", (EmiRenderable)EmiStack.of(AAEBlocks.REACTION_CHAMBER), (Component)Component.m_237115_((String)AAEText.EmiReactionChamber.getTranslationKey()));
    private final ReactionChamberRecipe recipe;

    public EMIReactionChamberRecipe(ReactionChamberRecipe recipe) {
        super(CATEGORY, recipe.m_6423_(), 168, 80);
        this.recipe = recipe;
        for (IngredientStack.Item in : this.recipe.getInputs()) {
            if (in.isEmpty()) continue;
            this.inputs.add(EMIPlugin.stackOf(in));
        }
        if (this.recipe.getFluid() != null) {
            this.inputs.add(EMIPlugin.stackOf(this.recipe.getFluid()));
        }
        this.outputs.add(EmiStack.of((ItemStack)this.recipe.getResultItem()));
        this.outputs.add(EmiStack.of((Fluid)this.recipe.getResultFluid().getFluid(), (long)this.recipe.getResultFluid().getAmount()));
    }

    public void addWidgets(WidgetHolder widgets) {
        ResourceLocation background = AppEng.makeId((String)"textures/guis/reaction_chamber.png");
        widgets.addTexture(background, 0, 0, 168, 80, 4, 13);
        widgets.addAnimatedTexture(background, 136, 29, 6, 18, 176, 0, 2000, false, true, false);
        TextWidget energyLabel = widgets.addText((Component)AAEText.ReactionChamberEnergy.text(new Object[]{this.recipe.getEnergy() / 1000}), this.width / 2 + 4, 70, AAEText.TOOLTIP_DEFAULT_COLOR.m_126665_().intValue(), false).horizontalAlign(TextWidget.Alignment.CENTER);
        int energyLabelX = energyLabel.getBounds().x();
        int energyLabelY = 72 + energyLabel.getBounds().height() / 2;
        widgets.addTexture(EMIPlugin.TEXTURE, energyLabelX - 16, energyLabelY - 8, 10, 12, 0, 0, 10, 12, 32, 32);
        int index = 0;
        List<IngredientStack.Item> inputs = this.recipe.getInputs();
        for (IngredientStack.Item in : inputs) {
            int x = 37 + index % 3 * 18;
            int y = 10 + index / 3 * 18;
            if (!in.isEmpty()) {
                widgets.addSlot(EMIPlugin.stackOf(in), x, y).drawBack(false);
            }
            ++index;
        }
        if (this.recipe.getFluid() != null) {
            widgets.addTank(EMIPlugin.stackOf(this.recipe.getFluid()), 4, 7, 18, 60, 16000).drawBack(false);
        }
        if (this.recipe.isItemOutput()) {
            widgets.addSlot((EmiIngredient)EmiStack.of((ItemStack)this.recipe.getResultItem()), 113, 29).recipeContext((EmiRecipe)this).drawBack(false);
        } else {
            widgets.addTank((EmiIngredient)EmiStack.of((Fluid)this.recipe.getResultFluid().getFluid()), 146, 7, 18, 60, 16000).recipeContext((EmiRecipe)this).drawBack(false);
        }
    }
}

