/*
 * Decompiled with CFR 0.152.
 */
package net.pedroksl.advanced_ae.network.packet;

import com.glodblock.github.glodium.network.packet.IMessage;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.player.Player;
import net.pedroksl.advanced_ae.client.gui.QuantumCrafterScreen;

public class EnabledPatternsUpdatePacket
implements IMessage<EnabledPatternsUpdatePacket> {
    private List<Boolean> enabledPatterns;

    public EnabledPatternsUpdatePacket() {
    }

    public EnabledPatternsUpdatePacket(List<Boolean> enabledPatterns) {
        this.enabledPatterns = enabledPatterns;
    }

    public void fromBytes(FriendlyByteBuf stream) {
        ArrayList<Boolean> list = new ArrayList<Boolean>();
        int size = stream.readInt();
        for (int x = 0; x < size; ++x) {
            list.add(stream.readBoolean());
        }
        this.enabledPatterns = list;
    }

    public void toBytes(FriendlyByteBuf data) {
        data.writeInt(this.enabledPatterns.size());
        for (Boolean entry : this.enabledPatterns) {
            data.writeBoolean(entry.booleanValue());
        }
    }

    public void onMessage(Player player) {
        Screen screen = Minecraft.m_91087_().f_91080_;
        if (screen instanceof QuantumCrafterScreen) {
            QuantumCrafterScreen screen2 = (QuantumCrafterScreen)screen;
            screen2.updateEnabledButtons(this.enabledPatterns);
        }
    }

    public Class<EnabledPatternsUpdatePacket> getPacketClass() {
        return EnabledPatternsUpdatePacket.class;
    }

    public boolean isClient() {
        return true;
    }
}

