/*
 * Decompiled with CFR 0.152.
 */
package net.pedroksl.advanced_ae.gui.quantumcomputer;

import appeng.api.stacks.AmountFormat;
import appeng.api.stacks.GenericStack;
import appeng.client.Point;
import appeng.client.gui.ICompositeWidget;
import appeng.client.gui.Icon;
import appeng.client.gui.Tooltip;
import appeng.client.gui.style.Blitter;
import appeng.client.gui.style.Color;
import appeng.client.gui.style.PaletteColor;
import appeng.client.gui.style.ScreenStyle;
import appeng.client.gui.widgets.Scrollbar;
import appeng.core.definitions.AEParts;
import appeng.core.localization.ButtonToolTips;
import appeng.core.localization.GuiText;
import appeng.core.localization.Tooltips;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.util.Mth;
import net.minecraft.world.level.ItemLike;
import net.pedroksl.advanced_ae.gui.quantumcomputer.InfoBar;
import net.pedroksl.advanced_ae.gui.quantumcomputer.QuantumComputerMenu;
import org.jetbrains.annotations.Nullable;

public class AdvCpuSelectionList
implements ICompositeWidget {
    private static final int ROWS = 6;
    private final Blitter background;
    private final Blitter buttonBg;
    private final QuantumComputerMenu menu;
    private final Color textColor;
    private final int selectedColor;
    private final Scrollbar scrollbar;
    private Rect2i bounds = new Rect2i(0, 0, 0, 0);

    public AdvCpuSelectionList(QuantumComputerMenu menu, Scrollbar scrollbar, ScreenStyle style) {
        this.menu = menu;
        this.scrollbar = scrollbar;
        this.background = style.getImage("cpuList");
        this.buttonBg = style.getImage("cpuListButton");
        this.textColor = style.getColor(PaletteColor.DEFAULT_TEXT_COLOR);
        this.selectedColor = style.getColor(PaletteColor.SELECTION_COLOR).toARGB();
        this.scrollbar.setCaptureMouseWheel(false);
    }

    public void setPosition(Point position) {
        this.bounds = new Rect2i(position.getX(), position.getY(), this.bounds.m_110090_(), this.bounds.m_110091_());
    }

    public void setSize(int width, int height) {
        this.bounds = new Rect2i(this.bounds.m_110085_(), this.bounds.m_110086_(), width, height);
    }

    public Rect2i getBounds() {
        return this.bounds;
    }

    public boolean onMouseWheel(Point mousePos, double delta) {
        this.scrollbar.onMouseWheel(mousePos, delta);
        return true;
    }

    @Nullable
    public Tooltip getTooltip(int mouseX, int mouseY) {
        QuantumComputerMenu.CraftingCpuListEntry cpu = this.hitTestCpu(new Point(mouseX, mouseY));
        if (cpu != null) {
            GenericStack currentJob;
            MutableComponent modeText;
            ArrayList<Object> tooltipLines = new ArrayList<Object>();
            tooltipLines.add(this.getCpuName(cpu));
            int coProcessors = cpu.coProcessors();
            if (coProcessors == 1) {
                tooltipLines.add(ButtonToolTips.CpuStatusCoProcessor.text(new Object[]{Tooltips.ofNumber((long)coProcessors)}).m_130940_(ChatFormatting.GRAY));
            } else if (coProcessors > 1) {
                tooltipLines.add(ButtonToolTips.CpuStatusCoProcessors.text(new Object[]{Tooltips.ofNumber((long)coProcessors)}).m_130940_(ChatFormatting.GRAY));
            }
            tooltipLines.add(ButtonToolTips.CpuStatusStorage.text(new Object[]{Tooltips.ofBytes((long)cpu.storage())}).m_130940_(ChatFormatting.GRAY));
            switch (cpu.mode()) {
                case PLAYER_ONLY: {
                    MutableComponent mutableComponent = ButtonToolTips.CpuSelectionModePlayersOnly.text();
                    break;
                }
                case MACHINE_ONLY: {
                    MutableComponent mutableComponent = ButtonToolTips.CpuSelectionModeAutomationOnly.text();
                    break;
                }
                default: {
                    MutableComponent mutableComponent = modeText = null;
                }
            }
            if (modeText != null) {
                tooltipLines.add(modeText);
            }
            if ((currentJob = cpu.currentJob()) != null) {
                tooltipLines.add(ButtonToolTips.CpuStatusCrafting.text(new Object[]{Tooltips.ofAmount((GenericStack)currentJob)}).m_130946_(" ").m_7220_(currentJob.what().getDisplayName()));
                tooltipLines.add(ButtonToolTips.CpuStatusCraftedIn.text(new Object[]{Tooltips.ofNumber((long)cpu.progress()), Tooltips.ofDuration((long)cpu.elapsedTimeNanos(), (TimeUnit)TimeUnit.NANOSECONDS)}));
            }
            return new Tooltip(tooltipLines);
        }
        return null;
    }

    public boolean onMouseUp(Point mousePos, int button) {
        QuantumComputerMenu.CraftingCpuListEntry cpu = this.hitTestCpu(mousePos);
        if (cpu != null) {
            this.menu.selectCpu(cpu.serial());
            return true;
        }
        return false;
    }

    @Nullable
    private QuantumComputerMenu.CraftingCpuListEntry hitTestCpu(Point mousePos) {
        int relX = mousePos.getX() - this.bounds.m_110085_();
        int relY = mousePos.getY() - this.bounds.m_110086_();
        if ((relX -= 8) < 0 || relX >= this.buttonBg.getSrcWidth()) {
            return null;
        }
        int buttonIdx = this.scrollbar.getCurrentScroll() + (relY -= 19) / (this.buttonBg.getSrcHeight() + 1);
        if (relY % (this.buttonBg.getSrcHeight() + 1) == this.buttonBg.getSrcHeight()) {
            return null;
        }
        if (relY < 0 || buttonIdx >= this.menu.cpuList.cpus().size()) {
            return null;
        }
        List<QuantumComputerMenu.CraftingCpuListEntry> cpus = this.menu.cpuList.cpus();
        if (buttonIdx >= 0 && buttonIdx < cpus.size()) {
            return cpus.get(buttonIdx);
        }
        return null;
    }

    public void updateBeforeRender() {
        int hiddenRows = Math.max(0, this.menu.cpuList.cpus().size() - 6);
        this.scrollbar.setRange(0, hiddenRows, 2);
    }

    public void drawBackgroundLayer(GuiGraphics guiGraphics, Rect2i bounds, Point mouse) {
        int x = bounds.m_110085_() + this.bounds.m_110085_();
        int y = bounds.m_110086_() + this.bounds.m_110086_();
        this.background.dest(x, y, this.bounds.m_110090_(), this.bounds.m_110091_()).blit(guiGraphics);
        x += 9;
        y += 19;
        PoseStack pose = guiGraphics.m_280168_();
        Font font = Minecraft.m_91087_().f_91062_;
        List<QuantumComputerMenu.CraftingCpuListEntry> cpus = this.menu.cpuList.cpus().subList(Mth.m_14045_((int)this.scrollbar.getCurrentScroll(), (int)0, (int)this.menu.cpuList.cpus().size()), Mth.m_14045_((int)(this.scrollbar.getCurrentScroll() + 6), (int)0, (int)this.menu.cpuList.cpus().size()));
        for (QuantumComputerMenu.CraftingCpuListEntry cpu : cpus) {
            int color = -1;
            if (cpu.serial() == this.menu.getSelectedCpuSerial()) {
                color = this.selectedColor;
            }
            this.buttonBg.dest(x, y).colorRgb(color).blit(guiGraphics);
            Component name = this.getCpuName(cpu);
            pose.m_85836_();
            pose.m_252880_((float)(x + 3), (float)(y + 3), 0.0f);
            pose.m_85841_(0.8f, 0.8f, 1.0f);
            guiGraphics.m_280614_(font, name, 0, 0, this.textColor.toARGB(), false);
            pose.m_85849_();
            InfoBar infoBar = new InfoBar();
            GenericStack currentJob = cpu.currentJob();
            if (currentJob != null) {
                infoBar.add(Icon.CRAFT_HAMMER, 0.6f);
                infoBar.addSpace(2);
                String craftAmt = currentJob.what().formatAmount(currentJob.amount(), AmountFormat.SLOT);
                infoBar.add(craftAmt, this.textColor.toARGB(), 0.6f);
                infoBar.addSpace(1);
                infoBar.add(currentJob.what(), 0.6f);
                int progress = (int)(cpu.progress() * (long)(this.buttonBg.getSrcWidth() - 1) / Math.max(1L, cpu.totalItems()));
                guiGraphics.m_280509_(x + 1, y + this.buttonBg.getSrcHeight() - 2, x + progress, y + this.buttonBg.getSrcHeight() - 1, this.menu.getSelectedCpuSerial() == cpu.serial() ? -1 : -16777216 + this.selectedColor);
            } else {
                infoBar.add(Icon.LEVEL_ITEM, 0.6f);
                infoBar.addSpace(1);
                String storageAmount = this.formatStorage(cpu);
                infoBar.add(storageAmount, this.textColor.toARGB(), 0.6f);
                infoBar.addSpace(1);
                if (cpu.coProcessors() > 0) {
                    infoBar.add(Icon.BLOCKING_MODE_NO, 0.6f);
                    String coProcessorCount = String.valueOf(cpu.coProcessors());
                    infoBar.add(coProcessorCount, this.textColor.toARGB(), 0.6f);
                    infoBar.addSpace(1);
                }
                switch (cpu.mode()) {
                    case PLAYER_ONLY: {
                        infoBar.add((ItemLike)AEParts.TERMINAL, 0.6f);
                        break;
                    }
                    case MACHINE_ONLY: {
                        infoBar.add((ItemLike)AEParts.EXPORT_BUS, 0.6f);
                    }
                }
            }
            infoBar.render(guiGraphics, x + 2, y + this.buttonBg.getSrcHeight() - 12);
            y += this.buttonBg.getSrcHeight() + 1;
        }
    }

    private String formatStorage(QuantumComputerMenu.CraftingCpuListEntry cpu) {
        long storage = cpu.storage();
        int unit = -1;
        while (storage > 1024L) {
            storage /= 1024L;
            ++unit;
        }
        return storage + (switch (unit) {
            case 0 -> "k";
            case 1 -> "M";
            case 2 -> "G";
            default -> "T";
        });
    }

    private Component getCpuName(QuantumComputerMenu.CraftingCpuListEntry cpu) {
        return cpu.name() != null ? cpu.name() : GuiText.CPUs.text().m_130946_(String.format(" #%d", cpu.serial()));
    }
}

