/*
 * Decompiled with CFR 0.152.
 */
package net.pedroksl.advanced_ae.gui;

import appeng.api.stacks.AEKey;
import appeng.menu.AEBaseMenu;
import appeng.menu.ISubMenu;
import appeng.menu.MenuOpener;
import appeng.menu.locator.MenuLocator;
import com.mojang.datafixers.util.Pair;
import java.util.LinkedHashMap;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.level.Level;
import net.pedroksl.advanced_ae.common.definitions.AAEMenus;
import net.pedroksl.advanced_ae.common.entities.QuantumCrafterEntity;
import net.pedroksl.advanced_ae.network.AAENetworkHandler;
import net.pedroksl.advanced_ae.network.packet.PatternConfigServerUpdatePacket;

public class QuantumCrafterConfigPatternMenu
extends AEBaseMenu
implements ISubMenu {
    private int index;
    private final QuantumCrafterEntity host;
    private final String SET_MAX_CRAFTED = "set_max_crafted";
    public LinkedHashMap<AEKey, Long> inputs = new LinkedHashMap();
    public Pair<AEKey, Long> output;

    public QuantumCrafterConfigPatternMenu(int id, Inventory ip, QuantumCrafterEntity host) {
        this(AAEMenus.CRAFTER_PATTERN_CONFIG, id, ip, host);
    }

    protected QuantumCrafterConfigPatternMenu(MenuType<? extends QuantumCrafterConfigPatternMenu> type, int id, Inventory ip, QuantumCrafterEntity host) {
        super(type, id, ip, (Object)host);
        this.host = host;
        this.registerClientAction("set_max_crafted", Long.class, this::setMaxCrafted);
    }

    public QuantumCrafterEntity getHost() {
        return this.host;
    }

    public static void open(ServerPlayer player, MenuLocator locator, int index, LinkedHashMap<AEKey, Long> inputs, Pair<AEKey, Long> output) {
        MenuOpener.open(AAEMenus.CRAFTER_PATTERN_CONFIG, (Player)player, (MenuLocator)locator);
        AbstractContainerMenu abstractContainerMenu = player.f_36096_;
        if (abstractContainerMenu instanceof QuantumCrafterConfigPatternMenu) {
            QuantumCrafterConfigPatternMenu cca = (QuantumCrafterConfigPatternMenu)abstractContainerMenu;
            cca.setIndex(index);
            cca.setInputsAndOutput(inputs, output);
            cca.m_38946_();
        }
    }

    private void setIndex(int index) {
        this.index = index;
    }

    private void setInputsAndOutput(LinkedHashMap<AEKey, Long> inputs, Pair<AEKey, Long> output) {
        Player player;
        this.inputs = new LinkedHashMap<AEKey, Long>(inputs);
        this.output = new Pair((Object)((AEKey)output.getFirst()), (Object)((Long)output.getSecond()));
        if (this.isServerSide() && this.inputs != null && this.output != null && (player = this.getPlayer()) instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            AAENetworkHandler.INSTANCE.sendTo(new PatternConfigServerUpdatePacket(this.inputs, this.output), player2);
        }
    }

    public Level getLevel() {
        return this.getPlayerInventory().f_35978_.m_9236_();
    }

    public void setStockAmount(int inputIndex, long amount) {
        this.getHost().setStockAmount(this.index, inputIndex, amount);
        this.setInputsAndOutput(this.getHost().getPatternConfigInputs(this.index), this.getHost().getPatternConfigOutput(this.index));
    }

    public void setMaxCrafted(long amount) {
        if (this.isClientSide()) {
            this.sendClientAction("set_max_crafted", amount);
            return;
        }
        this.getHost().setMaxCrafted(this.index, amount);
        this.setInputsAndOutput(this.getHost().getPatternConfigInputs(this.index), this.getHost().getPatternConfigOutput(this.index));
    }
}

