/*
 * Decompiled with CFR 0.152.
 */
package net.pedroksl.advanced_ae.common.logic;

import net.minecraft.nbt.CompoundTag;

public class ElapsedTimeTracker {
    private static final String NBT_ELAPSED_TIME = "elapsedTime";
    private static final String NBT_START_ITEM_COUNT = "startItemCount";
    private static final String NBT_REMAINING_ITEM_COUNT = "remainingItemCount";
    private long lastTime = System.nanoTime();
    private long elapsedTime = 0L;
    private long startItemCount;
    private long remainingItemCount;

    public ElapsedTimeTracker(long startItemCount) {
        this.startItemCount = startItemCount;
        this.remainingItemCount = startItemCount;
    }

    public ElapsedTimeTracker(CompoundTag data) {
        this.elapsedTime = data.m_128454_(NBT_ELAPSED_TIME);
        this.startItemCount = data.m_128454_(NBT_START_ITEM_COUNT);
        this.remainingItemCount = data.m_128454_(NBT_REMAINING_ITEM_COUNT);
    }

    public CompoundTag writeToNBT() {
        CompoundTag data = new CompoundTag();
        data.m_128356_(NBT_ELAPSED_TIME, this.elapsedTime);
        data.m_128356_(NBT_START_ITEM_COUNT, this.startItemCount);
        data.m_128356_(NBT_REMAINING_ITEM_COUNT, this.remainingItemCount);
        return data;
    }

    private void updateTime() {
        long currentTime = System.nanoTime();
        this.elapsedTime += currentTime - this.lastTime;
        this.lastTime = currentTime;
    }

    void decrementItems(long itemDiff) {
        this.updateTime();
        this.remainingItemCount -= itemDiff;
    }

    void addMaxItems(long itemDiff) {
        this.updateTime();
        this.startItemCount += itemDiff;
        this.remainingItemCount += itemDiff;
    }

    public long getElapsedTime() {
        if (this.remainingItemCount > 0L) {
            return this.elapsedTime + (System.nanoTime() - this.lastTime);
        }
        return this.elapsedTime;
    }

    public long getRemainingItemCount() {
        return this.remainingItemCount;
    }

    public long getStartItemCount() {
        return this.startItemCount;
    }
}

