/*
 * Decompiled with CFR 0.152.
 */
package net.pedroksl.advanced_ae.common.entities;

import appeng.api.config.Actionable;
import appeng.api.config.PowerMultiplier;
import appeng.api.config.RedstoneMode;
import appeng.api.config.Settings;
import appeng.api.config.YesNo;
import appeng.api.crafting.IPatternDetails;
import appeng.api.crafting.PatternDetailsHelper;
import appeng.api.inventories.ISegmentedInventory;
import appeng.api.inventories.InternalInventory;
import appeng.api.inventories.ItemTransfer;
import appeng.api.networking.GridFlags;
import appeng.api.networking.IGrid;
import appeng.api.networking.IGridNode;
import appeng.api.networking.IGridNodeListener;
import appeng.api.networking.IGridNodeService;
import appeng.api.networking.energy.IEnergyService;
import appeng.api.networking.energy.IEnergySource;
import appeng.api.networking.security.IActionHost;
import appeng.api.networking.security.IActionSource;
import appeng.api.networking.storage.IStorageService;
import appeng.api.networking.ticking.IGridTickable;
import appeng.api.networking.ticking.TickRateModulation;
import appeng.api.networking.ticking.TickingRequest;
import appeng.api.orientation.BlockOrientation;
import appeng.api.orientation.RelativeSide;
import appeng.api.stacks.AEFluidKey;
import appeng.api.stacks.AEItemKey;
import appeng.api.stacks.AEKey;
import appeng.api.stacks.GenericStack;
import appeng.api.storage.MEStorage;
import appeng.api.storage.StorageHelper;
import appeng.api.upgrades.IUpgradeInventory;
import appeng.api.upgrades.IUpgradeableObject;
import appeng.api.upgrades.UpgradeInventories;
import appeng.api.util.AECableType;
import appeng.api.util.IConfigManager;
import appeng.api.util.IConfigurableObject;
import appeng.blockentity.grid.AENetworkPowerBlockEntity;
import appeng.core.AELog;
import appeng.core.definitions.AEItems;
import appeng.core.localization.PlayerMessages;
import appeng.crafting.pattern.AECraftingPattern;
import appeng.me.helpers.MachineSource;
import appeng.menu.AutoCraftingMenu;
import appeng.menu.ISubMenu;
import appeng.menu.MenuOpener;
import appeng.menu.locator.MenuLocator;
import appeng.menu.locator.MenuLocators;
import appeng.util.ConfigManager;
import appeng.util.SettingsFrom;
import appeng.util.inv.AppEngInternalInventory;
import appeng.util.inv.CombinedInternalInventory;
import appeng.util.inv.FilteredInternalInventory;
import appeng.util.inv.InternalInventoryHost;
import appeng.util.inv.PlayerInternalInventory;
import appeng.util.inv.filter.AEItemFilters;
import appeng.util.inv.filter.IAEItemFilter;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.ByteTag;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.IntArrayTag;
import net.minecraft.nbt.IntTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.LongTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.inventory.TransientCraftingContainer;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.pedroksl.advanced_ae.api.AAESettings;
import net.pedroksl.advanced_ae.api.IDirectionalOutputHost;
import net.pedroksl.advanced_ae.common.blocks.QuantumCrafterBlock;
import net.pedroksl.advanced_ae.common.definitions.AAEBlocks;
import net.pedroksl.advanced_ae.common.definitions.AAEMenus;
import org.jetbrains.annotations.Nullable;

public class QuantumCrafterEntity
extends AENetworkPowerBlockEntity
implements IGridTickable,
IUpgradeableObject,
IConfigurableObject,
IDirectionalOutputHost {
    private static final int MAX_POWER_STORAGE = 8000;
    private static final int MAX_CRAFT_AMOUNT = 1024;
    private static final int MAX_OUTPUT_INV_SIZE = 1024;
    public static final String NBT_SEND_LIST = "sendList";
    public static final String NBT_MEMORY_CARD_PATTERNS = "patterns";
    public static final String NBT_ALLOWED_SIDES = "allowedSides";
    private final IUpgradeInventory upgrades;
    private final IConfigManager configManager = new ConfigManager(() -> ((QuantumCrafterEntity)this).saveChanges());
    private final AppEngInternalInventory patternInv = new AppEngInternalInventory((InternalInventoryHost)this, 9, 1);
    private final AppEngInternalInventory outputInv = new AppEngInternalInventory((InternalInventoryHost)this, 18, 1024);
    private final InternalInventory inv = new CombinedInternalInventory(new InternalInventory[]{this.patternInv, this.outputInv});
    private final FilteredInternalInventory inputExposed = new FilteredInternalInventory((InternalInventory)this.patternInv, (IAEItemFilter)new PatternOnlyFilter());
    private final FilteredInternalInventory outputExposed = new FilteredInternalInventory((InternalInventory)this.outputInv, AEItemFilters.EXTRACT_ONLY);
    private final InternalInventory invExposed = new CombinedInternalInventory(new InternalInventory[]{this.inputExposed, this.outputExposed});
    private boolean initialized = false;
    private boolean working = false;
    private YesNo lastRedstoneState;
    private final List<GenericStack> sendList = new ArrayList<GenericStack>();
    private final IActionSource mySrc;
    private boolean isActive = false;
    private final CraftingContainer testFrame;
    private final List<CraftingJob> craftingJobs = Arrays.asList(new CraftingJob[9]);
    private EnumSet<RelativeSide> allowedOutputs = EnumSet.allOf(RelativeSide.class);
    private final List<Boolean> enabledPatternSlots = Arrays.asList(new Boolean[9]);

    public QuantumCrafterEntity(BlockEntityType<?> type, BlockPos pos, BlockState blockState) {
        super(type, pos, blockState);
        this.getMainNode().setFlags(new GridFlags[]{GridFlags.REQUIRE_CHANNEL}).setIdlePowerUsage(0.0).addService(IGridTickable.class, (IGridNodeService)this);
        this.setInternalMaxPower(8000.0);
        this.upgrades = UpgradeInventories.forMachine(AAEBlocks.QUANTUM_CRAFTER, (int)5, () -> ((QuantumCrafterEntity)this).saveChanges());
        this.configManager.registerSetting(AAESettings.ME_EXPORT, (Enum)YesNo.YES);
        this.configManager.registerSetting(Settings.REDSTONE_CONTROLLED, (Enum)RedstoneMode.IGNORE);
        this.setPowerSides(this.getGridConnectableSides(this.getOrientation()));
        this.mySrc = new MachineSource((IActionHost)this);
        this.lastRedstoneState = YesNo.UNDECIDED;
        this.testFrame = new TransientCraftingContainer((AbstractContainerMenu)new AutoCraftingMenu(), 3, 3);
        Collections.fill(this.enabledPatternSlots, false);
    }

    public boolean isWorking() {
        return this.working;
    }

    public void setWorking(boolean working) {
        if (working != this.working) {
            this.updateBlockState(working);
            this.markForUpdate();
        }
        this.working = working;
    }

    private void updateBlockState(boolean working) {
        BlockState newState;
        if (this.f_58857_ == null || this.notLoaded() || this.m_58901_()) {
            return;
        }
        BlockState current = this.f_58857_.m_8055_(this.f_58858_);
        if (current != (newState = (BlockState)current.m_61124_((Property)QuantumCrafterBlock.WORKING, (Comparable)Boolean.valueOf(working)))) {
            this.f_58857_.m_7731_(this.f_58858_, newState, 2);
        }
    }

    protected void saveVisualState(CompoundTag data) {
        super.saveVisualState(data);
        data.m_128379_("working", this.isWorking());
    }

    protected void loadVisualState(CompoundTag data) {
        super.loadVisualState(data);
        this.setWorking(data.m_128471_("working"));
    }

    public Set<Direction> getGridConnectableSides(BlockOrientation orientation) {
        return EnumSet.allOf(Direction.class);
    }

    public InternalInventory getPatternInventory() {
        return this.patternInv;
    }

    public InternalInventory getOutputInv() {
        return this.outputInv;
    }

    public InternalInventory getInternalInventory() {
        return this.inv;
    }

    @Nullable
    public InternalInventory getSubInventory(ResourceLocation id) {
        if (id.equals((Object)ISegmentedInventory.STORAGE)) {
            return this.getInternalInventory();
        }
        if (id.equals((Object)ISegmentedInventory.UPGRADES)) {
            return this.upgrades;
        }
        return super.getSubInventory(id);
    }

    protected InternalInventory getExposedInventoryForSide(Direction facing) {
        return this.invExposed;
    }

    public IUpgradeInventory getUpgrades() {
        return this.upgrades;
    }

    public void onChangeInventory(InternalInventory inv, int slot) {
        if (inv == this.patternInv) {
            this.makeCraftingRecipeList();
        }
        this.getMainNode().ifPresent((grid, node) -> grid.getTickManager().wakeDevice(node));
    }

    private void makeCraftingRecipeList() {
        for (int x = 0; x < this.patternInv.size(); ++x) {
            IPatternDetails details;
            boolean success = false;
            ItemStack is = this.patternInv.getStackInSlot(x);
            if (!is.m_41619_() && (details = PatternDetailsHelper.decodePattern((ItemStack)is, (Level)this.m_58904_())) instanceof AECraftingPattern) {
                AECraftingPattern craftPattern = (AECraftingPattern)details;
                if (this.craftingJobs.get(x) != null) {
                    if (this.craftingJobs.get((int)x).pattern != null) continue;
                    this.craftingJobs.get(x).setPattern(craftPattern);
                    continue;
                }
                this.craftingJobs.set(x, new CraftingJob(craftPattern));
                success = true;
            }
            if (success) continue;
            this.craftingJobs.set(x, null);
        }
    }

    private boolean hasAutoExportWork() {
        if (!this.sendList.isEmpty()) {
            return true;
        }
        for (int x = 0; x < this.outputInv.size(); ++x) {
            if (this.outputInv.getStackInSlot(x).m_41619_()) continue;
            return true;
        }
        return false;
    }

    private boolean isExportToMe() {
        return this.configManager.getSetting(AAESettings.ME_EXPORT) == YesNo.YES;
    }

    private boolean hasWork() {
        if (!this.initialized) {
            this.makeCraftingRecipeList();
            this.initialized = true;
        }
        if (this.isEnabled()) {
            return !this.patternInv.isEmpty();
        }
        this.setWorking(false);
        return false;
    }

    private boolean hasCraftWork() {
        if (!this.initialized) {
            this.makeCraftingRecipeList();
            this.initialized = true;
        }
        if (!this.isEnabled()) {
            return false;
        }
        for (int x = 0; x < this.craftingJobs.size(); ++x) {
            CraftingJob job = this.craftingJobs.get(x);
            if (job == null || job.pattern == null || !this.enabledPatternSlots.get(x).booleanValue() || this.maximumCraftableAmount(job) <= 0 || !this.hasAvailableOutputStorage(job)) continue;
            return true;
        }
        return false;
    }

    private int maximumCraftableAmount(CraftingJob job) {
        if (this.getGridNode() == null) {
            return 0;
        }
        if (job == null || job.pattern == null) {
            return 0;
        }
        IPatternDetails.IInput[] inputs = job.pattern.getInputs();
        GenericStack[] outputs = job.pattern.getOutputs();
        IGrid grid = this.getGridNode().getGrid();
        int totalCrafts = 1024;
        for (IPatternDetails.IInput input : inputs) {
            long minStock = job.minimumInputToKeep(input);
            boolean success = false;
            for (GenericStack genInput : input.getPossibleInputs()) {
                long inputAmount = input.getMultiplier() * genInput.amount();
                long toExtract = job.requiredInputTotal(genInput, totalCrafts);
                if (job.isInputConsumed(genInput)) {
                    toExtract += minStock;
                }
                long extracted = grid.getStorageService().getInventory().extract(genInput.what(), toExtract, Actionable.SIMULATE, this.mySrc);
                if (!job.isInputConsumed(genInput) && extracted >= toExtract) {
                    success = true;
                    break;
                }
                if (extracted <= minStock) continue;
                success = true;
                if (extracted > Integer.MAX_VALUE) {
                    extracted = Integer.MAX_VALUE;
                }
                int possibleCrafts = (int)Math.floor((double)(extracted - minStock) / (double)inputAmount);
                totalCrafts = Math.min(possibleCrafts, totalCrafts);
                break;
            }
            if (success) continue;
            return 0;
        }
        GenericStack output = outputs[0];
        long maxStock = job.limitMaxOutput;
        if (maxStock > 0L) {
            long extracted = grid.getStorageService().getInventory().extract(output.what(), maxStock, Actionable.SIMULATE, this.mySrc);
            int amountInOutput = 0;
            for (int x = 0; x < this.outputInv.size(); ++x) {
                ItemStack stack = this.outputInv.getStackInSlot(x);
                if (!stack.m_150930_(output.what().wrapForDisplayOrFilter().m_41720_())) continue;
                amountInOutput += stack.m_41613_();
            }
            long producedAmount = job.outputAmountPerCraft(output);
            int limitByOutput = (int)Math.floor((double)(maxStock - extracted - (long)amountInOutput) / (double)producedAmount);
            totalCrafts = Math.max(0, Math.min(totalCrafts, limitByOutput));
            if (extracted <= maxStock) {
                return totalCrafts;
            }
            return (int)Math.floor((double)extracted / (double)output.amount());
        }
        return totalCrafts;
    }

    private boolean hasAvailableOutputStorage(CraftingJob job) {
        for (GenericStack output : job.pattern.getOutputs()) {
            AEKey aEKey = output.what();
            if (!(aEKey instanceof AEItemKey)) continue;
            AEItemKey key = (AEItemKey)aEKey;
            ItemStack stack = key.toStack();
            for (int x = 0; x < this.outputInv.size() && !(stack = this.outputInv.insertItem(x, stack, true)).m_41619_(); ++x) {
            }
            if (stack.m_41619_()) continue;
            return false;
        }
        return true;
    }

    public TickingRequest getTickingRequest(IGridNode iGridNode) {
        return new TickingRequest(1, 20, !this.hasWork(), true);
    }

    public TickRateModulation tickingRequest(IGridNode iGridNode, int i) {
        if (!this.getMainNode().isActive()) {
            this.setWorking(false);
            return TickRateModulation.IDLE;
        }
        if (this.hasCraftWork()) {
            int speedFactor = switch (this.upgrades.getInstalledUpgrades((ItemLike)AEItems.SPEED_CARD)) {
                default -> 1;
                case 1 -> 8;
                case 2 -> 16;
                case 3 -> 32;
                case 4 -> 64;
            };
            this.setWorking(true);
            this.getMainNode().ifPresent(grid -> {
                IEnergyService eg = grid.getEnergyService();
                QuantumCrafterEntity src = this;
                int powerConsumption = 10 * speedFactor;
                double powerThreshold = (double)powerConsumption - 0.01;
                double powerReq = this.extractAEPower(powerConsumption, Actionable.SIMULATE, PowerMultiplier.CONFIG);
                if (powerReq <= powerThreshold) {
                    src = eg;
                    powerReq = eg.extractAEPower((double)powerConsumption, Actionable.SIMULATE, PowerMultiplier.CONFIG);
                }
                if (powerReq > powerThreshold) {
                    src.extractAEPower(powerConsumption, Actionable.MODULATE, PowerMultiplier.CONFIG);
                    this.performCrafts(speedFactor);
                }
            });
        } else {
            this.setWorking(false);
        }
        if (this.pushOutResult()) {
            return TickRateModulation.URGENT;
        }
        return this.hasCraftWork() ? TickRateModulation.URGENT : (this.hasAutoExportWork() ? TickRateModulation.SLOWER : TickRateModulation.IDLE);
    }

    private void performCrafts(int maxCrafts) {
        for (int x = 0; x < this.craftingJobs.size(); ++x) {
            CraftingJob job = this.getNextJob(x);
            if (job == null || !this.enabledPatternSlots.get(x).booleanValue()) continue;
            int craftAmount = this.maximumCraftableAmount(job);
            int toCraft = Math.min(craftAmount, maxCrafts);
            this.performCraft(job, toCraft);
        }
    }

    private void performCraft(CraftingJob job, int toCraft) {
        if (this.getGridNode() == null) {
            return;
        }
        if (job == null || job.pattern == null) {
            return;
        }
        IPatternDetails.IInput[] inputs = job.pattern.getInputs();
        GenericStack[] outputs = job.pattern.getOutputs();
        ArrayList<Long> requiredPerCraft = new ArrayList<Long>();
        ArrayList<GenericStack> extractedItems = new ArrayList<GenericStack>();
        IGrid grid = this.getGridNode().getGrid();
        IEnergyService energy = grid.getEnergyService();
        IStorageService storage = grid.getStorageService();
        block0: for (IPatternDetails.IInput input : inputs) {
            for (GenericStack genInput : input.getPossibleInputs()) {
                long inputAmount = input.getMultiplier() * genInput.amount();
                long toExtract = job.requiredInputTotal(genInput, toCraft);
                long extracted = StorageHelper.poweredExtraction((IEnergySource)energy, (MEStorage)storage.getInventory(), (AEKey)genInput.what(), (long)toExtract, (IActionSource)this.mySrc);
                if (extracted < inputAmount) continue;
                requiredPerCraft.add(inputAmount);
                extractedItems.add(new GenericStack(genInput.what(), extracted));
                continue block0;
            }
        }
        int completeRecipes = extractedItems.size() == inputs.length ? toCraft : 0;
        for (int x = 0; x < extractedItems.size(); ++x) {
            if (!job.isInputConsumed((GenericStack)extractedItems.get(x))) continue;
            Long required = (Long)requiredPerCraft.get(x);
            long extracted = ((GenericStack)extractedItems.get(x)).amount();
            int recipes = (int)(extracted / required);
            completeRecipes = Math.min(completeRecipes, recipes);
        }
        for (GenericStack output : outputs) {
            AEKey aEKey = output.what();
            if (!(aEKey instanceof AEItemKey)) continue;
            AEItemKey key = (AEItemKey)aEKey;
            ItemStack stack = key.toStack();
            stack.m_41764_((int)job.outputAmountPerCraft(output) * completeRecipes);
            for (int x = 0; x < this.outputInv.size() && !(stack = this.outputInv.insertItem(x, stack, Actionable.MODULATE.isSimulate())).m_41619_(); ++x) {
            }
        }
        for (ItemStack stack : job.remainingItems) {
            ItemStack newStack = stack.m_41777_();
            if (job.isStackAnInput(stack)) continue;
            newStack.m_41764_(stack.m_41613_() * completeRecipes);
            for (int x = 0; x < this.outputInv.size() && !(newStack = this.outputInv.insertItem(x, newStack, Actionable.MODULATE.isSimulate())).m_41619_(); ++x) {
            }
        }
        for (int x = 0; x < extractedItems.size(); ++x) {
            long successfulReturn;
            Long required = (Long)requiredPerCraft.get(x);
            GenericStack input = (GenericStack)extractedItems.get(x);
            long toReturn = input.amount();
            if (job.isInputConsumed(input)) {
                toReturn -= required * (long)completeRecipes;
            }
            if ((successfulReturn = storage.getInventory().insert(((GenericStack)extractedItems.get(x)).what(), toReturn, Actionable.MODULATE, this.mySrc)) >= toReturn) continue;
            this.sendList.add(new GenericStack(input.what(), toReturn - successfulReturn));
        }
    }

    @Nullable
    private CraftingJob getNextJob(int jobIndex) {
        try {
            CraftingJob job = this.craftingJobs.get(jobIndex);
            return job == null || job.pattern == null ? null : job;
        }
        catch (IndexOutOfBoundsException e) {
            return null;
        }
    }

    private void addToSendList(AEKey what, long amount) {
        if (amount > 0L) {
            this.sendList.add(new GenericStack(what, amount));
            this.getMainNode().ifPresent((grid, node) -> grid.getTickManager().alertDevice(node));
        }
    }

    private boolean pushOutResult() {
        if (!this.hasAutoExportWork()) {
            return false;
        }
        boolean didSomething = false;
        if (!this.sendList.isEmpty()) {
            didSomething = this.exportSendList();
        }
        if (this.isExportToMe()) {
            return didSomething || this.exportToMe();
        }
        return didSomething || this.exportToAdjacentBlocks();
    }

    private boolean exportSendList() {
        if (this.getGridNode() == null) {
            return false;
        }
        IGrid grid = this.getGridNode().getGrid();
        IStorageService storage = grid.getStorageService();
        boolean didSomething = false;
        ListIterator<GenericStack> it = this.sendList.listIterator();
        while (it.hasNext()) {
            GenericStack stack = it.next();
            AEKey what = stack.what();
            long amount = stack.amount();
            long inserted = storage.getInventory().insert(what, amount, Actionable.MODULATE, this.mySrc);
            if (inserted >= amount) {
                it.remove();
                didSomething = true;
                continue;
            }
            if (inserted <= 0L) continue;
            it.set(new GenericStack(what, amount - inserted));
            didSomething = true;
        }
        return didSomething;
    }

    private boolean exportToMe() {
        if (this.getGridNode() == null) {
            return false;
        }
        IStorageService storage = this.getGridNode().getGrid().getStorageService();
        IEnergyService energy = this.getGridNode().getGrid().getEnergyService();
        MEStorage inventory = storage.getInventory();
        boolean success = false;
        for (int x = 0; x < this.outputInv.size(); ++x) {
            ItemStack extractStack = this.outputInv.extractItem(x, 1024, false);
            AEItemKey key = AEItemKey.of((ItemStack)extractStack);
            if (key == null) continue;
            long inserted = StorageHelper.poweredInsert((IEnergySource)energy, (MEStorage)inventory, (AEKey)key, (long)extractStack.m_41613_(), (IActionSource)this.mySrc);
            extractStack.m_41764_(extractStack.m_41613_() - (int)inserted);
            this.outputInv.insertItem(x, extractStack, false);
            if (inserted <= 0L) continue;
            success = true;
        }
        return success;
    }

    private boolean exportToAdjacentBlocks() {
        if (this.f_58857_ == null) {
            return false;
        }
        BlockOrientation orientation = this.getOrientation();
        ArrayList<ItemTransfer> invMap = new ArrayList<ItemTransfer>();
        for (RelativeSide side : this.allowedOutputs) {
            Direction dir = orientation.getSide(side);
            ItemTransfer target = InternalInventory.wrapExternal((Level)this.f_58857_, (BlockPos)this.m_58899_().m_121945_(dir), (Direction)dir.m_122424_());
            if (target == null) continue;
            invMap.add(target);
        }
        boolean success = false;
        for (int x = 0; x < this.outputInv.size(); ++x) {
            int endItems;
            int startItems = this.outputInv.getStackInSlot(x).m_41613_();
            for (ItemTransfer target : invMap) {
                this.outputInv.insertItem(x, target.addItems(this.outputInv.extractItem(x, 1024, false)), false);
                if (this.outputInv.getStackInSlot(x).m_41613_() != 0) continue;
                break;
            }
            if (startItems == (endItems = this.outputInv.getStackInSlot(x).m_41613_())) continue;
            success = true;
        }
        return success;
    }

    public IConfigManager getConfigManager() {
        return this.configManager;
    }

    public void addAdditionalDrops(Level level, BlockPos pos, List<ItemStack> drops) {
        super.addAdditionalDrops(level, pos, drops);
        for (ItemStack upgrade : this.upgrades) {
            drops.add(upgrade);
        }
    }

    public AECableType getCableConnectionType(Direction dir) {
        return AECableType.SMART;
    }

    public void m_183515_(CompoundTag data) {
        super.m_183515_(data);
        ListTag outputTags = new ListTag();
        for (RelativeSide relativeSide : this.allowedOutputs) {
            outputTags.add((Object)StringTag.m_129297_((String)relativeSide.name()));
        }
        data.m_128365_("outputSides", (Tag)outputTags);
        ListTag enabledTags = new ListTag();
        for (Boolean value : this.enabledPatternSlots) {
            enabledTags.add((Object)ByteTag.m_128273_((boolean)value));
        }
        data.m_128365_("enabledPatterns", (Tag)enabledTags);
        ListTag listTag = this.makeJobsTag();
        if (listTag != null) {
            data.m_128365_("craftingJobs", (Tag)listTag);
        }
        this.upgrades.writeToNBT(data, "upgrades");
        this.configManager.writeToNBT(data);
        ListTag sendListTag = new ListTag();
        for (GenericStack toSend : this.sendList) {
            sendListTag.add((Object)GenericStack.writeTag((GenericStack)toSend));
        }
        data.m_128365_(NBT_SEND_LIST, (Tag)sendListTag);
    }

    public void loadTag(CompoundTag data) {
        ListTag enabledTags;
        super.loadTag(data);
        this.allowedOutputs.clear();
        ListTag outputTags = data.m_128437_("outputSides", 8);
        if (!outputTags.isEmpty()) {
            for (int x = 0; x < outputTags.size(); ++x) {
                RelativeSide side = Enum.valueOf(RelativeSide.class, outputTags.m_128778_(x));
                this.allowedOutputs.add(side);
            }
        }
        if (!(enabledTags = data.m_128437_("enabledPatterns", 1)).isEmpty()) {
            for (int x = 0; x < this.enabledPatternSlots.size(); ++x) {
                this.enabledPatternSlots.set(x, ((ByteTag)enabledTags.get(x)).m_7063_() > 0);
            }
        }
        if (data.m_128441_("craftingJobs")) {
            this.readJobs(data);
        }
        this.upgrades.readFromNBT(data, "upgrades");
        this.configManager.readFromNBT(data);
        ListTag sendListTag = data.m_128437_(NBT_SEND_LIST, 10);
        for (int i = 0; i < sendListTag.size(); ++i) {
            GenericStack stack = GenericStack.readTag((CompoundTag)sendListTag.m_128728_(i));
            if (stack == null) continue;
            this.addToSendList(stack.what(), stack.amount());
        }
    }

    public ListTag makeJobsTag() {
        try {
            ListTag jobTags = new ListTag();
            for (CraftingJob job : this.craftingJobs) {
                CompoundTag tag = new CompoundTag();
                if (job != null) {
                    job.writeToNBT(tag);
                    jobTags.add((Object)tag);
                    continue;
                }
                jobTags.add((Object)tag);
            }
            return jobTags;
        }
        catch (NullPointerException ignored) {
            return null;
        }
    }

    private void readJobs(CompoundTag data) {
        ListTag jobTags = data.m_128437_("craftingJobs", 10);
        if (!jobTags.isEmpty()) {
            for (int x = 0; x < jobTags.size(); ++x) {
                CompoundTag tag = (CompoundTag)jobTags.get(x);
                if (tag.m_128456_()) continue;
                this.craftingJobs.set(x, CraftingJob.fromTag(tag));
            }
        }
    }

    protected boolean readFromStream(FriendlyByteBuf data) {
        boolean c = super.readFromStream(data);
        this.setWorking(data.readBoolean());
        boolean isActive = data.readBoolean();
        c = isActive != this.isActive || c;
        this.isActive = isActive;
        return c;
    }

    protected void writeToStream(FriendlyByteBuf data) {
        super.writeToStream(data);
        data.writeBoolean(this.isWorking());
        data.writeBoolean(this.isActive());
    }

    public void exportSettings(SettingsFrom mode, CompoundTag output, @Nullable Player player) {
        super.exportSettings(mode, output, player);
        if (mode == SettingsFrom.MEMORY_CARD) {
            EnumSet<RelativeSide> outputs = this.getAllowedOutputs();
            IntArrayTag sides = new IntArrayTag(outputs.stream().map(o -> o.getUnrotatedSide().m_122411_()).toList());
            output.m_128365_(NBT_ALLOWED_SIDES, (Tag)sides);
            this.patternInv.writeToNBT(output, NBT_MEMORY_CARD_PATTERNS);
        }
    }

    public void importSettings(SettingsFrom mode, CompoundTag input, @Nullable Player player) {
        super.importSettings(mode, input, player);
        if (mode == SettingsFrom.MEMORY_CARD && input.m_128441_(NBT_MEMORY_CARD_PATTERNS)) {
            Tag tag = input.m_128423_(NBT_ALLOWED_SIDES);
            if (tag instanceof IntArrayTag) {
                BlockEntity be;
                IntArrayTag list = (IntArrayTag)tag;
                Level level = this.m_58904_();
                if (level != null && (be = level.m_7702_(this.m_58899_())) instanceof IDirectionalOutputHost) {
                    IDirectionalOutputHost host = (IDirectionalOutputHost)be;
                    EnumSet<RelativeSide> outputs = EnumSet.noneOf(RelativeSide.class);
                    for (IntTag item : list) {
                        outputs.add(RelativeSide.fromUnrotatedSide((Direction)Direction.m_122376_((int)item.m_7047_())));
                    }
                    host.updateOutputSides(outputs);
                }
            }
            this.importPatterns(player, input);
        }
    }

    private void importPatterns(@Nullable Player player, CompoundTag input) {
        if (player != null && input.m_128441_(NBT_MEMORY_CARD_PATTERNS) && !player.m_9236_().f_46443_) {
            this.clearPatternInventory(player);
            AppEngInternalInventory desiredPatterns = new AppEngInternalInventory(this.patternInv.size());
            desiredPatterns.readFromNBT(input, NBT_MEMORY_CARD_PATTERNS);
            Inventory playerInv = player.m_150109_();
            int blankPatternsAvailable = player.m_150110_().f_35937_ ? Integer.MAX_VALUE : playerInv.m_18947_(AEItems.BLANK_PATTERN.m_5456_());
            int blankPatternsUsed = 0;
            for (int i = 0; i < desiredPatterns.size(); ++i) {
                IPatternDetails pattern;
                if (desiredPatterns.getStackInSlot(i).m_41619_() || (pattern = PatternDetailsHelper.decodePattern((ItemStack)desiredPatterns.getStackInSlot(i), (Level)this.getBlockEntity().m_58904_(), (boolean)true)) == null || blankPatternsAvailable < ++blankPatternsUsed || this.patternInv.addItems(pattern.getDefinition().toStack()).m_41619_()) continue;
                AELog.warn((String)"Failed to add pattern to pattern provider", (Object[])new Object[0]);
                --blankPatternsUsed;
            }
            if (blankPatternsUsed > 0 && !player.m_150110_().f_35937_) {
                new PlayerInternalInventory(playerInv).removeItems(blankPatternsUsed, AEItems.BLANK_PATTERN.stack(), null);
            }
            if (blankPatternsUsed > blankPatternsAvailable) {
                player.m_213846_((Component)PlayerMessages.MissingBlankPatterns.text(new Object[]{blankPatternsUsed - blankPatternsAvailable}));
            }
        }
    }

    private void clearPatternInventory(Player player) {
        if (player.m_150110_().f_35937_) {
            for (int i = 0; i < this.patternInv.size(); ++i) {
                this.patternInv.setItemDirect(i, ItemStack.f_41583_);
            }
            return;
        }
        Inventory playerInv = player.m_150109_();
        int blankPatternCount = 0;
        for (int i = 0; i < this.patternInv.size(); ++i) {
            ItemStack pattern = this.patternInv.getStackInSlot(i);
            if (pattern.m_150930_(AEItems.CRAFTING_PATTERN.m_5456_()) || pattern.m_150930_(AEItems.PROCESSING_PATTERN.m_5456_()) || pattern.m_150930_(AEItems.SMITHING_TABLE_PATTERN.m_5456_()) || pattern.m_150930_(AEItems.STONECUTTING_PATTERN.m_5456_()) || pattern.m_150930_(AEItems.BLANK_PATTERN.m_5456_())) {
                blankPatternCount += pattern.m_41613_();
            } else {
                playerInv.m_150079_(pattern);
            }
            this.patternInv.setItemDirect(i, ItemStack.f_41583_);
        }
        if (blankPatternCount > 0) {
            playerInv.m_150076_(AEItems.BLANK_PATTERN.stack(blankPatternCount), false);
        }
    }

    private void onConfigChanged() {
        this.getMainNode().ifPresent((grid, node) -> {
            if (this.hasWork()) {
                grid.getTickManager().wakeDevice(node);
            } else {
                grid.getTickManager().sleepDevice(node);
            }
        });
        this.saveChanges();
    }

    public void updateRedstoneState() {
        YesNo currentState;
        if (this.f_58857_ == null) {
            return;
        }
        YesNo yesNo = currentState = this.f_58857_.m_277086_(this.f_58858_) != 0 ? YesNo.YES : YesNo.NO;
        if (this.lastRedstoneState != currentState) {
            this.lastRedstoneState = currentState;
            this.onConfigChanged();
        }
    }

    private boolean getRedstoneState() {
        if (this.lastRedstoneState == YesNo.UNDECIDED) {
            this.updateRedstoneState();
        }
        return this.lastRedstoneState == YesNo.YES;
    }

    private boolean isEnabled() {
        if (!this.upgrades.isInstalled((ItemLike)AEItems.REDSTONE_CARD)) {
            return true;
        }
        RedstoneMode rs = (RedstoneMode)this.configManager.getSetting(Settings.REDSTONE_CONTROLLED);
        if (rs == RedstoneMode.LOW_SIGNAL) {
            return !this.getRedstoneState();
        }
        if (rs == RedstoneMode.HIGH_SIGNAL) {
            return this.getRedstoneState();
        }
        return true;
    }

    public boolean isActive() {
        if (this.f_58857_ != null && !this.f_58857_.f_46443_) {
            return this.getMainNode().isOnline();
        }
        return this.isActive;
    }

    public void onMainNodeStateChanged(IGridNodeListener.State reason) {
        if (reason != IGridNodeListener.State.GRID_BOOT) {
            this.markForUpdate();
        }
    }

    @Override
    public EnumSet<RelativeSide> getAllowedOutputs() {
        return this.allowedOutputs;
    }

    @Override
    public void updateOutputSides(EnumSet<RelativeSide> allowedOutputs) {
        this.allowedOutputs = allowedOutputs;
        this.saveChanges();
    }

    public void returnToMainMenu(Player player, ISubMenu iSubMenu) {
        MenuOpener.returnTo(AAEMenus.QUANTUM_CRAFTER, (Player)player, (MenuLocator)MenuLocators.forBlockEntity((BlockEntity)this));
    }

    public ItemStack getMainMenuIcon() {
        return new ItemStack((ItemLike)AAEBlocks.QUANTUM_CRAFTER.asItem());
    }

    public List<Boolean> getEnabledPatternSlots() {
        return this.enabledPatternSlots;
    }

    public void toggleEnablePattern(int index) {
        if (index >= 0 && index < this.enabledPatternSlots.size()) {
            this.enabledPatternSlots.set(index, this.enabledPatternSlots.get(index) == false);
        }
        this.saveChanges();
    }

    public LinkedHashMap<AEKey, Long> getPatternConfigInputs(int index) {
        LinkedHashMap<AEKey, Long> inputs = new LinkedHashMap<AEKey, Long>();
        try {
            CraftingJob job = this.craftingJobs.get(index);
            if (job == null || job.pattern == null) {
                return null;
            }
            for (IPatternDetails.IInput input : job.pattern.getInputs()) {
                GenericStack genStack = input.getPossibleInputs()[0];
                inputs.put(genStack.what(), job.minimumInputToKeep(input));
            }
            return inputs;
        }
        catch (IndexOutOfBoundsException e) {
            return null;
        }
    }

    public Pair<AEKey, Long> getPatternConfigOutput(int index) {
        try {
            CraftingJob job = this.craftingJobs.get(index);
            if (job == null || job.pattern == null) {
                return null;
            }
            return new Pair((Object)job.pattern.getOutputs()[0].what(), (Object)job.limitMaxOutput);
        }
        catch (IndexOutOfBoundsException e) {
            return null;
        }
    }

    public void setStockAmount(int index, int inputIndex, long amount) {
        try {
            CraftingJob job = this.craftingJobs.get(index);
            job.setMinimumInputToKeep(inputIndex, amount);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
    }

    public void setMaxCrafted(int index, long amount) {
        try {
            CraftingJob job = this.craftingJobs.get(index);
            job.limitMaxOutput = amount;
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
    }

    private static class PatternOnlyFilter
    implements IAEItemFilter {
        private PatternOnlyFilter() {
        }

        public boolean allowExtract(InternalInventory inv, int slot, int amount) {
            return false;
        }

        public boolean allowInsert(InternalInventory inv, int slot, ItemStack stack) {
            return AEItems.CRAFTING_PATTERN.isSameAs(stack);
        }
    }

    public static class CraftingJob {
        public static final long DEFAULT_KEEP_INPUT = 0L;
        public static final long DEFAULT_KEEP_OUTPUT = 0L;
        private static final int GRID_SIZE = 3;
        public AECraftingPattern pattern;
        private final List<ItemStack> remainingItems;
        private final List<Long> keepMinInput;
        public long limitMaxOutput;
        private final CraftingContainer testFrame = new TransientCraftingContainer((AbstractContainerMenu)new AutoCraftingMenu(), 3, 3);

        public CraftingJob(AECraftingPattern pattern) {
            this.pattern = pattern;
            this.remainingItems = this.getRemainingItems();
            this.keepMinInput = this.createNewInputMap();
            this.limitMaxOutput = 0L;
        }

        private CraftingJob(AECraftingPattern pattern, List<ItemStack> remainingItems, List<Long> keepMinInput, long limitMaxOutput) {
            this.pattern = pattern;
            this.remainingItems = remainingItems;
            this.keepMinInput = keepMinInput;
            this.limitMaxOutput = limitMaxOutput;
        }

        public void writeToNBT(CompoundTag data) {
            ListTag remainingTag = new ListTag();
            for (ItemStack item : this.remainingItems) {
                if (item == null || item.m_41619_()) continue;
                CompoundTag itemTag = new CompoundTag();
                item.m_41739_(itemTag);
                remainingTag.add((Object)itemTag);
            }
            data.m_128365_("remainingItems", (Tag)remainingTag);
            ListTag listMinTag = new ListTag();
            for (Long value : this.keepMinInput) {
                listMinTag.add((Object)LongTag.m_128882_((long)value));
            }
            data.m_128365_("listMinInput", (Tag)listMinTag);
            data.m_128356_("limitMaxOutput", this.limitMaxOutput);
        }

        public static CraftingJob fromTag(CompoundTag data) {
            ListTag remainingTag = data.m_128437_("remainingItems", 10);
            List<ItemStack> remainingItems = Arrays.asList(new ItemStack[remainingTag.size()]);
            if (!remainingTag.isEmpty()) {
                for (int x = 0; x < remainingTag.size(); ++x) {
                    remainingItems.set(x, ItemStack.m_41712_((CompoundTag)remainingTag.m_128728_(x)));
                }
            }
            ListTag listMinTag = data.m_128437_("listMinInput", 4);
            List<Long> keepMinInput = Arrays.asList(new Long[listMinTag.size()]);
            if (!listMinTag.isEmpty()) {
                for (int x = 0; x < listMinTag.size(); ++x) {
                    keepMinInput.set(x, ((LongTag)listMinTag.get(x)).m_7046_());
                }
            }
            long limitMaxOutput = data.m_128454_("limitMaxOutput");
            return new CraftingJob(null, remainingItems, keepMinInput, limitMaxOutput);
        }

        public void setPattern(AECraftingPattern pattern) {
            this.pattern = pattern;
        }

        public long minimumInputToKeep(IPatternDetails.IInput stack) {
            for (int x = 0; x < this.pattern.getInputs().length; ++x) {
                IPatternDetails.IInput input = this.pattern.getInputs()[x];
                if (!input.equals(stack) || this.keepMinInput.size() <= x) continue;
                return this.keepMinInput.get(x);
            }
            return 0L;
        }

        public void setMinimumInputToKeep(int inputIndex, long value) {
            if (inputIndex >= this.pattern.getInputs().length) {
                return;
            }
            this.keepMinInput.set(inputIndex, value);
        }

        public long requiredInputTotal(GenericStack input, int toCraft) {
            long multiplier = 0L;
            for (IPatternDetails.IInput i : this.pattern.getInputs()) {
                boolean found = false;
                for (GenericStack genInput : i.getPossibleInputs()) {
                    if (!input.what().matches(genInput)) continue;
                    multiplier = i.getMultiplier() * input.amount();
                    found = true;
                    break;
                }
                if (found) break;
            }
            if (!this.isInputConsumed(input)) {
                return multiplier;
            }
            AEKey aEKey = input.what();
            if (aEKey instanceof AEItemKey) {
                AEItemKey key = (AEItemKey)aEKey;
                ItemStack stack = key.toStack();
                for (ItemStack item : this.remainingItems) {
                    if (!item.m_150930_(stack.m_41720_())) continue;
                    return multiplier;
                }
                return multiplier * (long)toCraft;
            }
            if (input.what() instanceof AEFluidKey) {
                return multiplier * (long)toCraft;
            }
            return 0L;
        }

        public boolean isInputConsumed(GenericStack input) {
            for (ItemStack item : this.remainingItems) {
                if (!input.what().wrapForDisplayOrFilter().m_150930_(item.m_41720_())) continue;
                return false;
            }
            for (GenericStack output : this.pattern.getOutputs()) {
                if (!input.what().matches(output)) continue;
                return output.amount() - input.amount() <= 0L;
            }
            return true;
        }

        public boolean isStackAnInput(ItemStack stack) {
            for (IPatternDetails.IInput input : this.pattern.getInputs()) {
                for (GenericStack genInput : input.getPossibleInputs()) {
                    if (!genInput.what().wrapForDisplayOrFilter().m_150930_(stack.m_41720_())) continue;
                    return true;
                }
            }
            return false;
        }

        public long outputAmountPerCraft(GenericStack stack) {
            for (IPatternDetails.IInput i : this.pattern.getInputs()) {
                for (GenericStack genInput : i.getPossibleInputs()) {
                    if (!stack.what().matches(genInput)) continue;
                    return stack.amount() - genInput.amount();
                }
            }
            return stack.amount();
        }

        private List<Long> createNewInputMap() {
            ArrayList<Long> list = new ArrayList<Long>();
            for (IPatternDetails.IInput ignored : this.pattern.getInputs()) {
                list.add(0L);
            }
            return list;
        }

        private List<ItemStack> getRemainingItems() {
            ArrayList<ItemStack> craftingInput = new ArrayList<ItemStack>();
            int bucketsToRemove = 0;
            for (int x = 0; x < this.pattern.getSparseInputs().length; ++x) {
                GenericStack input = this.pattern.getSparseInputs()[x];
                if (input == null) {
                    craftingInput.add(ItemStack.f_41583_);
                } else {
                    AEKey aEKey = input.what();
                    if (aEKey instanceof AEItemKey) {
                        AEItemKey key = (AEItemKey)aEKey;
                        craftingInput.add(key.toStack());
                    }
                }
                if (!this.pattern.canSubstituteFluids() || this.pattern.getValidFluid(x) == null) continue;
                ++bucketsToRemove;
            }
            this.testFrame.m_6211_();
            GenericStack[] sparseInputs = this.pattern.getSparseInputs();
            for (int i = 0; i < 9; ++i) {
                if (sparseInputs[i] == null) continue;
                AEItemKey itemKey = (AEItemKey)sparseInputs[i].what();
                this.testFrame.m_6836_(i, itemKey.toStack());
            }
            NonNullList itemList = this.pattern.getRemainingItems(this.testFrame);
            HashMap<Item, Integer> condensedItemList = new HashMap<Item, Integer>();
            for (ItemStack item : itemList) {
                condensedItemList.merge(item.m_41720_(), item.m_41613_(), Integer::sum);
            }
            ArrayList<ItemStack> finalList = new ArrayList<ItemStack>();
            for (Map.Entry entry : condensedItemList.entrySet()) {
                if (entry.getKey() == ItemStack.f_41583_.m_41720_()) continue;
                if (bucketsToRemove > 0 && entry.getKey() == Items.f_42446_) {
                    int bucketCount = Math.max(0, (Integer)entry.getValue() - bucketsToRemove);
                    if (bucketCount <= 0) continue;
                    finalList.add(new ItemStack((ItemLike)entry.getKey(), bucketCount));
                    continue;
                }
                finalList.add(new ItemStack((ItemLike)entry.getKey(), ((Integer)entry.getValue()).intValue()));
            }
            return Collections.unmodifiableList(finalList);
        }
    }
}

