/*
 * Decompiled with CFR 0.152.
 */
package net.pedroksl.advanced_ae.common.definitions;

import appeng.api.parts.IPart;
import appeng.api.parts.IPartItem;
import appeng.api.parts.PartModels;
import appeng.items.materials.MaterialItem;
import appeng.items.parts.PartItem;
import appeng.items.parts.PartModelsHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Rarity;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.pedroksl.advanced_ae.common.definitions.AAEItemDefinition;
import net.pedroksl.advanced_ae.common.items.AdvPatternEncoderItem;
import net.pedroksl.advanced_ae.common.items.AdvPatternProviderCapacityUpgradeItem;
import net.pedroksl.advanced_ae.common.items.AdvPatternProviderUpgradeItem;
import net.pedroksl.advanced_ae.common.parts.AdvPatternProviderPart;
import net.pedroksl.advanced_ae.common.parts.SmallAdvPatternProviderPart;
import net.pedroksl.advanced_ae.common.parts.StockExportBusPart;
import net.pedroksl.advanced_ae.common.parts.ThroughputMonitorPart;
import net.pedroksl.advanced_ae.common.patterns.AdvProcessingPatternItem;

public class AAEItems {
    public static final DeferredRegister<Item> DR = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ITEMS, (String)"advanced_ae");
    private static final List<AAEItemDefinition<?>> ITEMS = new ArrayList();
    public static final AAEItemDefinition<PartItem<AdvPatternProviderPart>> ADV_PATTERN_PROVIDER = AAEItems.part("Advanced Extended Pattern Provider", "adv_pattern_provider_part", AdvPatternProviderPart.class, AdvPatternProviderPart::new);
    public static final AAEItemDefinition<PartItem<SmallAdvPatternProviderPart>> SMALL_ADV_PATTERN_PROVIDER = AAEItems.part("Advanced Pattern Provider", "small_adv_pattern_provider_part", SmallAdvPatternProviderPart.class, SmallAdvPatternProviderPart::new);
    public static final AAEItemDefinition<PartItem<StockExportBusPart>> STOCK_EXPORT_BUS = AAEItems.part("Stock Export Bus", "stock_export_bus_part", StockExportBusPart.class, StockExportBusPart::new);
    public static final AAEItemDefinition<PartItem<ThroughputMonitorPart>> THROUGHPUT_MONITOR = AAEItems.part("ME Throughput Monitor", "throughput_monitor", ThroughputMonitorPart.class, ThroughputMonitorPart::new);
    public static final AAEItemDefinition<AdvProcessingPatternItem> ADV_PROCESSING_PATTERN = AAEItems.item("Advanced Processing Pattern", "adv_processing_pattern", AdvProcessingPatternItem::new);
    public static final AAEItemDefinition<Item> ADV_PATTERN_PROVIDER_UPGRADE = AAEItems.item("Advanced Pattern Provider Upgrade", "adv_pattern_provider_upgrade", AdvPatternProviderUpgradeItem::new);
    public static final AAEItemDefinition<Item> ADV_PATTERN_PROVIDER_CAPACITY_UPGRADE = AAEItems.item("Advanced Pattern Provider Capacity Upgrade", "adv_pattern_provider_capacity_upgrade", AdvPatternProviderCapacityUpgradeItem::new);
    public static final AAEItemDefinition<MaterialItem> QUANTUM_INFUSED_DUST = AAEItems.item("Quantum Infused Dust", "quantum_infused_dust", MaterialItem::new);
    public static final AAEItemDefinition<MaterialItem> QUANTUM_ALLOY = AAEItems.item("Quantum Alloy", "quantum_alloy", MaterialItem::new);
    public static final AAEItemDefinition<MaterialItem> QUANTUM_ALLOY_PLATE = AAEItems.item("Quantum Alloy Plate", "quantum_alloy_plate", p -> new MaterialItem(p.m_41497_(Rarity.EPIC)));
    public static final AAEItemDefinition<MaterialItem> SHATTERED_SINGULARITY = AAEItems.item("Shattered Singularity", "shattered_singularity", MaterialItem::new);
    public static final AAEItemDefinition<MaterialItem> QUANTUM_PROCESSOR_PRESS = AAEItems.item("Inscriber Quantum Press", "quantum_processor_press", MaterialItem::new);
    public static final AAEItemDefinition<MaterialItem> QUANTUM_PROCESSOR_PRINT = AAEItems.item("Printed Quantum Circuit", "printed_quantum_processor", MaterialItem::new);
    public static final AAEItemDefinition<MaterialItem> QUANTUM_PROCESSOR = AAEItems.item("Quantum Processor", "quantum_processor", MaterialItem::new);
    public static final AAEItemDefinition<MaterialItem> QUANTUM_STORAGE_COMPONENT = AAEItems.item("Quantum Storage Component", "quantum_storage_component", MaterialItem::new);
    public static final AAEItemDefinition<AdvPatternEncoderItem> ADV_PATTERN_ENCODER = AAEItems.item("Advanced Pattern Encoder", "adv_pattern_encoder", AdvPatternEncoderItem::new);
    public static final AAEItemDefinition<Item> MONITOR_CONFIGURATOR = AAEItems.item("Throughput Monitor Configurator", "throughput_monitor_configurator", Item::new);

    public static List<AAEItemDefinition<?>> getItems() {
        return Collections.unmodifiableList(ITEMS);
    }

    private static <T extends Item> AAEItemDefinition<T> item(String englishName, String id, Function<Item.Properties, T> factory) {
        AAEItemDefinition definition = new AAEItemDefinition(englishName, DR.register(id, () -> (Item)factory.apply(new Item.Properties())));
        ITEMS.add(definition);
        return definition;
    }

    private static <T extends IPart> AAEItemDefinition<PartItem<T>> part(String englishName, String id, Class<T> partClass, Function<IPartItem<T>, T> factory) {
        PartModels.registerModels((Collection)PartModelsHelper.createModels(partClass));
        return AAEItems.item(englishName, id, p -> new PartItem(p, partClass, factory));
    }
}

