/*
 * Decompiled with CFR 0.152.
 */
package net.pedroksl.advanced_ae.common.cluster;

import appeng.api.config.CpuSelectionMode;
import appeng.api.config.Settings;
import appeng.api.networking.IGrid;
import appeng.api.networking.IGridNode;
import appeng.api.networking.crafting.CraftingJobStatus;
import appeng.api.networking.crafting.ICraftingPlan;
import appeng.api.networking.crafting.ICraftingRequester;
import appeng.api.networking.crafting.ICraftingSubmitResult;
import appeng.api.networking.events.GridCraftingCpuChange;
import appeng.api.networking.events.GridEvent;
import appeng.api.networking.security.IActionHost;
import appeng.api.networking.security.IActionSource;
import appeng.api.stacks.GenericStack;
import appeng.api.util.IConfigManager;
import appeng.blockentity.crafting.CraftingMonitorBlockEntity;
import appeng.crafting.CraftingPlan;
import appeng.crafting.execution.CraftingSubmitResult;
import appeng.crafting.inv.ListCraftingInventory;
import appeng.me.cluster.IAECluster;
import appeng.me.cluster.MBCalculator;
import appeng.me.helpers.MachineSource;
import appeng.util.ConfigManager;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.level.Level;
import net.pedroksl.advanced_ae.common.cluster.AdvCraftingCPU;
import net.pedroksl.advanced_ae.common.entities.AdvCraftingBlockEntity;
import org.jetbrains.annotations.Nullable;

public class AdvCraftingCPUCluster
implements IAECluster {
    private final BlockPos boundsMin;
    private final BlockPos boundsMax;
    private final HashMap<ICraftingPlan, AdvCraftingCPU> activeCpus = new HashMap();
    private AdvCraftingCPU remainingStorageCpu;
    private final List<AdvCraftingBlockEntity> blockEntities = new ArrayList<AdvCraftingBlockEntity>();
    private final List<CraftingMonitorBlockEntity> status = new ArrayList<CraftingMonitorBlockEntity>();
    private final ConfigManager configManager = new ConfigManager(this::markDirty);
    private Component myName = null;
    private boolean isDestroyed = false;
    private long storage = 0L;
    private long storageMultiplier = 0L;
    private long remainingStorage = 0L;
    private MachineSource machineSrc = null;
    private int accelerator = 0;
    private int acceleratorMultiplier = 0;

    public AdvCraftingCPUCluster(BlockPos boundsMin, BlockPos boundsMax) {
        this.boundsMin = boundsMin.m_7949_();
        this.boundsMax = boundsMax.m_7949_();
        this.configManager.registerSetting(Settings.CPU_SELECTION_MODE, (Enum)CpuSelectionMode.ANY);
    }

    public boolean isDestroyed() {
        return this.isDestroyed;
    }

    public BlockPos getBoundsMin() {
        return this.boundsMin;
    }

    public BlockPos getBoundsMax() {
        return this.boundsMax;
    }

    public void updateStatus(boolean b) {
        for (AdvCraftingBlockEntity r : this.blockEntities) {
            r.updateSubType(true);
        }
    }

    public void destroy() {
        boolean ownsModification;
        if (this.isDestroyed) {
            return;
        }
        this.isDestroyed = true;
        boolean bl = ownsModification = !MBCalculator.isModificationInProgress();
        if (ownsModification) {
            MBCalculator.setModificationInProgress((IAECluster)this);
        }
        try {
            this.updateGridForChangedCpu(null);
        }
        finally {
            if (ownsModification) {
                MBCalculator.setModificationInProgress(null);
            }
        }
    }

    private void updateGridForChangedCpu(AdvCraftingCPUCluster cluster) {
        boolean posted = false;
        for (AdvCraftingBlockEntity r : this.blockEntities) {
            IGridNode n = r.getActionableNode();
            if (n != null && !posted) {
                n.getGrid().postEvent((GridEvent)new GridCraftingCpuChange(n));
                posted = true;
            }
            r.updateStatus(cluster);
        }
    }

    public Iterator<AdvCraftingBlockEntity> getBlockEntities() {
        return this.blockEntities.iterator();
    }

    public List<ListCraftingInventory> getInventories() {
        ArrayList<ListCraftingInventory> list = new ArrayList<ListCraftingInventory>();
        for (AdvCraftingCPU cpu : this.activeCpus.values()) {
            list.add(cpu.getInventory());
        }
        return list;
    }

    void addBlockEntity(AdvCraftingBlockEntity te) {
        if (this.machineSrc == null || te.isCoreBlock()) {
            this.machineSrc = new MachineSource((IActionHost)te);
        }
        te.setCoreBlock(false);
        te.saveChanges();
        this.blockEntities.add(0, te);
        if (te.getStorageBytes() > 0L) {
            this.storage += te.getStorageBytes();
            this.recalculateRemainingStorage();
        }
        if (te.getStorageMultiplier() > 0) {
            this.storageMultiplier += (long)te.getStorageMultiplier();
            this.recalculateRemainingStorage();
        }
        if (te.getAcceleratorThreads() > 0) {
            if (te.getAcceleratorThreads() <= 16) {
                this.accelerator += te.getAcceleratorThreads();
            } else {
                throw new IllegalArgumentException("Co-processor threads may not exceed 16 per single unit block.");
            }
        }
        if (te.getAccelerationMultiplier() > 0) {
            this.acceleratorMultiplier += te.getAccelerationMultiplier();
        }
    }

    public void recalculateRemainingStorage() {
        long totalStorage = this.storage;
        if (this.storageMultiplier > 0L) {
            totalStorage *= this.storageMultiplier;
        }
        long usedStorage = 0L;
        for (ICraftingPlan plan : this.activeCpus.keySet()) {
            usedStorage += plan.bytes();
        }
        this.remainingStorage = totalStorage - usedStorage;
    }

    public void markDirty() {
        this.getCore().saveChanges();
    }

    public void updateOutput(GenericStack finalOutput) {
        GenericStack send = finalOutput;
        if (finalOutput != null && finalOutput.amount() <= 0L) {
            send = null;
        }
        for (CraftingMonitorBlockEntity t : this.status) {
            t.setJob(send);
        }
    }

    public IActionSource getSrc() {
        return (IActionSource)Objects.requireNonNull(this.machineSrc);
    }

    private AdvCraftingBlockEntity getCore() {
        if (this.machineSrc == null) {
            return null;
        }
        return (AdvCraftingBlockEntity)((Object)this.machineSrc.machine().get());
    }

    @Nullable
    public IGrid getGrid() {
        IGridNode node = this.getNode();
        return node != null ? node.getGrid() : null;
    }

    public void cancelJobs() {
        for (ICraftingPlan plan : this.activeCpus.keySet()) {
            this.killCpu(plan, false);
        }
    }

    public void cancelJob(ICraftingPlan plan) {
        AdvCraftingCPU cpu = this.activeCpus.get(plan);
        if (cpu != null) {
            this.killCpu(plan);
        }
    }

    public ICraftingSubmitResult submitJob(IGrid grid, ICraftingPlan plan, IActionSource src, ICraftingRequester requestingMachine) {
        if (!this.isActive()) {
            return CraftingSubmitResult.CPU_OFFLINE;
        }
        if (this.getAvailableStorage() < plan.bytes()) {
            return CraftingSubmitResult.CPU_TOO_SMALL;
        }
        AdvCraftingCPU newCpu = new AdvCraftingCPU(this, plan);
        ICraftingSubmitResult submitResult = newCpu.craftingLogic.trySubmitJob(grid, plan, src, requestingMachine);
        if (submitResult.successful()) {
            this.activeCpus.put(plan, newCpu);
            this.recalculateRemainingStorage();
            this.updateGridForChangedCpu(this);
        }
        return submitResult;
    }

    private void killCpu(ICraftingPlan plan, boolean updateGrid) {
        AdvCraftingCPU cpu = this.activeCpus.get(plan);
        cpu.craftingLogic.cancel();
        cpu.craftingLogic.markForDeletion();
        this.recalculateRemainingStorage();
        if (updateGrid) {
            this.updateGridForChangedCpu(this);
        }
    }

    private void killCpu(ICraftingPlan plan) {
        this.killCpu(plan, true);
    }

    protected void deactivate(ICraftingPlan plan) {
        this.activeCpus.remove(plan);
        this.recalculateRemainingStorage();
        this.updateGridForChangedCpu(this);
    }

    public List<AdvCraftingCPU> getActiveCPUs() {
        ArrayList<AdvCraftingCPU> list = new ArrayList<AdvCraftingCPU>();
        ArrayList<ICraftingPlan> killList = new ArrayList<ICraftingPlan>();
        for (Map.Entry<ICraftingPlan, AdvCraftingCPU> cpuEntry : this.activeCpus.entrySet()) {
            AdvCraftingCPU cpu = cpuEntry.getValue();
            if (cpu.craftingLogic.hasJob() || cpu.craftingLogic.isMarkedForDeletion()) {
                list.add(cpu);
                continue;
            }
            killList.add(cpuEntry.getKey());
        }
        for (ICraftingPlan cpu : killList) {
            this.killCpu(cpu);
        }
        return list;
    }

    public AdvCraftingCPU getRemainingCapacityCPU() {
        if (this.remainingStorageCpu == null || this.remainingStorageCpu.getAvailableStorage() != this.remainingStorage) {
            this.remainingStorageCpu = new AdvCraftingCPU(this, this.remainingStorage);
        }
        return this.remainingStorageCpu;
    }

    @Nullable
    public CraftingJobStatus getJobStatus(ICraftingPlan plan) {
        AdvCraftingCPU cpu = this.activeCpus.get(plan);
        if (cpu != null) {
            return cpu.getJobStatus();
        }
        return null;
    }

    public long getAvailableStorage() {
        return this.remainingStorage;
    }

    public int getCoProcessors() {
        int coprocessors = this.accelerator;
        if (this.acceleratorMultiplier > 0) {
            coprocessors *= this.acceleratorMultiplier;
        }
        return coprocessors;
    }

    public Component getName() {
        return this.myName;
    }

    @Nullable
    public IGridNode getNode() {
        AdvCraftingBlockEntity core = this.getCore();
        return core != null ? core.getActionableNode() : null;
    }

    public boolean isActive() {
        IGridNode node = this.getNode();
        return node != null && node.isActive();
    }

    public void writeToNBT(CompoundTag data) {
        ListTag listCpus = new ListTag();
        for (Map.Entry<ICraftingPlan, AdvCraftingCPU> cpu : this.activeCpus.entrySet()) {
            if (cpu == null) continue;
            CompoundTag keyTag = new CompoundTag();
            this.writeCraftingPlanToNBT(cpu.getKey(), keyTag);
            CompoundTag cpuTag = new CompoundTag();
            cpu.getValue().writeToNBT(cpuTag);
            CompoundTag pair = new CompoundTag();
            pair.m_128365_("key", (Tag)keyTag);
            pair.m_128365_("cpu", (Tag)cpuTag);
            listCpus.add((Object)pair);
        }
        data.m_128365_("cpuList", (Tag)listCpus);
        this.configManager.writeToNBT(data);
    }

    private void writeCraftingPlanToNBT(ICraftingPlan plan, CompoundTag tag) {
        CompoundTag outputTag = GenericStack.writeTag((GenericStack)plan.finalOutput());
        tag.m_128365_("output", (Tag)outputTag);
        tag.m_128356_("bytes", plan.bytes());
        tag.m_128379_("simulation", plan.simulation());
        tag.m_128379_("multiplePaths", plan.multiplePaths());
    }

    void done() {
        AdvCraftingBlockEntity core = this.getCore();
        core.setCoreBlock(true);
        if (core.getPreviousState() != null) {
            this.readFromNBT(core.getPreviousState());
            core.setPreviousState(null);
        }
        this.updateName();
    }

    public void readFromNBT(CompoundTag data) {
        ListTag cpuList = (ListTag)data.m_128423_("cpuList");
        if (cpuList != null) {
            for (int x = 0; x < cpuList.size(); ++x) {
                CompoundTag pair = cpuList.m_128728_(x);
                CraftingPlan plan = this.readCraftingPlanFromNBT(pair.m_128469_("key"));
                AdvCraftingCPU cpu = new AdvCraftingCPU(this, (ICraftingPlan)plan);
                this.activeCpus.put((ICraftingPlan)plan, cpu);
                cpu.readFromNBT(pair.m_128469_("cpu"));
            }
        }
        this.configManager.readFromNBT(data);
        this.recalculateRemainingStorage();
    }

    private CraftingPlan readCraftingPlanFromNBT(CompoundTag tag) {
        GenericStack output = GenericStack.readTag((CompoundTag)tag.m_128469_("output"));
        long bytes = tag.m_128454_("bytes");
        boolean simulation = tag.m_128471_("simulation");
        boolean multiplePaths = tag.m_128471_("multiplePaths");
        return new CraftingPlan(output, bytes, simulation, multiplePaths, null, null, null, null);
    }

    public void updateName() {
        this.myName = null;
        for (AdvCraftingBlockEntity te : this.blockEntities) {
            if (!te.m_8077_()) continue;
            if (this.myName != null) {
                this.myName.m_6881_().m_130946_(" ").m_7220_(te.m_7770_());
                continue;
            }
            this.myName = te.m_7770_().m_6881_();
        }
    }

    public Level getLevel() {
        return this.getCore().m_58904_();
    }

    public void breakCluster() {
        AdvCraftingBlockEntity t = this.getCore();
        if (t != null) {
            t.breakCluster();
        }
    }

    public CpuSelectionMode getSelectionMode() {
        return (CpuSelectionMode)this.configManager.getSetting(Settings.CPU_SELECTION_MODE);
    }

    public IConfigManager getConfigManager() {
        return this.configManager;
    }

    public boolean canBeAutoSelectedFor(IActionSource source) {
        return switch (this.getSelectionMode()) {
            default -> throw new IncompatibleClassChangeError();
            case CpuSelectionMode.ANY -> true;
            case CpuSelectionMode.PLAYER_ONLY -> source.player().isPresent();
            case CpuSelectionMode.MACHINE_ONLY -> source.player().isEmpty();
        };
    }

    public boolean isPreferredFor(IActionSource source) {
        return switch (this.getSelectionMode()) {
            default -> throw new IncompatibleClassChangeError();
            case CpuSelectionMode.ANY -> false;
            case CpuSelectionMode.PLAYER_ONLY -> source.player().isPresent();
            case CpuSelectionMode.MACHINE_ONLY -> source.player().isEmpty();
        };
    }
}

