/*
 * Decompiled with CFR 0.152.
 */
package net.pedroksl.advanced_ae.common.blocks;

import appeng.api.orientation.IOrientationStrategy;
import appeng.api.orientation.OrientationStrategies;
import appeng.block.AEBaseEntityBlock;
import appeng.menu.MenuOpener;
import appeng.menu.locator.MenuLocator;
import appeng.menu.locator.MenuLocators;
import appeng.util.InteractionUtil;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.common.SoundActions;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.pedroksl.advanced_ae.common.definitions.AAEMenus;
import net.pedroksl.advanced_ae.common.entities.ReactionChamberEntity;
import org.jetbrains.annotations.Nullable;

public class ReactionChamberBlock
extends AEBaseEntityBlock<ReactionChamberEntity> {
    public static final BooleanProperty WORKING = BooleanProperty.m_61465_((String)"working");

    public ReactionChamberBlock() {
        super(ReactionChamberBlock.metalProps().m_60955_());
        this.m_49959_((BlockState)this.m_49966_().m_61124_((Property)WORKING, (Comparable)Boolean.valueOf(false)));
    }

    public InteractionResult onActivated(Level level, BlockPos pos, Player player, InteractionHand hand, @Nullable ItemStack heldItem, BlockHitResult hit) {
        boolean didSomething;
        if (InteractionUtil.isInAlternateUseMode((Player)player)) {
            return InteractionResult.PASS;
        }
        if (heldItem != null && heldItem.m_41720_() instanceof BucketItem && (didSomething = this.useBucket(player, level, pos, heldItem, hand))) {
            return InteractionResult.m_19078_((boolean)level.m_5776_());
        }
        ReactionChamberEntity be = (ReactionChamberEntity)this.getBlockEntity((BlockGetter)level, pos);
        if (be != null) {
            if (!level.m_5776_()) {
                MenuOpener.open(AAEMenus.REACTION_CHAMBER, (Player)player, (MenuLocator)MenuLocators.forBlockEntity((BlockEntity)be));
            }
            return InteractionResult.m_19078_((boolean)level.m_5776_());
        }
        return InteractionResult.PASS;
    }

    public boolean useBucket(Player player, Level level, BlockPos pos, ItemStack stack, InteractionHand hand) {
        AtomicBoolean didSomething = new AtomicBoolean(false);
        LazyOptional capOp = stack.getCapability(ForgeCapabilities.FLUID_HANDLER_ITEM);
        BlockEntity entity = level.m_7702_(pos);
        if (!(entity instanceof ReactionChamberEntity)) {
            return false;
        }
        capOp.ifPresent(cap -> {
            LazyOptional blockCapOp = entity.getCapability(ForgeCapabilities.FLUID_HANDLER);
            blockCapOp.ifPresent(blockCap -> {
                if (cap.getFluidInTank(0).isEmpty()) {
                    FluidStack extracted = blockCap.drain(1000, IFluidHandler.FluidAction.SIMULATE);
                    if (!extracted.isEmpty() && extracted.getAmount() == 1000) {
                        blockCap.drain(1000, IFluidHandler.FluidAction.EXECUTE);
                        if (cap.getContainer().m_41613_() == 1) {
                            cap.fill(extracted, IFluidHandler.FluidAction.EXECUTE);
                            player.m_21008_(hand, cap.getContainer());
                        } else {
                            ItemStack newBucket = new ItemStack((ItemLike)Items.f_42446_, 1);
                            LazyOptional newCapOp = newBucket.getCapability(ForgeCapabilities.FLUID_HANDLER_ITEM);
                            newCapOp.ifPresent(newCap -> {
                                newCap.fill(extracted, IFluidHandler.FluidAction.EXECUTE);
                                player.m_21008_(hand, newCap.getContainer());
                                player.m_36356_(new ItemStack((ItemLike)stack.m_41720_(), stack.m_41613_() - 1));
                            });
                        }
                        SoundEvent soundevent = extracted.getFluid().getFluidType().getSound(player, (BlockGetter)level, pos, SoundActions.BUCKET_EMPTY);
                        if (soundevent == null) {
                            soundevent = extracted.getFluid() == Fluids.f_76195_ ? SoundEvents.f_11783_ : SoundEvents.f_11781_;
                        }
                        level.m_5594_(player, pos, soundevent, SoundSource.BLOCKS, 1.0f, 1.0f);
                        didSomething.set(true);
                    }
                } else {
                    FluidStack extracted = cap.drain(1000, IFluidHandler.FluidAction.SIMULATE);
                    int inserted = blockCap.fill(extracted, IFluidHandler.FluidAction.SIMULATE);
                    if (inserted == 1000) {
                        extracted = cap.drain(1000, IFluidHandler.FluidAction.EXECUTE);
                        blockCap.fill(extracted, IFluidHandler.FluidAction.EXECUTE);
                        didSomething.set(true);
                        player.m_21008_(hand, cap.getContainer());
                        SoundEvent soundevent = extracted.getFluid().getFluidType().getSound(player, (BlockGetter)level, pos, SoundActions.BUCKET_EMPTY);
                        if (soundevent == null) {
                            soundevent = extracted.getFluid() == Fluids.f_76195_ ? SoundEvents.f_11780_ : SoundEvents.f_11778_;
                        }
                        level.m_5594_(player, pos, soundevent, SoundSource.BLOCKS, 1.0f, 1.0f);
                    }
                }
            });
        });
        return didSomething.get();
    }

    protected void m_7926_(@Nonnull StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{WORKING});
    }

    public IOrientationStrategy getOrientationStrategy() {
        return OrientationStrategies.horizontalFacing();
    }
}

