/*
 * Decompiled with CFR 0.152.
 */
package net.pedroksl.advanced_ae.client;

import appeng.api.util.AEColor;
import appeng.client.gui.me.common.PinnedKeys;
import appeng.client.render.StaticItemColor;
import appeng.client.render.crafting.AbstractCraftingUnitModelProvider;
import appeng.client.render.crafting.CraftingCubeModel;
import appeng.hooks.BuiltInModelHooks;
import appeng.init.client.InitScreens;
import net.minecraft.client.Minecraft;
import net.minecraft.client.color.item.ItemColor;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.resources.model.UnbakedModel;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.EntityRenderersEvent;
import net.minecraftforge.client.event.RegisterColorHandlersEvent;
import net.minecraftforge.client.event.RegisterKeyMappingsEvent;
import net.minecraftforge.client.extensions.common.IClientFluidTypeExtensions;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.pedroksl.advanced_ae.AdvancedAE;
import net.pedroksl.advanced_ae.client.Hotkeys;
import net.pedroksl.advanced_ae.client.gui.AdvPatternEncoderScreen;
import net.pedroksl.advanced_ae.client.gui.AdvPatternProviderScreen;
import net.pedroksl.advanced_ae.client.gui.OutputDirectionScreen;
import net.pedroksl.advanced_ae.client.gui.QuantumComputerScreen;
import net.pedroksl.advanced_ae.client.gui.QuantumCrafterConfigPatternScreen;
import net.pedroksl.advanced_ae.client.gui.QuantumCrafterScreen;
import net.pedroksl.advanced_ae.client.gui.ReactionChamberScreen;
import net.pedroksl.advanced_ae.client.gui.SetAmountScreen;
import net.pedroksl.advanced_ae.client.gui.SmallAdvPatternProviderScreen;
import net.pedroksl.advanced_ae.client.gui.StockExportBusScreen;
import net.pedroksl.advanced_ae.client.renderer.AAECraftingUnitModelProvider;
import net.pedroksl.advanced_ae.client.renderer.ReactionChamberTESR;
import net.pedroksl.advanced_ae.common.blocks.AAECraftingUnitType;
import net.pedroksl.advanced_ae.common.definitions.AAEBlockEntities;
import net.pedroksl.advanced_ae.common.definitions.AAEFluids;
import net.pedroksl.advanced_ae.common.definitions.AAEItems;
import net.pedroksl.advanced_ae.common.definitions.AAEMenus;
import net.pedroksl.advanced_ae.common.definitions.FluidDefinition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@OnlyIn(value=Dist.CLIENT)
public class AAEClient
extends AdvancedAE {
    private static final Logger LOGGER = LoggerFactory.getLogger(AAEClient.class);
    private static AAEClient INSTANCE;

    public AAEClient() {
        IEventBus eventBus = FMLJavaModLoadingContext.get().getModEventBus();
        eventBus.addListener(AAEClient::initItemBlockRenderTypes);
        eventBus.addListener(AAEClient::initItemColours);
        eventBus.addListener(AAEClient::initRenderers);
        eventBus.addListener(this::registerHotkeys);
        INSTANCE = this;
        MinecraftForge.EVENT_BUS.addListener(e -> {
            if (e.phase == TickEvent.Phase.END) {
                this.tickPinnedKeys(Minecraft.m_91087_());
                Hotkeys.checkHotkeys();
            }
        });
        eventBus.addListener(this::clientSetup);
    }

    private void clientSetup(FMLClientSetupEvent event) {
        event.enqueueWork(() -> {
            Minecraft minecraft = Minecraft.m_91087_();
            try {
                AAEClient.initScreens();
            }
            catch (Throwable e) {
                LOGGER.error("AAE failed postClientSetup", e);
                throw new RuntimeException(e);
            }
        });
    }

    private static void initScreens() {
        InitScreens.register(AAEMenus.QUANTUM_COMPUTER, QuantumComputerScreen::new, (String)"/screens/quantum_computer.json");
        InitScreens.register(AAEMenus.ADV_PATTERN_PROVIDER, AdvPatternProviderScreen::new, (String)"/screens/adv_pattern_provider.json");
        InitScreens.register(AAEMenus.SMALL_ADV_PATTERN_PROVIDER, SmallAdvPatternProviderScreen::new, (String)"/screens/small_adv_pattern_provider.json");
        InitScreens.register(AAEMenus.ADV_PATTERN_ENCODER, AdvPatternEncoderScreen::new, (String)"/screens/adv_pattern_encoder.json");
        InitScreens.register(AAEMenus.REACTION_CHAMBER, ReactionChamberScreen::new, (String)"/screens/reaction_chamber.json");
        InitScreens.register(AAEMenus.QUANTUM_CRAFTER, QuantumCrafterScreen::new, (String)"/screens/quantum_crafter.json");
        InitScreens.register(AAEMenus.STOCK_EXPORT_BUS, StockExportBusScreen::new, (String)"/screens/stock_export_bus.json");
        InitScreens.register(AAEMenus.OUTPUT_DIRECTION, OutputDirectionScreen::new, (String)"/screens/output_direction.json");
        InitScreens.register(AAEMenus.CRAFTER_PATTERN_CONFIG, QuantumCrafterConfigPatternScreen::new, (String)"/screens/quantum_crafter_pattern_config.json");
        InitScreens.register(AAEMenus.SET_AMOUNT, SetAmountScreen::new, (String)"/screens/aae_set_amount.json");
    }

    private static void initItemBlockRenderTypes(FMLClientSetupEvent event) {
        event.enqueueWork(() -> {
            for (AAECraftingUnitType type : AAECraftingUnitType.values()) {
                if (type != AAECraftingUnitType.STRUCTURE) continue;
                BuiltInModelHooks.addBuiltInModel((ResourceLocation)AdvancedAE.makeId("block/crafting/" + type.getAffix() + "_formed"), (UnbakedModel)new CraftingCubeModel((AbstractCraftingUnitModelProvider)new AAECraftingUnitModelProvider(type)));
            }
            ItemBlockRenderTypes.setRenderLayer(AAEFluids.QUANTUM_INFUSION.source(), (RenderType)RenderType.m_110466_());
            ItemBlockRenderTypes.setRenderLayer(AAEFluids.QUANTUM_INFUSION.flowing(), (RenderType)RenderType.m_110466_());
        });
    }

    private void tickPinnedKeys(Minecraft minecraft) {
        if (minecraft.f_91080_ == null) {
            PinnedKeys.prune();
        }
    }

    @Override
    public void registerHotkey(String id) {
        Hotkeys.registerHotkey(id);
    }

    private void registerHotkeys(RegisterKeyMappingsEvent e) {
        Hotkeys.finalizeRegistration(arg_0 -> ((RegisterKeyMappingsEvent)e).register(arg_0));
    }

    private static void initItemColours(RegisterColorHandlersEvent.Item event) {
        event.register(AAEClient.makeOpaque((ItemColor)new StaticItemColor(AEColor.TRANSPARENT)), new ItemLike[]{AAEItems.THROUGHPUT_MONITOR.m_5456_()});
        for (FluidDefinition<?, ?> bucket : AAEFluids.getFluids()) {
            event.getItemColors().m_92689_((stack, index) -> {
                Item patt7464$temp;
                if (index == 1 && (patt7464$temp = stack.m_41720_()) instanceof BucketItem) {
                    BucketItem bucketItem = (BucketItem)patt7464$temp;
                    return IClientFluidTypeExtensions.of((Fluid)bucketItem.getFluid()).getTintColor();
                }
                return -1;
            }, new ItemLike[]{bucket.bucketItem()});
        }
    }

    private static void initRenderers(EntityRenderersEvent.RegisterRenderers event) {
        event.registerBlockEntityRenderer(AAEBlockEntities.REACTION_CHAMBER.get(), ReactionChamberTESR::new);
    }

    private static ItemColor makeOpaque(ItemColor itemColor) {
        return (stack, tintIndex) -> itemColor.m_92671_(stack, tintIndex) | 0xFF000000;
    }

    public static AAEClient instance() {
        return INSTANCE;
    }
}

