/*
 * Decompiled with CFR 0.152.
 */
package net.pedroksl.advanced_ae;

import appeng.api.crafting.IPatternDetailsDecoder;
import appeng.api.crafting.PatternDetailsHelper;
import appeng.api.upgrades.Upgrades;
import appeng.core.AELog;
import appeng.core.definitions.AEItems;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.ForgeRegistries;
import net.pedroksl.advanced_ae.common.definitions.AAEBlockEntities;
import net.pedroksl.advanced_ae.common.definitions.AAEBlocks;
import net.pedroksl.advanced_ae.common.definitions.AAEConfig;
import net.pedroksl.advanced_ae.common.definitions.AAECreativeTab;
import net.pedroksl.advanced_ae.common.definitions.AAEFluids;
import net.pedroksl.advanced_ae.common.definitions.AAEHotkeys;
import net.pedroksl.advanced_ae.common.definitions.AAEItems;
import net.pedroksl.advanced_ae.common.definitions.AAEMenus;
import net.pedroksl.advanced_ae.common.patterns.AdvPatternDetailsDecoder;
import net.pedroksl.advanced_ae.network.AAENetworkHandler;
import net.pedroksl.advanced_ae.recipes.InitRecipeSerializers;
import net.pedroksl.advanced_ae.recipes.InitRecipeTypes;
import net.pedroksl.advanced_ae.xmod.Addons;
import net.pedroksl.advanced_ae.xmod.appflux.AppliedFluxPlugin;

public class AdvancedAE {
    public static final String MOD_ID = "advanced_ae";

    public AdvancedAE() {
        IEventBus eventBus = FMLJavaModLoadingContext.get().getModEventBus();
        AAEConfig.register(MOD_ID);
        AAEBlocks.DR.register(eventBus);
        AAEItems.DR.register(eventBus);
        AAEBlockEntities.DR.register(eventBus);
        AAEFluids.init(eventBus);
        AAEMenus.DR.register(eventBus);
        AAECreativeTab.DR.register(eventBus);
        eventBus.addListener(this::commonSetup);
        MinecraftForge.EVENT_BUS.register((Object)this);
        eventBus.addListener(AdvancedAE::initUpgrades);
        eventBus.addListener(event -> {
            if (event.getRegistryKey() == Registries.f_256954_) {
                InitRecipeTypes.init(ForgeRegistries.RECIPE_TYPES);
            } else if (event.getRegistryKey() == Registries.f_256764_) {
                InitRecipeSerializers.init(ForgeRegistries.RECIPE_SERIALIZERS);
            }
        });
        eventBus.addListener(this::commonSetup);
        AAEHotkeys.init();
    }

    private void commonSetup(FMLCommonSetupEvent event) {
        AAENetworkHandler.INSTANCE.init();
        PatternDetailsHelper.registerDecoder((IPatternDetailsDecoder)AdvPatternDetailsDecoder.INSTANCE);
        event.enqueueWork(this::postRegistrationInitialization).whenComplete((res, err) -> {
            if (err != null) {
                AELog.warn((Throwable)err);
            }
        });
    }

    public void postRegistrationInitialization() {
    }

    private static void initUpgrades(FMLCommonSetupEvent event) {
        event.enqueueWork(() -> {
            Upgrades.add((ItemLike)AEItems.SPEED_CARD, AAEBlocks.REACTION_CHAMBER, (int)4);
            Upgrades.add((ItemLike)AEItems.SPEED_CARD, AAEBlocks.QUANTUM_CRAFTER, (int)4);
            Upgrades.add((ItemLike)AEItems.REDSTONE_CARD, AAEBlocks.QUANTUM_CRAFTER, (int)1);
            Upgrades.add((ItemLike)AEItems.SPEED_CARD, AAEItems.STOCK_EXPORT_BUS, (int)4);
            Upgrades.add((ItemLike)AEItems.CAPACITY_CARD, AAEItems.STOCK_EXPORT_BUS, (int)5);
            Upgrades.add((ItemLike)AEItems.REDSTONE_CARD, AAEItems.STOCK_EXPORT_BUS, (int)1);
            Upgrades.add((ItemLike)AEItems.CRAFTING_CARD, AAEItems.STOCK_EXPORT_BUS, (int)1);
            if (Addons.APPFLUX.isLoaded()) {
                AppliedFluxPlugin.init();
            }
        });
    }

    public void registerHotkey(String id) {
    }

    public static ResourceLocation makeId(String id) {
        return new ResourceLocation(MOD_ID, id);
    }
}

