/*
 * Decompiled with CFR 0.152.
 */
package mcjty.xnet.modules.controller.blocks;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSyntaxException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mcjty.lib.api.container.DefaultContainerProvider;
import mcjty.lib.blockcommands.Command;
import mcjty.lib.blockcommands.ListCommand;
import mcjty.lib.blockcommands.ServerCommand;
import mcjty.lib.blocks.BaseBlock;
import mcjty.lib.builder.BlockBuilder;
import mcjty.lib.builder.InfoLine;
import mcjty.lib.builder.TooltipBuilder;
import mcjty.lib.compat.theoneprobe.TOPDriver;
import mcjty.lib.container.ContainerFactory;
import mcjty.lib.container.GenericItemHandler;
import mcjty.lib.container.SlotDefinition;
import mcjty.lib.tileentity.Cap;
import mcjty.lib.tileentity.CapType;
import mcjty.lib.tileentity.GenericEnergyStorage;
import mcjty.lib.tileentity.GenericTileEntity;
import mcjty.lib.tileentity.TickingTileEntity;
import mcjty.lib.typed.Key;
import mcjty.lib.typed.Type;
import mcjty.lib.typed.TypedMap;
import mcjty.lib.varia.BlockPosTools;
import mcjty.lib.varia.Cached;
import mcjty.lib.varia.OrientationTools;
import mcjty.lib.varia.Tools;
import mcjty.rftoolsbase.api.xnet.channels.IChannelSettings;
import mcjty.rftoolsbase.api.xnet.channels.IChannelType;
import mcjty.rftoolsbase.api.xnet.channels.IConnectorSettings;
import mcjty.rftoolsbase.api.xnet.channels.IConsumerProvider;
import mcjty.rftoolsbase.api.xnet.channels.IControllerContext;
import mcjty.rftoolsbase.api.xnet.keys.ConsumerId;
import mcjty.rftoolsbase.api.xnet.keys.NetworkId;
import mcjty.rftoolsbase.api.xnet.keys.SidedConsumer;
import mcjty.rftoolsbase.api.xnet.keys.SidedPos;
import mcjty.rftoolsbase.api.xnet.net.IWorldBlob;
import mcjty.rftoolsbase.modules.filter.items.FilterModuleItem;
import mcjty.rftoolsbase.tools.ManualHelper;
import mcjty.xnet.XNet;
import mcjty.xnet.client.ChannelClientInfo;
import mcjty.xnet.client.ConnectedBlockClientInfo;
import mcjty.xnet.client.ConnectorClientInfo;
import mcjty.xnet.client.ConnectorInfo;
import mcjty.xnet.compat.XNetTOPDriver;
import mcjty.xnet.logic.LogicTools;
import mcjty.xnet.modules.cables.CableModule;
import mcjty.xnet.modules.cables.blocks.ConnectorBlock;
import mcjty.xnet.modules.cables.blocks.ConnectorTileEntity;
import mcjty.xnet.modules.controller.ChannelInfo;
import mcjty.xnet.modules.controller.ConnectedBlockInfo;
import mcjty.xnet.modules.controller.ControllerModule;
import mcjty.xnet.modules.controller.KnownUnsidedBlocks;
import mcjty.xnet.modules.controller.network.PacketControllerError;
import mcjty.xnet.modules.controller.network.PacketJsonToClipboard;
import mcjty.xnet.multiblock.ColorId;
import mcjty.xnet.multiblock.NetworkChecker;
import mcjty.xnet.multiblock.WorldBlob;
import mcjty.xnet.multiblock.XNetBlobData;
import mcjty.xnet.multiblock.XNetWirelessChannels;
import mcjty.xnet.setup.Config;
import mcjty.xnet.setup.XNetMessages;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.util.Lazy;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.network.NetworkDirection;
import org.apache.commons.lang3.tuple.Pair;

public final class TileEntityController
extends TickingTileEntity
implements IControllerContext {
    public static final Key<Integer> PARAM_INDEX = new Key("index", Type.INTEGER);
    public static final String JSON_TYPE = "type";
    public static final Key<String> PARAM_TYPE = new Key("type", Type.STRING);
    public static final Key<String> PARAM_JSON = new Key("json", Type.STRING);
    public static final String JSON_CHANNEL = "channel";
    public static final Key<Integer> PARAM_CHANNEL = new Key("channel", Type.INTEGER);
    public static final Key<Integer> PARAM_SIDE = new Key("side", Type.INTEGER);
    public static final Key<BlockPos> PARAM_POS = new Key("pos", Type.BLOCKPOS);
    public static final BooleanProperty ERROR = BooleanProperty.m_61465_((String)"error");
    public static final int SLOT_FILTER = 0;
    public static final int FILTER_SLOTS = 4;
    public static final String JSON_CONNECTOR = "cn";
    public static final String JSON_NAME = "n";
    public static final String JSON_ADVANCED = "ad";
    public static final String JSON_BLOCK = "b";
    public static final String JSON_CONNECTORS = "cns";
    public List<ChannelClientInfo> clientChannels = null;
    public List<ConnectedBlockClientInfo> clientConnectedBlocks = null;
    private final Predicate<ItemStack>[] filterCaches = new Predicate[4];
    public static final Lazy<ContainerFactory> CONTAINER_FACTORY = Lazy.of(() -> new ContainerFactory(4).box(SlotDefinition.specific(s -> s.m_41720_() instanceof FilterModuleItem), 0, 17, 5, 4, 1).playerSlots(91, 157));
    private NetworkId networkId;
    private int wirelessVersion = -1;
    private final ChannelInfo[] channels = new ChannelInfo[8];
    private int colors = 0;
    private final Map<SidedConsumer, IConnectorSettings>[] cachedConnectors = new Map[8];
    private final Map<SidedConsumer, IConnectorSettings>[] cachedRoutedConnectors = new Map[8];
    @Cap(type=CapType.ITEMS_AUTOMATION)
    private final GenericItemHandler items = GenericItemHandler.create((GenericTileEntity)this, CONTAINER_FACTORY).itemValid((slot, stack) -> stack.m_41720_() instanceof FilterModuleItem).onUpdate((slot, stack) -> this.clearFilterCache()).build();
    @Cap(type=CapType.ENERGY)
    private final GenericEnergyStorage energyStorage = new GenericEnergyStorage((GenericTileEntity)this, true, (long)((Integer)Config.controllerMaxRF.get()).intValue(), (long)((Integer)Config.controllerRfPerTick.get()).intValue());
    @Cap(type=CapType.CONTAINER)
    private final LazyOptional<MenuProvider> screenHandler = LazyOptional.of(() -> new DefaultContainerProvider("Controller").containerSupplier(DefaultContainerProvider.container(ControllerModule.CONTAINER_CONTROLLER, CONTAINER_FACTORY, (GenericTileEntity)this)).itemHandler(() -> this.items).energyHandler(() -> this.energyStorage).setupSync((GenericTileEntity)this));
    private final Cached<NetworkChecker> networkChecker = Cached.of(this::createNetworkChecker);
    @ServerCommand
    public static final Command<?> CMD_CREATECONNECTOR = Command.create((String)"controller.createConnector", (te, player, params) -> te.createConnector((Integer)params.get(PARAM_CHANNEL), new SidedPos((BlockPos)params.get(PARAM_POS), OrientationTools.DIRECTION_VALUES[(Integer)params.get(PARAM_SIDE)])));
    @ServerCommand
    public static final Command<?> CMD_REMOVECONNECTOR = Command.create((String)"controller.removeConnector", (te, player, params) -> te.removeConnector((Integer)params.get(PARAM_CHANNEL), new SidedPos((BlockPos)params.get(PARAM_POS), OrientationTools.DIRECTION_VALUES[(Integer)params.get(PARAM_SIDE)])));
    @ServerCommand
    public static final Command<?> CMD_UPDATECONNECTOR = Command.create((String)"controller.updateConnector", (te, player, params) -> te.updateConnector((Integer)params.get(PARAM_CHANNEL), new SidedPos((BlockPos)params.get(PARAM_POS), OrientationTools.DIRECTION_VALUES[(Integer)params.get(PARAM_SIDE)]), params));
    @ServerCommand
    public static final Command<?> CMD_CREATECHANNEL = Command.create((String)"controller.createChannel", (te, player, params) -> te.createChannel((Integer)params.get(PARAM_INDEX), (String)params.get(PARAM_TYPE)));
    @ServerCommand
    public static final Command<?> CMD_PASTECHANNEL = Command.create((String)"controller.pasteChannel", (te, player, params) -> te.pasteChannel(player, (Integer)params.get(PARAM_INDEX), (String)params.get(PARAM_JSON)));
    @ServerCommand
    public static final Command<?> CMD_COPYCHANNEL = Command.create((String)"controller.copyChannel", (te, player, params) -> te.copyChannel(player, (Integer)params.get(PARAM_INDEX)));
    @ServerCommand
    public static final Command<?> CMD_PASTECONNECTOR = Command.create((String)"controller.pasteConnector", (te, player, params) -> te.pasteConnector(player, (Integer)params.get(PARAM_INDEX), new SidedPos((BlockPos)params.get(PARAM_POS), OrientationTools.DIRECTION_VALUES[(Integer)params.get(PARAM_SIDE)]), (String)params.get(PARAM_JSON)));
    @ServerCommand
    public static final Command<?> CMD_COPYCONNECTOR = Command.create((String)"controller.copyConnector", (te, player, params) -> te.copyConnector(player, (Integer)params.get(PARAM_INDEX), new SidedPos((BlockPos)params.get(PARAM_POS), OrientationTools.DIRECTION_VALUES[(Integer)params.get(PARAM_SIDE)])));
    @ServerCommand
    public static final Command<?> CMD_REMOVECHANNEL = Command.create((String)"controller.removeChannel", (te, player, params) -> te.removeChannel((Integer)params.get(PARAM_INDEX)));
    @ServerCommand
    public static final Command<?> CMD_UPDATECHANNEL = Command.create((String)"controller.updateChannel", (te, player, params) -> te.updateChannel((Integer)params.get(PARAM_CHANNEL), params));
    @ServerCommand(type=ChannelClientInfo.class, serializer=ChannelClientInfo.Serializer.class)
    public static final ListCommand<?, ?> CMD_GETCHANNELS = ListCommand.create((String)"xnet.controller.getChannelInfo", (te, player, params) -> te.findChannelInfo(), (te, player, params, list) -> {
        te.clientChannels = list;
    });
    @ServerCommand(type=ConnectedBlockClientInfo.class, serializer=ConnectedBlockClientInfo.Serializer.class)
    public static final ListCommand<?, ?> CMD_GETCONNECTEDBLOCKS = ListCommand.create((String)"xnet.controller.getConnectedBlocks", (te, player, params) -> te.findConnectedBlocksForClient(), (te, player, params, list) -> {
        te.clientConnectedBlocks = list;
    });

    public TileEntityController(BlockPos pos, BlockState state) {
        super((BlockEntityType)ControllerModule.TYPE_CONTROLLER.get(), pos, state);
        for (int i = 0; i < 8; ++i) {
            this.channels[i] = null;
        }
    }

    private void clearFilterCache() {
        for (int i = 0; i < 4; ++i) {
            this.filterCaches[i] = null;
        }
    }

    @Nonnull
    public Predicate<ItemStack> getIndexedFilter(int idx) {
        if (idx < 0 || idx >= 4) {
            return stack -> false;
        }
        if (this.filterCaches[idx] == null) {
            ItemStack stack2 = this.items.getStackInSlot(idx);
            this.filterCaches[idx] = stack2.m_41720_() instanceof FilterModuleItem ? FilterModuleItem.getCache((ItemStack)stack2) : s -> false;
        }
        return this.filterCaches[idx];
    }

    public static BaseBlock createBlock() {
        return new BaseBlock(new BlockBuilder().topDriver((TOPDriver)XNetTOPDriver.DRIVER).tileEntitySupplier(TileEntityController::new).manualEntry(ManualHelper.create((String)"xnet:simple/controller")).info(new InfoLine[]{TooltipBuilder.key((String)"message.xnet.shiftmessage")}).infoShift(new InfoLine[]{TooltipBuilder.header()})){

            protected void m_7926_(@Nonnull StateDefinition.Builder<Block, BlockState> builder) {
                super.m_7926_(builder);
                builder.m_61104_(new Property[]{ERROR});
            }
        };
    }

    private NetworkChecker createNetworkChecker() {
        NetworkChecker checker = new NetworkChecker();
        checker.add(this.networkId);
        WorldBlob worldBlob = XNetBlobData.get(this.f_58857_).getWorldBlob(this.f_58857_);
        LogicTools.forEachRouter(this.f_58857_, this.networkId, router -> {
            checker.add(worldBlob.getNetworksAt(router.m_58899_()));
            NetworkId routerNetwork = worldBlob.getNetworkAt(router.m_58899_());
            if (routerNetwork != null) {
                LogicTools.forEachRouter(this.f_58857_, routerNetwork, r -> {
                    if (r != router) {
                        LogicTools.forEachConnector(this.f_58857_, r.m_58899_(), connectorPos -> checker.add(worldBlob.getNetworkAt((BlockPos)connectorPos)));
                    }
                });
            }
        });
        return checker;
    }

    public Level getControllerWorld() {
        return this.f_58857_;
    }

    public NetworkId getNetworkId() {
        return this.networkId;
    }

    public void setNetworkId(NetworkId networkId) {
        if (networkId == null && this.networkId == null) {
            return;
        }
        if (networkId != null && networkId.equals((Object)this.networkId)) {
            return;
        }
        this.networkChecker.clear();
        this.networkId = networkId;
        this.markDirtyQuick();
    }

    public ChannelInfo[] getChannels() {
        return this.channels;
    }

    public Cached<NetworkChecker> getNetworkChecker() {
        return this.networkChecker;
    }

    private void checkNetwork(WorldBlob worldBlob) {
        if (this.networkId != null && ((NetworkChecker)this.networkChecker.get()).isDirtyAndMarkClean(worldBlob)) {
            this.cleanCaches();
            return;
        }
        XNetWirelessChannels channels = XNetWirelessChannels.get(this.f_58857_);
        if (this.wirelessVersion != channels.getGlobalChannelVersion()) {
            this.wirelessVersion = channels.getGlobalChannelVersion();
            this.m_6596_();
            this.cleanCaches();
        }
    }

    private void cleanCaches() {
        for (int i = 0; i < 8; ++i) {
            if (this.channels[i] == null) continue;
            this.cleanCache(i);
        }
    }

    public boolean matchColor(int colorMask) {
        return (this.colors & colorMask) == colorMask;
    }

    public int getColors() {
        return this.colors;
    }

    public void tickServer() {
        WorldBlob worldBlob = XNetBlobData.get(this.f_58857_).getWorldBlob(this.f_58857_);
        BlockState state = this.f_58857_.m_8055_(this.f_58858_);
        if (worldBlob.getNetworksAt(this.m_58899_()).size() > 1) {
            if (!((Boolean)state.m_61143_((Property)ERROR)).booleanValue()) {
                this.f_58857_.m_7731_(this.f_58858_, (BlockState)state.m_61124_((Property)ERROR, (Comparable)Boolean.valueOf(true)), 3);
            }
            return;
        }
        if (((Boolean)state.m_61143_((Property)ERROR)).booleanValue()) {
            this.f_58857_.m_7731_(this.f_58858_, (BlockState)state.m_61124_((Property)ERROR, (Comparable)Boolean.valueOf(false)), 3);
        }
        this.checkNetwork(worldBlob);
        if (!this.checkAndConsumeRF((Integer)Config.controllerRFT.get())) {
            return;
        }
        boolean dirty = false;
        int newcolors = 0;
        for (int i = 0; i < 8; ++i) {
            if (this.channels[i] == null || !this.channels[i].isEnabled()) continue;
            if (this.checkAndConsumeRF((Integer)Config.controllerChannelRFT.get())) {
                this.channels[i].getChannelSettings().tick(i, (IControllerContext)this);
            }
            newcolors |= this.channels[i].getChannelSettings().getColors();
            dirty = true;
        }
        if (newcolors != this.colors) {
            dirty = true;
            this.colors = newcolors;
        }
        if (dirty) {
            this.markDirtyQuick();
        }
    }

    public boolean checkAndConsumeRF(int rft) {
        if (rft > 0) {
            if (this.energyStorage.getEnergy() < (long)rft) {
                return false;
            }
            this.energyStorage.consumeEnergy((long)rft);
            this.markDirtyQuick();
        }
        return true;
    }

    private void networkDirty() {
        if (this.networkId != null) {
            XNetBlobData.get(this.f_58857_).getWorldBlob(this.f_58857_).markNetworkDirty(this.networkId);
        }
    }

    private void cleanCache(int channel) {
        this.cachedConnectors[channel] = null;
        this.cachedRoutedConnectors[channel] = null;
        this.channels[channel].getChannelSettings().cleanCache();
    }

    @Nonnull
    public Map<SidedConsumer, IConnectorSettings> getConnectors(int channel) {
        if (this.cachedConnectors[channel] == null) {
            WorldBlob worldBlob = XNetBlobData.get(this.f_58857_).getWorldBlob(this.f_58857_);
            this.cachedConnectors[channel] = new HashMap<SidedConsumer, IConnectorSettings>();
            for (Map.Entry<SidedConsumer, ConnectorInfo> entry : this.channels[channel].getConnectors().entrySet()) {
                SidedConsumer sidedConsumer = entry.getKey();
                BlockPos pos = this.findConsumerPosition(sidedConsumer.consumerId());
                if (pos == null || !worldBlob.getNetworksAt(pos).contains(this.getNetworkId())) continue;
                this.cachedConnectors[channel].put(sidedConsumer, entry.getValue().getConnectorSettings());
            }
        }
        return this.cachedConnectors[channel];
    }

    @Nonnull
    public Map<SidedConsumer, IConnectorSettings> getRoutedConnectors(int channel) {
        if (this.cachedRoutedConnectors[channel] == null) {
            this.cachedRoutedConnectors[channel] = new HashMap<SidedConsumer, IConnectorSettings>();
            if (!this.channels[channel].getChannelName().isEmpty()) {
                LogicTools.forEachRouter(this.f_58857_, this.networkId, router -> router.addRoutedConnectors(this.cachedRoutedConnectors[channel], this.m_58899_(), channel, this.channels[channel].getType()));
            }
        }
        return this.cachedRoutedConnectors[channel];
    }

    public void m_183515_(@Nonnull CompoundTag tagCompound) {
        if (this.networkId != null) {
            tagCompound.m_128405_("networkId", this.networkId.id());
        }
        super.m_183515_(tagCompound);
    }

    public void m_142466_(CompoundTag tagCompound) {
        super.m_142466_(tagCompound);
        this.networkId = tagCompound.m_128441_("networkId") ? new NetworkId(tagCompound.m_128451_("networkId")) : null;
    }

    protected void saveInfo(CompoundTag tagCompound) {
        super.saveInfo(tagCompound);
        CompoundTag info = this.getOrCreateInfo(tagCompound);
        info.m_128405_("colors", this.colors);
        for (int i = 0; i < 8; ++i) {
            if (this.channels[i] == null) continue;
            CompoundTag tc = new CompoundTag();
            tc.m_128359_(JSON_TYPE, this.channels[i].getType().getID());
            this.channels[i].writeToNBT(tc);
            info.m_128365_(JSON_CHANNEL + i, (Tag)tc);
        }
    }

    public void loadInfo(CompoundTag tagCompound) {
        super.loadInfo(tagCompound);
        CompoundTag info = tagCompound.m_128469_("Info");
        this.colors = info.m_128451_("colors");
        for (int i = 0; i < 8; ++i) {
            if (info.m_128441_(JSON_CHANNEL + i)) {
                CompoundTag tc = info.m_128469_(JSON_CHANNEL + i);
                String id = tc.m_128461_(JSON_TYPE);
                IChannelType type = XNet.xNetApi.findType(id);
                if (type == null) {
                    XNet.setup.getLogger().warn("Unsupported type " + id + "!");
                    continue;
                }
                this.channels[i] = new ChannelInfo(type);
                this.channels[i].readFromNBT(tc);
                continue;
            }
            this.channels[i] = null;
        }
    }

    @Nullable
    public BlockPos findConsumerPosition(@Nonnull ConsumerId consumerId) {
        WorldBlob worldBlob = XNetBlobData.get(this.f_58857_).getWorldBlob(this.f_58857_);
        return this.findConsumerPosition(worldBlob, consumerId);
    }

    @Nullable
    private BlockPos findConsumerPosition(@Nonnull WorldBlob worldBlob, @Nonnull ConsumerId consumerId) {
        return worldBlob.getConsumerPosition(consumerId);
    }

    public List<SidedPos> getConnectedBlockPositions() {
        WorldBlob worldBlob = XNetBlobData.get(this.f_58857_).getWorldBlob(this.f_58857_);
        ArrayList<SidedPos> result = new ArrayList<SidedPos>();
        this.forEachConsumer(worldBlob, consumerPos -> {
            BlockEntity te = this.f_58857_.m_7702_(consumerPos);
            if (!(te instanceof ConnectorTileEntity)) {
                XNet.setup.getLogger().warn("What? The connector at " + BlockPosTools.toString((BlockPos)consumerPos) + " is not a connector?");
            }
            for (Direction facing : OrientationTools.DIRECTION_VALUES) {
                if (!ConnectorBlock.isConnectable((BlockGetter)this.f_58857_, consumerPos, facing)) continue;
                BlockPos pos = consumerPos.m_121945_(facing);
                SidedPos sidedPos = new SidedPos(pos, facing.m_122424_());
                result.add(sidedPos);
            }
        });
        return result;
    }

    @Nonnull
    private List<ConnectedBlockClientInfo> findConnectedBlocksForClient() {
        WorldBlob worldBlob = XNetBlobData.get(this.f_58857_).getWorldBlob(this.f_58857_);
        HashSet set = new HashSet();
        this.forEachConsumer(worldBlob, consumerPos -> {
            String name = "";
            BlockEntity te = this.f_58857_.m_7702_(consumerPos);
            if (te instanceof ConnectorTileEntity) {
                name = ((ConnectorTileEntity)te).getConnectorName();
            } else {
                XNet.setup.getLogger().warn("What? The connector at " + BlockPosTools.toString((BlockPos)consumerPos) + " is not a connector?");
            }
            for (Direction facing : OrientationTools.DIRECTION_VALUES) {
                if (!ConnectorBlock.isConnectable((BlockGetter)this.f_58857_, consumerPos, facing)) continue;
                BlockPos pos = consumerPos.m_121945_(facing);
                SidedPos sidedPos = new SidedPos(pos, facing.m_122424_());
                BlockState state = this.f_58857_.m_8055_(pos);
                ItemStack item = state.m_60734_().m_7397_((BlockGetter)this.f_58857_, pos, state);
                ConnectedBlockClientInfo info = new ConnectedBlockClientInfo(sidedPos, item, name);
                set.add(info);
            }
        });
        ArrayList<ConnectedBlockClientInfo> list = new ArrayList<ConnectedBlockClientInfo>(set);
        list.sort(Comparator.comparing(ConnectedBlockClientInfo::getBlockUnlocName).thenComparing(ConnectedBlockClientInfo::getPos));
        return list;
    }

    private void forEachConsumer(WorldBlob worldBlob, Consumer<BlockPos> consumer) {
        for (IConsumerProvider provider : XNet.xNetApi.getConsumerProviders()) {
            for (BlockPos pos : provider.getConsumers(this.f_58857_, (IWorldBlob)worldBlob, this.getNetworkId())) {
                consumer.accept(pos);
            }
        }
    }

    @Nonnull
    private List<ChannelClientInfo> findChannelInfo() {
        WorldBlob worldBlob = XNetBlobData.get(this.f_58857_).getWorldBlob(this.f_58857_);
        ArrayList<ChannelClientInfo> chanList = new ArrayList<ChannelClientInfo>();
        for (ChannelInfo channel : this.channels) {
            if (channel != null) {
                ChannelClientInfo clientInfo = new ChannelClientInfo(channel.getChannelName(), channel.getType(), channel.getChannelSettings(), channel.isEnabled());
                for (Map.Entry<SidedConsumer, ConnectorInfo> entry : channel.getConnectors().entrySet()) {
                    BlockPos consumerPos;
                    SidedConsumer sidedConsumer = entry.getKey();
                    ConnectorInfo info = entry.getValue();
                    if (info.getConnectorSettings() == null || (consumerPos = this.findConsumerPosition(worldBlob, sidedConsumer.consumerId())) == null) continue;
                    SidedPos pos = new SidedPos(consumerPos.m_121945_(sidedConsumer.side()), sidedConsumer.side().m_122424_());
                    boolean advanced = this.f_58857_.m_8055_(consumerPos).m_60734_() == CableModule.ADVANCED_CONNECTOR.get();
                    ConnectorClientInfo ci = new ConnectorClientInfo(pos, sidedConsumer.consumerId(), channel.getType(), info.getConnectorSettings());
                    clientInfo.getConnectors().put(sidedConsumer, ci);
                }
                chanList.add(clientInfo);
                continue;
            }
            chanList.add(null);
        }
        return chanList;
    }

    private void updateChannel(int channel, TypedMap params) {
        HashMap<String, Object> data = new HashMap<String, Object>();
        for (Key key : params.getKeys()) {
            data.put(key.name(), params.get(key));
        }
        this.channels[channel].getChannelSettings().update(data);
        Boolean enabled = (Boolean)data.get("enabled");
        this.channels[channel].setEnabled(Boolean.TRUE.equals(enabled));
        String name = (String)data.get("name");
        this.channels[channel].setChannelName(name);
        XNetWirelessChannels channels = XNetWirelessChannels.get(this.f_58857_);
        channels.updateGlobalChannelVersion();
        this.markAsDirty();
    }

    public void markAsDirty() {
        this.networkDirty();
        this.markDirtyQuick();
    }

    private void removeChannel(int channel) {
        this.channels[channel] = null;
        this.cachedConnectors[channel] = null;
        this.cachedRoutedConnectors[channel] = null;
        this.markAsDirty();
    }

    private void createChannel(int channel, String typeId) {
        IChannelType type = XNet.xNetApi.findType(typeId);
        this.channels[channel] = new ChannelInfo(type);
        this.markAsDirty();
    }

    private void updateConnector(int channel, SidedPos pos, TypedMap params) {
        WorldBlob worldBlob = XNetBlobData.get(this.f_58857_).getWorldBlob(this.f_58857_);
        ConsumerId consumerId = worldBlob.getConsumerAt(pos.pos().m_121945_(pos.side()));
        for (Map.Entry<SidedConsumer, ConnectorInfo> entry : this.channels[channel].getConnectors().entrySet()) {
            SidedConsumer key = entry.getKey();
            if (!key.consumerId().equals((Object)consumerId) || !key.side().m_122424_().equals((Object)pos.side())) continue;
            HashMap<String, Object> data = new HashMap<String, Object>();
            for (Key k : params.getKeys()) {
                data.put(k.name(), params.get(k));
            }
            this.channels[channel].getConnectors().get(key).getConnectorSettings().update(data);
            this.markAsDirty();
            return;
        }
    }

    private void removeConnector(int channel, SidedPos pos) {
        WorldBlob worldBlob = XNetBlobData.get(this.f_58857_).getWorldBlob(this.f_58857_);
        ConsumerId consumerId = worldBlob.getConsumerAt(pos.pos().m_121945_(pos.side()));
        SidedConsumer toremove = null;
        for (Map.Entry<SidedConsumer, ConnectorInfo> entry : this.channels[channel].getConnectors().entrySet()) {
            SidedConsumer key = entry.getKey();
            if (!key.side().m_122424_().equals((Object)pos.side()) || !key.consumerId().equals((Object)consumerId)) continue;
            toremove = key;
            break;
        }
        if (toremove != null) {
            this.channels[channel].getConnectors().remove(toremove);
            this.markAsDirty();
        }
    }

    private ConnectorInfo createConnector(int channel, SidedPos pos) {
        BlockPos consumerPos;
        WorldBlob worldBlob = XNetBlobData.get(this.f_58857_).getWorldBlob(this.f_58857_);
        ConsumerId consumerId = worldBlob.getConsumerAt(consumerPos = pos.pos().m_121945_(pos.side()));
        if (consumerId == null) {
            throw new RuntimeException("What?");
        }
        SidedConsumer id = new SidedConsumer(consumerId, pos.side().m_122424_());
        boolean advanced = this.f_58857_.m_8055_(consumerPos).m_60734_() == CableModule.ADVANCED_CONNECTOR.get();
        ConnectorInfo info = this.channels[channel].createConnector(id, advanced);
        this.markAsDirty();
        return info;
    }

    private IConnectorSettings findConnectorSettings(ChannelInfo channel, SidedPos p) {
        WorldBlob worldBlob = XNetBlobData.get(this.f_58857_).getWorldBlob(this.f_58857_);
        for (Map.Entry<SidedConsumer, ConnectorInfo> entry : channel.getConnectors().entrySet()) {
            SidedPos pos;
            BlockPos consumerPos;
            SidedConsumer sidedConsumer = entry.getKey();
            ConnectorInfo info = entry.getValue();
            if (info.getConnectorSettings() == null || (consumerPos = this.findConsumerPosition(worldBlob, sidedConsumer.consumerId())) == null || !(pos = new SidedPos(consumerPos.m_121945_(sidedConsumer.side()), sidedConsumer.side().m_122424_())).equals((Object)p)) continue;
            return info.getConnectorSettings();
        }
        return null;
    }

    private void forEachConnectedBlock(Consumer<ConnectedBlockInfo> consumer) {
        WorldBlob worldBlob = XNetBlobData.get(this.f_58857_).getWorldBlob(this.f_58857_);
        this.forEachConsumer(worldBlob, consumerPos -> {
            String name = "";
            BlockEntity te = this.f_58857_.m_7702_(consumerPos);
            if (te instanceof ConnectorTileEntity) {
                name = ((ConnectorTileEntity)te).getConnectorName();
            } else {
                XNet.setup.getLogger().warn("What? The connector at " + BlockPosTools.toString((BlockPos)consumerPos) + " is not a connector?");
            }
            for (Direction facing : OrientationTools.DIRECTION_VALUES) {
                if (!ConnectorBlock.isConnectable((BlockGetter)this.f_58857_, consumerPos, facing)) continue;
                BlockPos pos = consumerPos.m_121945_(facing);
                SidedPos sidedPos = new SidedPos(pos, facing.m_122424_());
                BlockState state = this.f_58857_.m_8055_(pos);
                state = state.m_60795_() ? null : state;
                ConnectedBlockInfo info = new ConnectedBlockInfo(sidedPos, state, name);
                consumer.accept(info);
            }
        });
    }

    private void copyConnector(Player player, int index, SidedPos sidedPos) {
        JsonObject object;
        ChannelInfo channel = this.channels[index];
        JsonObject parent = new JsonObject();
        IConnectorSettings connectorSettings = this.findConnectorSettings(channel, sidedPos);
        if (connectorSettings != null && (object = connectorSettings.writeToJson()) != null) {
            parent.add(JSON_TYPE, (JsonElement)new JsonPrimitive(channel.getType().getID()));
            parent.add(JSON_CONNECTOR, (JsonElement)object);
            boolean advanced = ConnectorBlock.isAdvancedConnector(this.f_58857_, sidedPos.pos().m_121945_(sidedPos.side()));
            parent.add(JSON_ADVANCED, (JsonElement)new JsonPrimitive(Boolean.valueOf(advanced)));
            Gson gson = new GsonBuilder().create();
            String json = gson.toJson((JsonElement)parent);
            XNetMessages.INSTANCE.sendTo((Object)new PacketJsonToClipboard(json), ((ServerPlayer)player).f_8906_.f_9742_, NetworkDirection.PLAY_TO_CLIENT);
            return;
        }
        XNetMessages.INSTANCE.sendTo((Object)new PacketControllerError("Error copying connector!"), ((ServerPlayer)player).f_8906_.f_9742_, NetworkDirection.PLAY_TO_CLIENT);
    }

    private void copyChannel(Player player, int index) {
        ChannelInfo channel = this.channels[index];
        IChannelSettings settings = channel.getChannelSettings();
        JsonObject parent = new JsonObject();
        JsonObject channelObject = settings.writeToJson();
        if (channelObject != null) {
            parent.add(JSON_TYPE, (JsonElement)new JsonPrimitive(channel.getType().getID()));
            parent.add(JSON_NAME, (JsonElement)new JsonPrimitive(channel.getChannelName()));
            parent.add(JSON_CHANNEL, (JsonElement)channelObject);
            JsonArray connectors = new JsonArray();
            this.forEachConnectedBlock(connectedBlock -> {
                JsonObject object;
                SidedPos sidedPos = connectedBlock.getPos();
                IConnectorSettings connectorSettings = this.findConnectorSettings(channel, sidedPos);
                if (connectorSettings != null && (object = connectorSettings.writeToJson()) != null) {
                    JsonObject connectorObject = new JsonObject();
                    connectorObject.add(JSON_CONNECTOR, (JsonElement)object);
                    connectorObject.add(JSON_NAME, (JsonElement)new JsonPrimitive(connectedBlock.getName()));
                    boolean advanced = ConnectorBlock.isAdvancedConnector(this.f_58857_, sidedPos.pos().m_121945_(sidedPos.side()));
                    connectorObject.add(JSON_ADVANCED, (JsonElement)new JsonPrimitive(Boolean.valueOf(advanced)));
                    if (!connectedBlock.isAir()) {
                        BlockState state = connectedBlock.getConnectedState();
                        connectorObject.add(JSON_BLOCK, (JsonElement)new JsonPrimitive(Tools.getId((BlockState)state).toString()));
                    }
                    connectors.add((JsonElement)connectorObject);
                }
            });
            parent.add(JSON_CONNECTORS, (JsonElement)connectors);
            Gson gson = new GsonBuilder().create();
            String json = gson.toJson((JsonElement)parent);
            XNetMessages.INSTANCE.sendTo((Object)new PacketJsonToClipboard(json), ((ServerPlayer)player).f_8906_.f_9742_, NetworkDirection.PLAY_TO_CLIENT);
        } else {
            XNetMessages.INSTANCE.sendTo((Object)new PacketControllerError("Channel does not support this!"), ((ServerPlayer)player).f_8906_.f_9742_, NetworkDirection.PLAY_TO_CLIENT);
        }
    }

    private int calculateMatchingScore(IChannelType type, ConnectedBlockInfo info, String name, ResourceLocation block, @Nonnull Direction side, @Nonnull Direction facingOverride, boolean advanced, boolean advancedNeeded) {
        ResourceLocation infoBlock;
        Direction facing;
        BlockPos blockPos;
        int score = 0;
        String infoName = info.getName();
        if (!name.isEmpty() && Objects.equals(name, infoName)) {
            score += 100;
        }
        if (!type.supportsBlock(this.f_58857_, blockPos = info.getPos().pos(), facing = info.getPos().side())) {
            score -= 1000;
        }
        if (!KnownUnsidedBlocks.isUnsided(infoBlock = Tools.getId((BlockState)info.getConnectedState())) && !facingOverride.equals((Object)facing)) {
            score -= 1000;
        }
        boolean infoAdvanced = ConnectorBlock.isAdvancedConnector(this.f_58857_, blockPos.m_121945_(facing));
        if (advanced) {
            score = infoAdvanced ? (score += 50) : (advancedNeeded ? (score -= 1000) : (score -= 40));
        } else if (infoAdvanced) {
            --score;
        }
        if (!info.isAir() && Objects.equals(infoBlock, block)) {
            score += 200;
        }
        if (facing.equals((Object)side)) {
            score += 2;
        }
        return score;
    }

    private void pasteConnector(Player player, int channel, SidedPos sidedPos, String json) {
        try {
            JsonParser parser = new JsonParser();
            JsonObject root = parser.parse(json).getAsJsonObject();
            if (!root.has(JSON_CONNECTOR) || !root.has(JSON_TYPE)) {
                XNetMessages.INSTANCE.sendTo((Object)new PacketControllerError("Invalid connector json!"), ((ServerPlayer)player).f_8906_.f_9742_, NetworkDirection.PLAY_TO_CLIENT);
                return;
            }
            String typeId = root.get(JSON_TYPE).getAsString();
            IChannelType type = XNet.xNetApi.findType(typeId);
            if (type != this.channels[channel].getType()) {
                XNetMessages.INSTANCE.sendTo((Object)new PacketControllerError("Wrong channel type!"), ((ServerPlayer)player).f_8906_.f_9742_, NetworkDirection.PLAY_TO_CLIENT);
                return;
            }
            boolean advanced = root.get(JSON_ADVANCED).getAsBoolean();
            JsonObject connectorObject = root.get(JSON_CONNECTOR).getAsJsonObject();
            boolean advancedNeeded = connectorObject.get("advancedneeded").getAsBoolean();
            BlockPos blockPos = sidedPos.pos();
            Direction facing = sidedPos.side();
            Direction side = Direction.m_122402_((String)connectorObject.get("side").getAsString());
            Direction facingOverride = connectorObject.has("facingoverride") ? Direction.m_122402_((String)connectorObject.get("facingoverride").getAsString().toLowerCase()) : side;
            boolean infoAdvanced = ConnectorBlock.isAdvancedConnector(this.f_58857_, blockPos.m_121945_(facing));
            if (advanced && !infoAdvanced && (advancedNeeded || !facingOverride.equals((Object)facing))) {
                XNetMessages.INSTANCE.sendTo((Object)new PacketControllerError("Advanced connector is needed!"), ((ServerPlayer)player).f_8906_.f_9742_, NetworkDirection.PLAY_TO_CLIENT);
                return;
            }
            if (!infoAdvanced) {
                connectorObject.remove("facingoverride");
            }
            ConnectorInfo info = this.createConnector(channel, sidedPos);
            info.getConnectorSettings().readFromJson(connectorObject);
        }
        catch (JsonSyntaxException e) {
            XNetMessages.INSTANCE.sendTo((Object)new PacketControllerError("Error pasting clipboard data!"), ((ServerPlayer)player).f_8906_.f_9742_, NetworkDirection.PLAY_TO_CLIENT);
        }
        this.markAsDirty();
    }

    private void pasteChannel(Player player, int channel, String json) {
        try {
            ResourceLocation block;
            JsonParser parser = new JsonParser();
            JsonObject root = parser.parse(json).getAsJsonObject();
            if (!(root.has(JSON_CHANNEL) && root.has(JSON_TYPE) && root.has(JSON_NAME))) {
                XNetMessages.INSTANCE.sendTo((Object)new PacketControllerError("Invalid channel json!"), ((ServerPlayer)player).f_8906_.f_9742_, NetworkDirection.PLAY_TO_CLIENT);
                return;
            }
            String typeId = root.get(JSON_TYPE).getAsString();
            IChannelType type = XNet.xNetApi.findType(typeId);
            this.channels[channel] = new ChannelInfo(type);
            this.channels[channel].setChannelName(root.get(JSON_NAME).getAsString());
            this.channels[channel].getChannelSettings().readFromJson(root.get(JSON_CHANNEL).getAsJsonObject());
            this.channels[channel].setEnabled(false);
            boolean notEnoughConnectors = false;
            JsonArray connectors = root.get(JSON_CONNECTORS).getAsJsonArray();
            ArrayList<PossibleConnection> connections = new ArrayList<PossibleConnection>();
            for (JsonElement con : connectors) {
                JsonObject connector = con.getAsJsonObject();
                String name = connector.get(JSON_NAME).getAsString();
                boolean advanced = connector.get(JSON_ADVANCED).getAsBoolean();
                block = connector.has(JSON_BLOCK) ? new ResourceLocation(connector.get(JSON_BLOCK).getAsString()) : null;
                JsonObject connectorSettings = connector.get(JSON_CONNECTOR).getAsJsonObject();
                Direction side = Direction.m_122402_((String)connectorSettings.get("side").getAsString());
                Direction facingOverride = connectorSettings.has("facingoverride") ? Direction.m_122402_((String)connectorSettings.get("facingoverride").getAsString()) : side;
                boolean advancedNeeded = connectorSettings.get("advancedneeded").getAsBoolean();
                ArrayList<Pair<ConnectedBlockInfo, Integer>> sortedMatches = new ArrayList<Pair<ConnectedBlockInfo, Integer>>();
                this.forEachConnectedBlock(info -> {
                    int score = this.calculateMatchingScore(type, (ConnectedBlockInfo)info, name, block, side, facingOverride, advanced, advancedNeeded);
                    sortedMatches.add(Pair.of((Object)info, (Object)score));
                });
                sortedMatches.sort((p1, p2) -> Integer.compare((Integer)p2.getRight(), (Integer)p1.getRight()));
                if (!sortedMatches.isEmpty() && (Integer)((Pair)sortedMatches.get(0)).getRight() > -50) {
                    connections.add(new PossibleConnection(connector, sortedMatches));
                    continue;
                }
                notEnoughConnectors = true;
            }
            while (!connections.isEmpty()) {
                connections.sort((p1, p2) -> Integer.compare((Integer)p2.sortedMatches.get(0).getRight(), (Integer)p1.sortedMatches.get(0).getRight()));
                PossibleConnection pair = (PossibleConnection)connections.remove(0);
                JsonObject connector = pair.connector;
                if (pair.sortedMatches.isEmpty()) {
                    notEnoughConnectors = true;
                    break;
                }
                ConnectedBlockInfo info2 = (ConnectedBlockInfo)pair.sortedMatches.get(0).getKey();
                boolean infoAdvanced = ConnectorBlock.isAdvancedConnector(this.f_58857_, info2.getPos().pos());
                JsonObject connectorSettings = connector.get(JSON_CONNECTOR).getAsJsonObject();
                if (!infoAdvanced) {
                    connectorSettings.remove("facingoverride");
                }
                block = connector.has(JSON_BLOCK) ? new ResourceLocation(connector.get(JSON_BLOCK).getAsString()) : null;
                System.out.println("Pasting " + info2.getName() + " (" + block.toString() + " into " + Tools.getId((BlockState)info2.getConnectedState()).toString() + ") with score = " + pair.sortedMatches.get(0).getRight());
                ConnectorInfo connectorInfo = this.createConnector(channel, info2.getPos());
                connectorInfo.getConnectorSettings().readFromJson(connectorSettings);
                for (PossibleConnection connection : connections) {
                    ArrayList<Pair<ConnectedBlockInfo, Integer>> newMatches = new ArrayList<Pair<ConnectedBlockInfo, Integer>>();
                    for (Pair<ConnectedBlockInfo, Integer> match : connection.sortedMatches) {
                        if (match.getLeft() == info2) continue;
                        newMatches.add(match);
                    }
                    connection.sortedMatches = newMatches;
                }
            }
            if (notEnoughConnectors) {
                XNetMessages.INSTANCE.sendTo((Object)new PacketControllerError("Not everything could be pasted!"), ((ServerPlayer)player).f_8906_.f_9742_, NetworkDirection.PLAY_TO_CLIENT);
            }
        }
        catch (JsonSyntaxException e) {
            XNetMessages.INSTANCE.sendTo((Object)new PacketControllerError("Error pasting clipboard data!"), ((ServerPlayer)player).f_8906_.f_9742_, NetworkDirection.PLAY_TO_CLIENT);
        }
        this.markAsDirty();
    }

    public void onBlockPlacedBy(Level world, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        super.onBlockPlacedBy(world, pos, state, placer, stack);
        this.findNeighbourConnector(world, pos);
    }

    public void onReplaced(Level world, BlockPos pos, BlockState state, BlockState newstate) {
        if (state.m_60734_() == newstate.m_60734_()) {
            return;
        }
        XNetBlobData blobData = XNetBlobData.get(this.f_58857_);
        WorldBlob worldBlob = blobData.getWorldBlob(this.f_58857_);
        worldBlob.removeCableSegment(pos);
        blobData.save();
    }

    public void checkRedstone(Level world, BlockPos pos) {
        if (!world.f_46443_) {
            this.findNeighbourConnector(world, pos);
        }
    }

    private void findNeighbourConnector(Level world, BlockPos pos) {
        if (world.f_46443_) {
            return;
        }
        XNetBlobData blobData = XNetBlobData.get(world);
        WorldBlob worldBlob = blobData.getWorldBlob(world);
        ColorId oldColor = worldBlob.getColorAt(pos);
        ColorId newColor = null;
        for (Direction facing : OrientationTools.DIRECTION_VALUES) {
            ColorId color;
            if (!(world.m_8055_(pos.m_121945_(facing)).m_60734_() instanceof ConnectorBlock) || (color = worldBlob.getColorAt(pos.m_121945_(facing))) == null) continue;
            if (color == oldColor) {
                return;
            }
            newColor = color;
        }
        if (newColor != null) {
            if (worldBlob.getBlobAt(pos) != null) {
                worldBlob.removeCableSegment(pos);
            }
            NetworkId networkId = worldBlob.newNetwork();
            worldBlob.createNetworkProvider(pos, newColor, networkId);
            blobData.save();
            BlockEntity te = world.m_7702_(pos);
            if (te instanceof TileEntityController) {
                ((TileEntityController)te).setNetworkId(networkId);
            }
        }
    }

    private static class PossibleConnection {
        private final JsonObject connector;
        private List<Pair<ConnectedBlockInfo, Integer>> sortedMatches;

        public PossibleConnection(JsonObject connector, List<Pair<ConnectedBlockInfo, Integer>> sortedMatches) {
            this.connector = connector;
            this.sortedMatches = sortedMatches;
        }
    }
}

